; print.asm:
; prints a file given as command line parameter to lpt1
; (c) Daniel Gruen, 2006
; License: GNU General Public License (GPL) Version 2
; No Warranty whatsoever!

section	.text
global	_start

lp1_port equ	0x378	; my lp port, change this accordingly

struc timespec          ; model for "nanosleep" structure .
second:   resd 1 
nanosec:  resd 1 
endstruc

_start:
	mov	eax,4	; sys_write
	mov	ebx,1	; stdout
	mov	ecx,tgreeting
	mov	edx,37	; length
	int 	0x80

	; step 0: get port permissions
	mov	eax, 101	; sys_ioperm
	mov	ebx, lp1_port	; from
	mov	ecx, 3		; num
	mov	edx, 1		; turn on
	int	0x80		; kernel call

	inc	eax		; is return value 0 = ok?
	jnz	cont1		; go on unless eax was -1

	call	error_exit

cont1:
	; read & print characters
	; step 1: open file
	mov	eax,5	; sys_open
	pop	ebx	; argc
	pop	ebx	; argv[0]
	pop	ebx	; argv [1] should be the argument: filename
	mov	ecx,0	; O_RDONLY -- we hope it exists
	int	0x80	; kernel call

	test	eax,eax	; check returned value
	jns	cont2	; go on if not signed (=if positive)

	call	error_exit

cont2:
	push	eax	; save fd

	mov	eax,4	; sys_write
	mov	ebx,1	; stdout
	mov	ecx,tinit
	mov	edx,41	; length
	int 	0x80	; kernel call

rploop:
	; step 2: read char
	mov	eax,3	; sys_read
	pop	ebx	; file descriptor (fd)
	mov	ecx,buffer ; address to read to
	mov 	edx,1	; should be type size_t...
	int	0x80	; kernel call

	push	ebx	; save fd
	push	eax	; save number of read bytes

	mov	ax,[buffer]
	call	putc

	; step 3: print char

	; step 3a: send char on data port
	mov	ax,[buffer]
	mov 	dx,lp1_port
	out	dx,al

	; step 3b: read status byte
	mov	dx,lp1_port+2	
	in	al,dx

	; step 3c: set strobe high
	or	al,0x01

	; step 3d: write high strobe status byte
	mov	dx,lp1_port+2
	out	dx,al

	; step 3e: read status byte
	mov	dx,lp1_port+2
	in	al,dx

	; step 3f: set strobe low
	and	al,0xfe

	; step 3g: write low strobe status byte
	mov	dx,lp1_port+2
	out	dx,al

	; step 3h: wait for ack signal
	mov	ebx,100
lack:	mov	dx,lp1_port+2

	mov	dx,lp1_port+2
	in	al,dx

	and	al,0x40

	jz	pend

	mov eax,162     ; sys_nanosleep
        mov ebx,temp1   ; time strucure
        mov ecx,0	; no safetz net in case of signals
        int 80h		; kernel call

	push	ebx
	mov	eax,'w'
	call	putc
	pop	ebx

	dec	ebx
	jnz	lack	; acknowledge waiting loop

	; step 4: repeat if neccessary

pend:
	mov eax,162     ; sys_nanosleep
        mov ebx,temp1   ; time strucure
        mov ecx,0	; no safetz net in case of signals
        int 80h		; kernel call

	pop	eax
	dec	eax
	jz	rploop

	mov	ax,10
	call 	putc

	; step 5: close file
	pop	ebx	; fd

	mov	eax,1	; sys_exit
	mov	ebx,0
	int	0x80

error_exit:
	mov	eax,4	; sys_write
	mov	ebx,1	; stdout
	mov	ecx,terror
	mov	edx,28	; length
	int 	0x80	; kernel call

	mov	eax,1	; outta here (sys_exit)
	mov	ebx,1	; return code: error
	int	0x80	; kernel_call
	ret

putc:	push 	eax		; puts char in eax
	mov	eax,4 		; sys_write
	mov	ebx,1		; file descriptor -> stdout
	mov	ecx,esp  	; stack pointer -> data address 
	mov	edx,1		; length 1
	int	0x80		; kernel call
	pop	eax		; restore eax
	ret

section .data
tgreeting:
	db	'This program will call your printer.', 10, 0
tinit:
	db	'Finished initialization. Now printing...', 10, 0
terror:
	db	'An error occured. Exiting...', 10, 0
timeout_count:
	db	9 ; cycles to wait till timeout
strobe_wait:
	db	200
buffer:
	times 4 db 0
temp1      istruc timespec        
           at second,  dd 0      
           at nanosec, dd 500000
           iend 

