#include <iostream>
#include <cmath>
#include <cstdlib>

using namespace std;

double JulianDay (int date, int month, int year, double UT)
 {

if (month<=2) {month=month+12; year=year-1;}
 return (int)(365.25*year) + (int)(30.6001*(month+1)) - 15 + 1720996.5 + date + UT/24.0;

}

int main(int argc, char *argv[])
{
	double longitude = 9.0 + 26.0/60.0 + 30.0/3600.0;
	double latitude = 48.0 + 51.0/60.0 + 55.0/3600.0;
	const double pi180 = 3.1415927 / 180.0;

	if(argc!=7&&argc!=9){
		cout << "syntax: " << argv[0] << " [RA] [decl.] [day] [month] [year] [ut] ([eastern longitude] [latitude])\nunless specified: long.=" << longitude << ", lat.=" << latitude << " (Winnenden-Birkmannsweiler)" << 
		"\nexample: Mars on 13/08/2003 at 19.0UT from Berlin\n\t" << argv[0] << " 167.5 3.68 13 8 2003 19.0 13.28 52.45" << endl;
		return 0;
	}

	const double alpha = atof(argv[1]);
	const double delta = atof(argv[2]);

	if(argc==9){
		longitude=atof(argv[7]);
		latitude=atof(argv[8]);
	}

	cout << "equatorial coordinates for objekt at " << alpha << " RA, " << delta << " decl.," <<
			"\nseen from long. " << longitude << " E, lat. " << latitude << ","
			"\n" << atoi(argv[3]) << "/" << atoi(argv[4]) << "/" << atoi(argv[5]) << ", " << int(atof(argv[6])) << ":" <<
			int(60.0*(atof(argv[6]) - int(atof(argv[6])))) << " ut:\n" << endl;

	const double JD = JulianDay(atoi(argv[3]),atoi(argv[4]),atoi(argv[5]),atof(argv[6]));
	cout << "Julian day: " << JD << endl;

	const double T = (JD - 2451545.0 ) / 36525.0;
	cout << "centuries since 01/01/2000: " << T << endl;

	double theta0 = fmod(280.46061837 + 360.98564736629*(JD-2451545.0) + 0.000387933*T*T - T*T*T/38710000.0,360.0);
	if(theta0<0.0)
		theta0+=360.0;
	cout << "Greenwich sidereal time: " << theta0 << "" << endl;

	double theta = fmod(theta0 + longitude,360.0);
	if(theta<0.0)
		theta+=360.0;
	cout << "star date: " <<  theta << "" << endl;

	const double tau = theta - alpha;
	cout << "time angle: " << tau << "" << endl;

	const double sinh = sin(latitude*pi180)*sin(delta*pi180) + cos(latitude*pi180)*cos(delta*pi180)*cos(tau*pi180);

	const double tanaz = -sin(tau*pi180) / (cos(latitude*pi180)*tan(delta*pi180)-sin(latitude*pi180)*cos(tau*pi180));

	const double h = asin(sinh)/pi180;
	const double az = atan(tanaz)/pi180;
	cout << "altitude: " << h << ", azimuth: " << az << "" << endl;

	return 0;
}
