#include <iostream>
#include <cmath>
#include <cstdlib>

#define pi180 0.01745329252

using namespace std;

int main(int argc,char*argv[])
{
	if(argc!=4){
		cout<< "Syntax: " << argv[0] << " [Map] [RA] [Dekl.]" << endl; 		return 0;
	}
	const int m = atoi(argv[1]);
	const float alpha = atof(argv[2]);
	const float delta = atof(argv[3]);
	float a,d;
	switch(m){
		case 1:
			a = 30.0; d = 55.68;
			break;
		case 2:
			a = 150.0; d = 55.68;
			break;
		case 3:
			a = 270.0; d = 55.68;
			break;
		case 4:
			a = 90.0; d = 4.89;
			break;
		case 5:
			a = 210.0; d = 4.89;
			break;
		case 6:
			a = 330.0; d = 4.89;
			break;
		case 7:
			a = 30.0; d = -4.89;
			break;
		case 8:
			a = 150.0; d = -4.89;
			break;
		case 9:
			a = 270.0; d = -4.89;
			break;
		default:
			return 0;
	}
	const float R = 160.43;
	float Xo,Yo;
	if(m>=1&&m<=3||m>=7&&m<=9){
		Xo=175.0; Yo=140.0;
	}
	else{
		Yo=175.0; Xo=140.0;
	}
	const float p = sin(delta*pi180);
	const float q = cos(delta*pi180)*sin((alpha-a)*pi180);
	const float r = cos(delta*pi180)*cos((alpha-a)*pi180);
	const float s = p*sin(d*pi180)+r*cos(d*pi180);
	const float x = -q/s;
	const float y = (p*cos(d*pi180)-r*sin(d*pi180))/s;
	const float X = x*R+Xo;
	const float Y = y*R+Yo;
	cout << "m:  " << m << endl
	     << "al: " << alpha << endl
	     << "dl: " << delta << endl
	     << "a:  " << a << endl
	     << "d:  " << d << endl
	     << "R:  " << R << endl
	     << "Xo: " << Xo<< endl
	     << "Yo: " << Yo<< endl
	     << "p:  " << p << endl
	     << "q:  " << q << endl
	     << "r:  " << r << endl
	     << "s:  " << s << endl
	     << "x:  " << x << endl
	     << "y:  " << y << endl
			 << "X:  " << X << " mm from lower left corner" << endl
			 << "Y:  " << Y << " mm from lower left corner" << endl;
	return 0;
}
