<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
	<title>Draw-Maker: Schritt 3</title>
</head>
<body>

<?php

define(debug,0);

function random_order($n)
{
  global $bteam;
  global $odd;

  srand(); // seed random

  $k = log(1/(100*($n-1)))/log(($n-1)/$n); // iterations neccessary for 1.01 exacticity

  $buf=$bteam[$n-1+$odd];
  $i=1;
  while($i<=$k)
  {
   $buf2=$buf;
   $z=rand($odd,$n-2+$odd);
   $buf=$bteam[$z];
   $bteam[$z]=$buf2;
   $i++;
  }
  $bteam[$n-1+$odd]=$buf;
  if(debug){echo $i," randomization operations\n<br>\n";}
}

function move_newbies()
{
  global $bteam;
  global $odd;
  global $n_new;
  global $newbie;
  global $nteams;

  if(!$odd)
  {
   for($j=0; $j<$n_new; $j++)
   {
    $newbie[$j]--;
   }
  }

  // $z: last position for a newbie
  $z=(($nteams-$n_new+$odd)/2)+$n_new;

  for($i=0; $i<$n_new; $i++)
  {
    if(debug){
      echo "moving ",$bteam[$z-$i],"(",$z-$i,") away for ",$bteam[$newbie[$i]-1+$odd],"(",$newbie[$i],")<br>";
    }
    $bufo=$bteam[$z-$i];
    $bteam[$z-$i]=$bteam[$newbie[$i]];
    for($j=0; $j<$n_new; $j++)
    {
      if($z-$i==$newbie[$j])
	$newbie[$j]=$newbie[$i]; // if we just moved a newbie away
    }
    $bteam[$newbie[$i]]=$bufo;
    $newbie[$i]=$z-$i; // for the record
  }
}

function print_game($n1, $n2)
{
  global $bteam;
  global $sidemix;
  global $round;
  
  if($sidemix == 1) // odd team is proposing
  {
    if($n2 == 0) // must alter side from round to round in this case
    {
      if($round % 2 == 0) // change sides in even round
      {
         $buf = $n1;
         $n1 = $n2;
         $n2 = $buf;
      }
    }
  
    else if($n2 % 2 == 1) // second team is odd team => change sides
    {
      $buf = $n1;
      $n1 = $n2;
      $n2 = $buf;
    }
  }
  
  if($sidemix == 2)
  {
     $odd = $n2 % 2; // 1 if n2 is odd
     if($n2 == 0) // must alter side from round to second next round in this case
     {
      if($round % 4 >= 2) // change sides 
      {
         $buf = $n1;
         $n1 = $n2;
         $n2 = $buf;
      }
     }
     else if($n2 % 4 >= 2) // n2 should be proposing
     {
       $buf = $n1;
       $n1 = $n2;
       $n2 = $buf;     
     }
  }
  
?>  
  <tr>
     <td><b><?php echo $bteam[$n1] ?></b></td>
     <td> - </td>
     <td><b><?php echo $bteam[$n2] ?></b></td>
  </tr>
<?php  

}

  $randomize=$HTTP_POST_VARS["randomize"];
  $sidemix=$HTTP_POST_VARS["insidemix"];
  $nteams=$HTTP_POST_VARS["inteams"];
  $n_new=$HTTP_POST_VARS["n_new"];
  $odd=$nteams % 2; // 1 when nteams is odd
  $nrounds=$nteams-1+$odd; // TODO: make this variable
  $i=0;
  while($i<$nteams)
  {
    $i++;
    $bteam[$i+$odd-1]=$HTTP_POST_VARS["ibteam$i"]; // ibteams starts with 1
  }
  // we have them in the array bteam now
  // note: it goes from 0 to nteams-1 when nteams is even
  // (0 is the team in the center of the polygon)
  // but from 1 to nteams when it's odd

  $newbie=$_POST["newbie"];

   if($randomize)
   {random_order($nteams);}

   if($n_new)
   {move_newbies();}

   $ngames=($nteams-$odd)/2;
   $nedges=($nteams-1+$odd);
   $n_ref=$nedges+1; // reference number for drawing
  
if(debug){
   echo "nteams=",$nteams,";\nnrounds=",$nrounds,";\nodd=",$odd,";\nngames=",$ngames,";\nnedges=",
        $nedges,";\nn_ref=",$n_ref,";\nsidemix=",$sidemix,";\nrandomize=",$randomize,";<br>";
   $i=$odd;
   while($i<($nteams+$odd))
   {
      echo $i,": bteam[",$i,"]=",$bteam[$i],"<br>";
      $i++;
   }
   $i=-1;
   while($i<$n_new-1) // for all newbie groups do
   {
      $i++;
      echo "newbie ",$i,": ",$newbie[$i],"<br>";
   }
}
   
  // TODO: error handling
?>

<h1>Schritt 3: Ihr fertiger Draw!</h1>
<br>
<hr>
<?php
  $round=0;
  while($round<$nrounds) // create all rounds
  {
    $round=$round+1;
?>
 <h2>Runde <?php echo $round; ?>:</h2>
 <table cellpadding="5">
  <?php
   $j=0;
   while($j<$ngames-1+$odd) // create all games
   {
    $j=$j+1; 
    print_game($n_ref-$j, $j+1);
   }
   if($odd)
   {
  ?>
    <tr>
     <td><b><?php echo $bteam[1] ?></b></td>
     <td></td>
     <td>hat spielfrei.</td>
    </tr>
  <?php
   }
   else // if even: bteam[1] - bteam[0]
   {
    print_game(1,0);
   }
  ?>
 </table>
 <hr>
<?php
   // rotate edges
   $buffer = $bteam[$nedges];
   for($j=$nedges; $j>1; $j--)
   {
     $bteam[$j]=$bteam[$j-1];  
   }
   $bteam[1]=$buffer;
  }
?>


</body>