#include "include/fmplayer.h"
#include <cmath>
#include <iostream>

using namespace std;

int main(int argc, char *argv[]) {

const int p0=60;

if(argc<2 || atoi(argv[1])<2)
{
	cout << "syntax: " << argv[0] << " [number of chord pairs] [seconds per event] ([wave file])" << endl;
	return 1;
}

int n = atoi(argv[1])*2; // number of tones

FMPlayer p; // seeds the random

if(argc==4)
	p.setWavFile(argv[3]);

PBSP *afirst, *arecent;
PBSP *bfirst, *brecent;


int zb[n]; // numbers of the tones, to be initialized & randomized

for(int i=0; i<n; i++)
{
	zb[i]=rand()%n;
}

int k = int(log(double(1/(100*(n-1))))/log(double((n-1)/n))); // randomization iterations neccessary for 1.01 exacticity

int buf=zb[n-1];

for(int i=0; i<k; i++) // randomizing b array
{
   int buf2=buf;
   int z=rand()%(n-1);
   buf=zb[z];
   zb[z]=buf2;
}
zb[n-1]=buf;

afirst = new PBSP;
bfirst = new PBSP;

afirst->pitch=121; // rest
bfirst->pitch=121; // rest

arecent = afirst;
brecent = bfirst;

for(int i=1; i<n; i++)
{
   for(int j=0; j<n/2-1; j++) // for all "regular" matches
   {
	arecent->next = new PBSP;
	brecent->next = new PBSP;

	arecent = arecent->next;
	brecent = brecent->next;

	arecent->pitch = p0 + zb[n/2+j];
	brecent->pitch = p0 + zb[n/2-j-1];

        if(zb[n/2+j]<2 || zb[n/2-j-1]<2) // lowest possible tone
        {
	   arecent->length=brecent->length=7; // 1/3 note
	   arecent->third=brecent->third=1;
        }
        else if(zb[n/2+j]>=n-4 || zb[n/2-j-1]>=n-4)
        {
           arecent->length=brecent->length=0; // 1/32 note
           arecent->third=brecent->third=1;
        }
	else if(rand()%3)
        {
           arecent->length=brecent->length=1; // 1/8 note
           arecent->third=brecent->third=0;
        }
        else
        {
           arecent->length=brecent->length=6; // 1/5 note
           arecent->third=brecent->third=1;
        }

   }

   arecent->next = new PBSP;
   brecent->next = new PBSP;

   arecent = arecent->next;
   brecent = brecent->next;

   arecent->pitch = p0 + zb[n-1];
   brecent->pitch = p0 + zb[0];

   // rest

   arecent->next = new PBSP;
   brecent->next = new PBSP;

   arecent = arecent->next;
   brecent = brecent->next;

   arecent->pitch = 121;
   brecent->pitch = 121;

   // rotate

   buf=zb[1];
   int buf2;
   for(int j=2; j<n; j++)
   {
	buf2 = zb[j];
	zb[j] = buf;
	buf = buf2;
   }
   zb[1]=buf;
}

// convert to PBS
k = (n/2 + 1)*(n-1); // number of events

p.aMixer->setTime(k*atof(argv[2]));

PBS a[k];
PBS b[k];

arecent = afirst;
brecent = bfirst;

for(int i=0; i<k; i++)
{
   a[i].pitch=pitch(arecent->pitch-1);
   b[i].pitch=pitch(brecent->pitch-1);
   int rb = 3;
   if(rand()%3)
	rb=1;
   a[i].beats=beats(rb,0);
   b[i].beats=beats(rb,0);
   a[i].style=b[i].style=0;

   arecent = arecent->next;
   brecent = brecent->next;
}

p.aSound->setMode(2);
p.aSound->setVlen(k);
p.aSound->pbs=a;
p.aSound->setMidi();
p.aSound->midi->initMidi();
p.aSound->midi->setMidiI(0,"sounds/tri");
p.aSound->midi->setMidiH(0,"midi/attack");
p.aSound->midi->initMidi();

p.nextSound();

p.aSound->setMode(2);
p.aSound->setVlen(k);
p.aSound->pbs=b;
p.aSound->setMidi();
p.aSound->midi->initMidi();
p.aSound->midi->setMidiI(0,"sounds/tri");
p.aSound->midi->setMidiH(0,"midi/attack");
p.aSound->midi->initMidi();

// pray, then play

p.syncPlay();

return 0;
}
