/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

using namespace std;

#include "include/fmplayer.h"
#include "include/fmplayer_player.cpp"
#include "include/fmplayer_channel.cpp"
#include "include/fmplayer_mixer.cpp"
#include "include/fmplayer_file.cpp"
#include "include/fmplayer_sound.cpp"
#include "include/fmplayer_modulator.cpp"
#include "include/fmplayer_midi.cpp"

void writeSoundByte(char * byte, bool wav, int bytes, int dspfd) {
	if(wav){
		writeWavByte(byte, bytes);
	}
	else
	  write(dspfd, byte, bytes);
}

float   ggt(float a, float b) {

	if(a < 0)
		a = a * -1;

	if(b < 0)
		b = b * -1;

	if(b>a)
		return ggt(b, a);

	if(b!=0)
		return ggt(b, fmod(a, b));

	else
		return a;
}

float   kgv(float a, float b) {

	return a*b/ggt(a, b);

}
