/**************************************************************************
                   fmval.cpp  -  central computing function
                            -------------------
    begin                : January 03rd 2003
    copyright            : (C) 2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmval.h"
#include "include/version.h"
#include "include/fmifstream.h"

#include <iostream>
#include <cmath>
#include <cstdlib>

using namespace std;

float   fmval(FMData *f, double atime){
  int v = 0;

 if(f->getMode() == 0){
	return f->val[int(atime)];
 }

 if(f->getMode() == 1){
	while(v < f->getVlen() && f->vtl[v].getTime() <= atime){
		v++;
	}
	 
#ifdef valuecore_debug
	cout << "vcd: atime = " << atime << " => v = " << v << endl;
#endif

	switch(f->vtl[v-1].getLinetype()){

	    case 0:
#ifdef valuecore_debug
		cout << "vcd: linetype zero, ignoring" << endl;
#endif	
		return -1;  // just do nothing

	    case 1:
	/* linetype 1: linear */
		return double(f->vtl[v].getValue() - f->vtl[v-1].getValue()) /
		       (f->vtl[v].getTime() - f->vtl[v-1].getTime()) *
					 (atime - f->vtl[v-1].getTime()) + f->vtl[v-1].getValue();

	    case 2:
	/* linetype 2: sine, linear beginning */
		return f->vtl[v-1].getValue() +
		       sin((atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime()) * 90.0 * PI180) *
					 (f->vtl[v].getValue() - f->vtl[v-1].getValue());

	    case 3:
	/* linetype 3: sine, curved beginning */
		return f->vtl[v].getValue() +
		       sin(((atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime()) * 90.0 + 90.0) * PI180) *
					 (f->vtl[v-1].getValue() - f->vtl[v].getValue());

	    case 4:
	/* linetype 4: gaussian part 1 */
#ifdef valuecore_debug
		cout << int(f->vtl[v-1].getValue()) << " + " << (pow(E,-pow(f->vtl[v-1].getAttr1()*(1.0-(atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime())),2.0)) - pow(E,-double(f->vtl[v-1].getAttr1()*f->vtl[v-1].getAttr1()))) << " * " << (f->vtl[v].getValue() - f->vtl[v-1].getValue()) << endl;
#endif
		return f->vtl[v-1].getValue() +
		       (pow(E,-pow(f->vtl[v-1].getAttr1()*(1.0-(atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime())),2.0))
	        - pow(E,-double(f->vtl[v-1].getAttr1()*f->vtl[v-1].getAttr1())))
			* (f->vtl[v].getValue() - f->vtl[v-1].getValue());

	    case 5:
	/* linetype 5: gaussian part 2 */
#ifdef valuecore_debug
		cout << "factor: " << 1.0-(pow(E,-pow(f->vtl[v-1].getAttr1()*(double(atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime())),2.0))) << " / " << pow(E,-double(f->vtl[v-1].getAttr1()*f->vtl[v-1].getAttr1())) << endl;  
#endif
		return f->vtl[v-1].getValue() +
		       (1.0-pow(E,-pow(f->vtl[v-1].getAttr1()*(double(atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime())),2.0))) / (1.0-pow(E,-double(f->vtl[v-1].getAttr1()*f->vtl[v-1].getAttr1())))  
			* (f->vtl[v].getValue() - f->vtl[v-1].getValue());

	    case 6:
			case 7:
	/* linetype 6: parabola, positive a  */
	/* linetype 7: parabola, negative a */
		if(fabs(f->vtl[v-1].getAttr1()) != fabs(f->vtl[v-1].getAttr2())){
			return f->vtl[v-1].getValue() + (f->vtl[v].getValue() - f->vtl[v-1].getValue()) / (pow(f->vtl[v-1].getAttr1(), 2) - pow(f->vtl[v-1].getAttr2(), 2)) * (pow(f->vtl[v-1].getAttr1(), 2) - pow(f->vtl[v-1].getAttr1() + (atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime()) * (f->vtl[v-1].getAttr2() - f->vtl[v-1].getAttr1()), 2));
		}
		if(f->vtl[v-1].getLinetype() == 6){
			return 255 - f->vtl[v].getValue() + 4.0 * f->vtl[v-1].getAttr3() * ((atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime())) * ((atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime()) - 1.0);
		}
		return 255 - f->vtl[v].getValue() - 4.0 * f->vtl[v-1].getAttr3() * ((atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime())) * ((atime - f->vtl[v-1].getTime()) / (f->vtl[v].getTime() - f->vtl[v-1].getTime()) - 1.0);
	}
	if(debug_level>1)
		cout << "linetype of " << v-1 << " (" << int(f->vtl[v-1].getLinetype()) << ") is wrong!" << endl;
	return -2; // wrong linetype
 }
 if(f->getMode()==3){
 	float avalue = 0.0;
	for(int i=0; i<f->getVlen(); i++)
		avalue += f->fa[i].amp * 128.0 * (sin(atime*(i+1.0)+f->fa[i].phase*PI180) + 1.0);
	return avalue;
 }
  return -3;
}


float   fmrand(FMData *f, float m)
{
// m = x-Wert der Mitte
	if(f->getMode()>1 || f->getMode()<0){
		return m;
	}

	float x = float(rand()%int(2.0*m));
// x = Zufallswert von 0...2m
	float g = 1.0;
	if(f->getMode()==0)
		g = fmval(f,x/(2.0*m)*f->getVlen());
	if(f->getMode()==1){
		g = fmval(f,x/(2.0*m)*f->vtl[f->getVlen()-1].getTime());
	}
// Wert der vtl-Kurve
	float p = float(rand() % 1000);
	if(255.0/g * p <= 1000.0){
		// ist g=1 (Maximalwert) so wird der Wert in jedem Fall bernommen
		// ist g=0.001, so wird der Wert nur in einem von 1000 Fllen (p=1) bernommen
		return x;
	}
	return fmrand(f,m);
}
