/**************************************************************************
             fmifstream.h  -  defining fms-file reading utility
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _FMIFSTREAM_
#define _FMIFSTREAM_

#include "vtl.h"

class FMData {
	public:
		FMData(){mode = -1; name = "---"; read_myself=0;}

		void init(char *filename);
		void cleanup();

		char * getName(){return name;}
		int    getMode(){return mode;}
		int    getVlen(){return vlen;}
		int    getBytes(){return bytes;}

		void   setMode(int dmode){mode = dmode;}
		void   setVlen(int dvlen){vlen = dvlen;}

		unsigned char  *val ; // Pointer auf das Array der Wertechars
		/* sollte das nicht auch signed sein, wenn meine Ausgabe signed ist? */
		// ist meine Ausgabe denn signed, das ist mir neu???
		FAP   *fa; // Fourier Amplituden

		VTL   *vtl ; // Pointer auf das Array der Zeit-Wert-Linientypkomplexe
		PBS   *pbs ; // Pointer auf das Array der Tonh�ne-Tonwert-Stilkomplexe

	protected:
		// float freq ; // Frequenz
		// float time ; // aktueller Zeitindex
		int   mode ; // Modus der Speicherung
		int   nlen ; // L�ge des Namens
		int   vlen ; // Anzahl der Werte
		int   bytes; // Bytes pro Wert
		char * name; // Soundname
		int   i    ;
		unsigned char buf[5];
		bool  read_myself; // did I read this stuff myself from file (=> do I worry to delete it)?

};

float pitch(char c);
float beats(char c, bool third);

#endif

