/**************************************************************************
                   fmplayer.h  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 // TODO: move inline functions away from here
 // TODO: check role of compute and open locks
 // TODO: clear naming scheme
 // TODO: improve error handling and midi resistency


#ifndef _FMPLAYERG_
#define _FMPLAYERG_

#ifndef DATADIR
#define DATADIR "/usr/share/fms/"
#endif

#include <cstdlib>
#include <cstring>
#include <cmath>
#include <ctime>
#include <iostream>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include "fmifstream.h"
#include "fmval.h"
#include "fmwav.h"
#include "version.h"

#define D_SAMPRATE 44100
#define D_BYTES 2

// error messages
#define DSP_OPEN_ERR   0
#define DSP_CHAN_ERR   1
#define DSP_SFMT_ERR   2
#define DSP_RATE_ERR   3
#define DSP_SYNC_ERR   4

#define WAV_OPEN_ERR 100
#define WAV_WRIT_ERR 101

#define PLY_MODE_ERR 200

#define MID_NDEF_ERR 300

#define FIF_NFNM_ERR 400

// internal signals
#define ATIME_RETURN  -1

// default values
#define DEFAULT_FREQ 440

void   writeSoundByte(char * byte, bool wav, int bytes, int dspfd);

float  fmval(FMData *f, double atime);

float  ggt(float a, float b);

float  kgv(float a, float b);

/* forward declarations */

class FMMidi;

class FMChannel;
class FMMixer;
class FMSound;
class FMModulator;

enum PlayMode {
	DSP,
	WAV,
	NONE
};

enum FileMode {
	Sound,
	Noise,
	NoiseRand,
	RandNoise,
	Rand
};

enum HFMode {
	Envelope,
	AmpMod,
	Ring
};

enum ModType {
	Frequency,
	Volume,
	MLen,
	Minimum,
	Maximum,
	Other
};

class FMPlayer {
	public:
		FMPlayer();
		~FMPlayer();

		FMChannel   *firstChannel;
		FMChannel   *secondChannel;
		FMChannel   *aChannel;
		FMMixer   *aMixer;
		FMSound *aSound;

		void switchChannel();
		void gotoFirstChannel();
		void nextMixer(bool create = 1);
		void gotoFirstMixer();
		void nextSound();
		void gotoFirstSound();
		void resetPlayer();
		void setRate(int drate);
		int  getRate() const;
		void setBytes(int dbytes);
		int  getBytes() const;
		void  setFFFuzzyness(float df); // this is weird, nobody uses it
		float getFFFuzzyness() const;  
		void setPlayMode(PlayMode dmode);
		PlayMode getPlayMode() const;
		void setWavFile(char * dwavfile);
		void openFiles();
		void compute();
		void play();
		void syncPlayInit(bool open_files=1);
		void syncPlay(bool open_files=1);
		void syncPlayValue(); 
		void playInit();
		void playValue();
		void playCleanup();
		inline void syncPlayCleanup() {playCleanup();}
		void syncPointer();

	private:
		int   rate;
		int   bytes;
		float fffuzzyness; // useless (practically)!
		PlayMode mode;
		char * wavfile;
};

class FMChannel {
	public:
		FMChannel(FMPlayer *parentPlayer);
		~FMChannel();

		FMPlayer    *player;
		FMMixer   *aMixer; // fka mixer
		FMMixer   *firstMixer; // fka first
		FMSound *aSound;

		float       *ptr;

		bool  play();
		void  syncPlayInit();
		float syncValue();
		bool  syncFin();
		void  setPlay(bool);
		void  nextMixer(bool create = 1);
		void  gotoFirstMixer();
		void  nextSound();
		void  gotoFirstSound();
		void  setRepeat(int drepeat);
		int   getRepeat() const;
		void  openFiles();
		void  compute();
		void  ptrInc();
		void  pointerReset();
		void  syncPointer();

	private:


		int   i;
		int   dr; // done repetitions
		int   sv; // n.o. sync values in mixer done
		int   repeat;
		bool  do_play;
		bool  sync_fin; // sync. play finished?
};

class FMMixer {
	public:
		FMMixer(FMChannel *parentChannel);
		~FMMixer();

		FMChannel   *channel;
		FMChannel   *  other;
		FMMixer   *   next;
		FMMixer   *   self;
		FMModulator    *   hvol;
		FMSound *  aSound; // fka sound
 		FMSound *firstSound; // fka first
		float *values;

		void   nextSound();
		void   gotoFirstSound();
		bool   isFirstSound();
		float  getTime() const;
		void   setTime(float dtime);
		float  getVolume() const;
		void   setVolume(float dvol);
		float  getTVol() const;
		void   setTVol(float dtvol);
		float  getRepeat() const;
		void   setRepeat(float drepeat);
		int    getRval() const;
		void   setSelf(FMMixer *dself);
		void   setSelf(int selfnr);
		void   setHVol(); // only say "yes, we're using phvol"
		int    getNr() const;
		void   volumeChanged(float oldv, float newv);
		void   openFiles();
		void   compute();
		void   computeInit();
		void   computeMalloc();
		void   computeValues();
		float  value(bool count_on=1);
		void   deleteMe();
		void   compLockAll();

	private:
		float time;
		float vol;
		float phvol;
		float tvol;
		int   rval;
		float repeat;
		float *ptr;
		int   nr;
		bool  recursive_delete;
		static int lfd_nr;
		bool  comp_lock;
};

class FMFile : public FMData {
	public:
		FMFile(FMMixer *parentMixer);
		~FMFile();

		FMMixer *mixer;
		FMModulator    *ffreq;
		FMModulator     *hvol;
		FMModulator      *mlm;
		FMFile        *rnf;
		FMFile	*sweep;

		bool  openLock();
		void  fakeOpen();
		bool  compLock();
		void  compute();
		void  setFilename(char *dfilename);
		//void  setFilename(const char *dfilename);
		char *getFilename() const;
		void  setFreq(float dfreq, bool complock=1);
		float getFreq() const;
		void  setVolume(float dvolume, bool setptvol=1);
		float getVolume() const;
		void  setFilemode(FileMode dm);
		FileMode getFilemode() const;
		void  setMLen(float dmlen);
		float getMLen() const;
		void  setAnti(bool danti);
		bool  getAnti() const;
		void  setAtime(double datime);
		inline double getAtime() {return atime;}
		void  incAtime();
		void  setIniTInd(double dinit); // to be implemented...
		double getIniTInd(); // dito!
		double getMaxTInd();
		void  setFFreq();
		void  unsetFFreq();
		void  setHVol();
		void  unsetHVol();
		void  setMLM();
		void  unsetMLM();
		void  setRNF();
		void  unsetRNF();
		void  setSweep(float dsweepfrequency);
		void  setSweepVolume(float dsweepvolume);
		void  unsetSweep();
		void  openFile();
		void  closeFile();
		int   rval();
		inline float real_value() {return fmval(this, atime);} // does not count on!
		void  setCopyFrom(FMFile *copy);
		float value(bool count_on=1);

	protected:
		float nval;
		int   till;
		float freq;
		float volume;
		double atime;
		float mlen;
		float sweepfrequency;
		float sweepvolume;
		char *filename;
		bool  open_lock;
		bool  anti;
		bool  filename_unchanged; // has the filename remained unchanged since initialization
		int   nr;
		static int lfd_nr;
		FileMode m;
};

class FMSound : public FMFile {
	public:
		FMSound(FMMixer *parentMixer);
		~FMSound();

		FMMidi      * midi;
		FMSound * next;
		
		int soundnr;
		static int lfd_nr;

		void  setMidi();
		float value(bool count_on=1);
		void  openFile();
		int   rval();
		void   deleteMe();
};

class FMModulator : public FMFile {
	public:
		FMModulator(FMMixer *parentMixer, ModType dtype, float dmin = 0.0, float dmax = 1.0);
		~FMModulator();
		
		FMModulator * maxh;
		FMModulator * minh;

		float  HFValue(bool count_on=1);
		float  HVolVal(float);
		void   setFFreq();
		void   compLockMe();
		bool   compLock();
		void   setMin(float dmin);
		float  getMin() const;
		void   setMax(float dmax);
		float  getMax() const;
		void   setIter(float diter);
		float  getIter() const;
		void   setMinIter(float dminiter);
		float  getMinIter() const;
		void   setMaxIter(float dmaxiter);
		float  getMaxIter() const;
		void   setMaxH();
		void   unsetMaxH();
		void   setMinH();
		void   unsetMinH();
		void   setMode(HFMode dm);
		HFMode getMode() const;
		inline ModType getType() {return type;}
		void   setType(ModType dtype);
		void   compute();
		void   openFile();
		int    rval();
		void   setCopyFrom(FMModulator *f);

	private:
		float  min;
		float  max;
		float  iter;
		float  maxiter;
		float  miniter;
		HFMode m;
		ModType type;
		bool  comp_lock;
};

class FMMidi {
    public:
		FMMidi(FMFile * parent);
		void   initMidi();
		void   setMidiI(int nr, char * filename);
		void   setMidiH(int nr, char * filename);
		float  getMidiHMin(int nr);
		void   setMidiHMin(int nr, float dhmin);
		float  getMidiHMax(int nr);
		void   setMidiHMax(int nr, float dhmax);
		float  getMidiHIter(int nr);
		void   setMidiHIter(int nr, float dhiter);
		float  getMidiVol(int nr);
		void   setMidiVol(int nr, float dvol);
		double getBps();
		void   setBps(double dbps);
		void   setBpsAuto();
		float  MidiValue(bool count_on=1);

		int  rt; // recent tone
		int  rv; // value no. of recent tone

	private:
		FMMixer *mixer;
		FMMixer *fakeMixer;
		FMSound *g[33]; // need 32 Instruments
		FMFile *midifile;
		double bps;
};

#endif

