/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*----------------------------------------------------------------*/


FMChannel::FMChannel(FMPlayer *parentPlayer) {
	if(debug_level>1)
		cout << "FMChannel::FMChannel called" << endl;
	player  = parentPlayer;
	firstMixer   = new FMMixer(this);
	aMixer = firstMixer;
	syncPointer();
	repeat  = 1;
	ptr     = 0;
	do_play = 1;
	dr      = 0;
}

FMChannel::~FMChannel(){
	if(debug_level>1)
		cout << "FMChannel::~FMChannel called" << endl;
	delete firstMixer;
	if(debug_level>1)
		cout << "FMChannel::~FMChannel finished" << endl;
}

bool  FMChannel::play(){
	return do_play;
}

void  FMChannel::setPlay(bool r){
	if(debug_level>1)
		cout << "FMChannel::setPlay called" << endl;
	FMMixer * tmp = firstMixer;
	while(tmp){
		tmp->compLockAll();
		tmp = tmp->next;
	}
	FMChannel * other;
	if(this==player->firstChannel)
		other = player->secondChannel;
	else
		other = player->firstChannel;
	tmp = other->firstMixer;
	while(tmp){
		tmp->compLockAll();
		tmp = tmp->next;
	}
	do_play = r;
}

void  FMChannel::nextMixer(bool create) {
	if(debug_level>1)
		cout << "FMChannel::nextMixer called" << endl;
	if(!create && aMixer->next){
		aMixer = aMixer->next;
		syncPointer();
		if(debug_level>1)
			cout << "FMChannel::nextMixer finished without create" << endl;
		return;
	}
	aMixer = firstMixer;
	while(aMixer->next)
		aMixer = aMixer->next;
	aMixer->next = new FMMixer(this);
	aMixer = aMixer->next;
	syncPointer();
	if(debug_level>1)
		cout << "FMChannel::nextMixer finished with create" << endl;
}

void  FMChannel::gotoFirstMixer() {
	if(debug_level>1)
		cout << "FMChannel::gotoFirstMixer called" << endl;
	aMixer = firstMixer;
	syncPointer();
}

void  FMChannel::nextSound() {
	if(debug_level>1)
		cout << "FMChannel::nextSound called" << endl;
	aMixer->nextSound();
	syncPointer();
}

void  FMChannel::gotoFirstSound() {
	if(debug_level>1)
		cout << "FMChannel::gotoFirstSound called" << endl;
	aMixer->gotoFirstSound();
	syncPointer();
}

void  FMChannel::setRepeat(int drepeat){
	if(debug_level>1)
		cout << "FMChannel::setRepeat called" << endl;
	repeat = drepeat;
}

int FMChannel::getRepeat() const {
	if(debug_level>1)
		cout << "FMChannel::getRepeat called" << endl;
	return repeat;
}

void  FMChannel::openFiles() {
	if(debug_level>1)
		cout << "FMChannel::openFiles called" << endl;
 try{
	FMMixer * tmpmixer = firstMixer;
	while(tmpmixer){
		tmpmixer->openFiles();
		tmpmixer = tmpmixer->next;
	}
 }
 catch(...){
 	cout <<  "catch error in FMChannel::openFiles" << endl;
	throw;
 }
}

void  FMChannel::compute() {
	if(debug_level>1)
		cout << "FMChannel::compute called" << endl;
	aMixer = firstMixer;
	while(aMixer){
		aMixer->compute();
		aMixer = aMixer->next;
	}
	ptr = firstMixer->values;
	aMixer = firstMixer;
	dr = 0; // done repetitions
}

void  FMChannel::syncPlayInit() {
	aMixer = firstMixer;
	while(aMixer){
		aMixer->computeInit();
		aMixer = aMixer->next;
	}
	ptr = firstMixer->values;
	aMixer = firstMixer;
	dr = 0; // done repetitions
	sv = 0;
	sync_fin=0;
}

float FMChannel::syncValue() {
	if(dr>=repeat && repeat>0)
	{
	  sync_fin=1;
	}
	if(sv < aMixer->getTime() * player->getRate() * aMixer->getRepeat()) // geht das pkg.rep?
	{
		sv++;
		return aMixer->value();
	}
	aMixer = aMixer->next;
	if(!aMixer){
		aMixer = firstMixer;
		dr++; 
	}
	sv = 0;
	return syncValue();
}

bool  FMChannel::syncFin() {
	return sync_fin;
}

void  FMChannel::syncPointer() {
	if(debug_level>1)
		cout << "FMChannel::syncPointer called" << endl;
	if(aMixer)
		aSound = aMixer->aSound;
#ifdef debug_mode
	cout << "now calling player to syncPointer: Player=" << player << endl;
#endif
	player->aChannel = this; // please God, let there be light
	player->syncPointer();
	if(debug_level>1)
		cout << "FMChannel::syncPointer finished" << endl;
}

void  FMChannel::ptrInc() {
  if(ptr){
	ptr++;
	i++;
	if(ptr >= aMixer->values + aMixer->getRval()){
		ptr = aMixer->values;
	}
	if(i   >= aMixer->getTime() * player->getRate() * aMixer->getRepeat()){
		// channel repeat problematisch!
		aMixer = aMixer->next;
		i = 0;
		if(aMixer){
			ptr = aMixer->values;
		}
		else{
			dr++; // done repetitions
			if((dr>=repeat && player->getPlayMode() != DSP) || dr==repeat)
				ptr = 0;
			else{
				ptr = firstMixer->values;
				aMixer = firstMixer;
				i = 0;
			}
		}
	}
  }
}

void  FMChannel::pointerReset() {
	if(debug_level>1)
		cout << "FMChannel::pointerReset called" << endl;
	aMixer = firstMixer;
	ptr = aMixer->values;
	i = 0;
	if(debug_level>1)
		cout << "FMChannel::pointerReset finished" << endl;
}

