/**************************************************************************
              vtl.h  -  defining the vtl, pbs and related classes
                             -------------------
    begin                : January 02nd 2003
    copyright            : (C) 2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _VTL_
#define _VTL_

class VTL {
	public:
		int getTime(){return time;}
		void setTime(int dtime){time=dtime;}
		unsigned char getValue(){return value;}
		void setValue(unsigned char dvalue){value=dvalue;}
		unsigned char getLinetype(){return linetype;}
		void setLinetype(unsigned char dlinetype){linetype=dlinetype;}
		float getAttr1(){return attr1;}
		void setAttr1(float dattr1){attr1=dattr1;}
		float getAttr2(){return attr2;}
		void setAttr2(float dattr2){attr2=dattr2;}
		int getAttr3(){return attr3;}
		void setAttr3(int dattr3){attr3=dattr3;}
	private:
		int            time    ;
		unsigned char  value   ;
		unsigned char  linetype;
		float          attr1; // additional attributes
		float          attr2; // "
		int            attr3; // "
};

class VTLP : public VTL { //Value-Time-Linetype-Pointer, pointer list class for mode 1
	public:
		VTLP(){next=0;}
		~VTLP(){if(next) delete next;}
		VTLP *next;
};

class PBS {
	public:
		float	beats;
		float	pitch;  // * concert pitch = frequency
		int		style;  // 0-14; 15=chord
		int		chord;  // chord no.
};

class PBSP { //Pitch-Beats-Style-Pointer, pointer list class for mode 2
	public:
		PBSP(){third=0; end=0; next=0; attr=1; pitch=121; length=3; chord=0;}
		~PBSP(){if(next) delete next;}
		int  pitch; // 1 - 120, 10 octaves; 121 = rest; 122 = {:; 123 = :};
		bool third; // does the note have a strange length (1/5, 1/3, etc.)?
		int  length;

/*	length=		!(third)	third	*
 *	0			1/16		1/32	*
 *	1			1/8			1/12	*
 *	2			3/16		1/10	*
 *	3			1/4			1/9		*
 *	4			3/8			3/2		*
 *	5			1/2			1/6		*
 *	6			3/4			1/5		*
 *	7			1			1/3		*/

		int attr;   // number of at runtime attribute mode (= special instrument attributes), 0-14, 15=chord
					// what a fucking inconsistency that this is not named "style" as in PBS
		int chord;  // chord no.
		bool end;   // last note?
		PBSP *next;
};

void PBSP_expand(PBSP first); // expands the repeat marks

struct FAP { // Fourier Amplitude & Phase
	float amp;
	float phase;
};

#endif

