/**************************************************************************
              fmautofile.h  -  creating fms files from wav files
                            -------------------
    begin                : January 02th 2003
    copyright            : (C) 2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/version.h"
#include "include/fmwav.h"
#include "include/fmofstream.h"
#include "include/fmval.h"

#include <iostream>
#include <cstring>
#include <cstdlib>
#include <cmath>

using namespace std;

int isUnLike(float a, float b, float ff){
	if((a-b)>ff)
		return 1; // a too high
	if((b-a)>ff)
		return -1; // b too high
	return 0;
}

int round(float x){
	return (float(x-int(x))>=0.5) ? int(x+1.0) : int(x);
}

int isLine(int n, float *d, float ff, int end, int min, int max){
#if debug_level>1
		cout << "isLine start" << endl;
#endif
	if(end<min || end>max){
		cout << "Unexpected error" << endl;
		return int(ff+1);
	}
	FMData f;
	f.setMode(1);
	f.setVlen(2);
	f.vtl = new VTL[2];
	f.vtl[0].setTime(0);
	f.vtl[0].setValue(round(d[0]));
	f.vtl[0].setLinetype(1);
	f.vtl[1].setTime(n);
	f.vtl[1].setValue(round(d[n-1]));
	f.vtl[1].setLinetype(1);
	for(int i=0; i<n; i++){
		switch(isUnLike(d[i], fmval(&f,i), ff)){
			case  1:
				if(max>end){
#if debug_level
						cout << "trying to solve too high value" << endl;
#endif
					return isLine(n, d, ff, end+1, end+1, max);
				}
				else{
#if debug_level
						cout << "solving failed" << endl;
#endif
					return int(ff + 1);
				}
			case -1:
				if(min<end){
#if debug_level
						cout << "trying to solve too low value" << endl;
#endif
					return isLine(n, d, ff, end-1, min, end-1);
				}
				else{
#if debug_level
						cout << "solving failed" << endl;
#endif
					return int(ff + 1);
				}
		}
	}
#if debug_level>1
		cout << "solved\nisLine end b" << endl;
#endif
	
	return round(end-d[n-1]);
}

int isLine(int n, float *d, float ff){
	return isLine(n, d, ff, round(d[n-1]), round(d[n-1]-ff), round(d[n-1]+ff));
}

int main(int argc, char * argv[]) {
	int   sf=0;
	float ff=0.0;
	if(argc==1){
		cout << "syntax: " << argv[0] << " -s [smoothness factor] -f [fuzzyness factor]" << endl;
		cout << "converts in.wav into fms file out.fms (fms mode 2)" << endl;
		return 0;
	}
	for(int i=1; i<argc-1; i++){
		if(!strcmp(argv[i],"-s"))
			sf = atoi(argv[i+1]);
		if(!strcmp(argv[i],"-f"))
			ff = atof(argv[i+1]);
	}
	wavFile t = readWav("in.wav");
	cout << t.length << endl;
	// make smooth
	for(int j=0; j<sf; j++){
	for(int i=1; i<t.length-2; i++){
		t.data[i] = (t.data[i+1] + t.data[i-1])/2.0;
	}
	}
	//float diff = t.data[t.length-1] - t.data[0];
	//for(int i=1; i<t.length; i++){
	//	t.data[i] -= diff * i/t.length;
	//}
	VTLP * first  = new VTLP;
	VTLP * recent = first;
	int j = 0;
	int k = 0;
	for(int i=0; i<t.length; i++){
		float s = isLine(k+1,t.data,ff);
		if(i>0 && i<t.length-1 &&
			s<=ff){
			k++;
			t.data[i]+=s;
		}
		else{
			recent->setTime(k);
			recent->setValue(int(t.data[i]));
			recent->setLinetype(1);
			recent->next = new VTLP;
			recent = recent->next;
			j++;
			k = 0;
			cout << "set value" << endl;
		}
		cout << "..." << endl;
	}
	VTLP *tmp = first;
	while(tmp->next != recent)
		tmp = tmp->next;
	delete recent;
	tmp->next = 0;
	tmp->setLinetype(0);
	int fd = fmopen("out.fms");
	mode(1,fd);
	name("---",4,fd);
	values(j,1,fd,first);
	cleanup(fd);
	FMData d;
	d.init("out.fms");
	d.cleanup();
	delete t.data;
	delete first;
	return 0;
}
