/**************************************************************************
              fmautofile.h  -  creating fms files from wav files
                            -------------------
    begin                : January 02th 2003
    copyright            : (C) 2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/version.h"
#include "include/fmwav.h"
#include "include/fmofstream.h"
#include "include/fmval.h"

#include <iostream>
#include <iomanip>
#include <cstring>
#include <cstdlib>
#include <cmath>

using namespace std;

int isUnLike(float a, float b, float ff){
	if((a-b)>ff)
		return 1; // a too high
	if((b-a)>ff)
		return -1; // b too high
	return 0;
}

int round(float x){
	return (float(x-int(x))>=0.5) ? int(x+1.0) : int(x);
}

int isLine(int n, float *d, float ff, int end, int min, int max){
#if debug_level>1
		cout << "isLine start" << endl;
#endif
	if(end<min || end>max){
		cout << "Unexpected error" << endl;
		return int(ff+1);
	}
	FMData f;
	f.setMode(1);
	f.setVlen(2);
	f.vtl = new VTL[2];
	f.vtl[0].setTime(0);
	f.vtl[0].setValue(round(d[0]));
	f.vtl[0].setLinetype(1);
	f.vtl[1].setTime(n);
	f.vtl[1].setValue(round(d[n-1]));
	f.vtl[1].setLinetype(1);
	for(int i=0; i<n; i++){
		switch(isUnLike(d[i], fmval(&f,i), ff)){
			case  1:
				if(max>end){
#if debug_level
						cout << "trying to solve too high value" << endl;
				#endif
					return isLine(n, d, ff, end+1, end+1, max);
				}
				else{
#if debug_level
						cout << "solving failed" << endl;
				#endif
					return int(ff + 1);
				}
			case -1:
				if(min<end){
#if debug_level
						cout << "trying to solve too low value" << endl;
				#endif
					return isLine(n, d, ff, end-1, min, end-1);
				}
				else{
#if debug_level
						cout << "solving failed" << endl;
				#endif
					return int(ff + 1);
				}
		}
	}
#if debug_level>1
		cout << "solved\nisLine end b" << endl;
#endif
	return round(end-d[n-1]);
}

int isLine(int n, float *d, float ff){
	return isLine(n, d, ff, round(d[n-1]), round(d[n-1]-ff), round(d[n-1]+ff));
}

int main(int argc, char * argv[]) {
	int   sf=0;  // smoothness factor
	int   N2=20; // 20 Komponenten
	int   bt=3;  // bytes per value
	float ll=0.00005;// lower limit
	bool  usephase=0;
	if(argc==1){
		cout << "syntax: " << argv[0] << " -s [smoothness factor] -c [components] (-l [lower amplitude limit] -b [bytes] -p)" << endl;
		cout << "converts in.wav into fms file out.fms (fms mode 4: Fourier analysis/synthesis)" << endl;
		return 0;
	}
	for(int i=1; i<argc; i++){
		if(!strcmp(argv[i],"-s"))
			if(i<argc-1)
				sf = atoi(argv[i+1]);
		if(!strcmp(argv[i],"-c"))
			if(i<argc-1)
				N2 = atoi(argv[i+1]);
		if(!strcmp(argv[i],"-l"))
			if(i<argc-1)
				ll = atof(argv[i+1]);
		if(!strcmp(argv[i],"-b"))
			if(i<argc-1)
				bt = atoi(argv[i+1]);
		if(!strcmp(argv[i],"-p"))
			usephase = 1;
	}
	//if(ll<1.0/(pow(256.0,bt)-1.0))
	//	ll = 1.0/(pow(256.0,bt)-1.0);

#if debug_level
		cout << bt << " bytes" << endl;
#endif

	wavFile t = readWav("in.wav");
	//cout << t.length << endl;
	// make smooth
	for(int j=0; j<sf; j++){
	for(int i=1; i<t.length-2; i++){
		t.data[i] = (t.data[i+1] + t.data[i-1])/2.0;
	}
	}

	for(int i=0; i<t.length; i++){
		t.data[i] /= 32768.0;
	}

	// Werte in t.data[0-t.length]

	int U,K,I,N,R,N1;
	float A,B;

	N=t.length;
	N1=N/2;
	float SN[N], CO[N], Z[N2], P[N2];

	for(I=0; I<N; I++)
   {
    SN[I]=sin(3.1415926*(N1-I)/N1);              /* Sinus   Factor */
    CO[I]=cos(3.1415926*(N1-I)/N1);              /* Cosinus Factor */
   }

   //F[N]=F[0]; // ist das (letztes Sample := erstes Sample) dazu da,
	            // das Ereignis periodisch zu machen?


   U=0;
   for(K=0; K<N2; K++)
   {
	 	 Z[K]=P[K]=0.0;
     A=0.0;
     B=0.0;

     for(I=0; I<N; I++)
     {
       R=(K+1)*I-int((I*(K+1))/N)*N;
       A=A+t.data[I]*CO[R];
       B=B+t.data[I]*SN[R];
     }

     A=A/N1;
     //if( K==N2 )   // warum das?
		 //	A=A/2;
     B=B/N1;

     Z[K]=sqrt(A*A+B*B);
		 if(usephase)
     		P[K]=atan(A/B)*180/3.1415926;

     if(P[K]<0.0001)
	  P[K]=0.0;
     if(Z[K]<0.00001){
	  P[K]=0.0;
	  Z[K]=0.0;
     }
   }

	 int   lo = 0;
	 float ta = 0.0;
	 float ma = 0.0;
	for(int i=0; i<N2; i++){
	if(Z[i]>ll){
		lo = i+1;
		ta+=Z[i];
		if(ma<Z[i])
			ma=Z[i];
	}
	else{
		Z[i]=0.0;
		P[i]=0.0;
	}
	}
	 ta = 1.0/ta;
	 ma = 1.0/ma;
	 if(ta<ma)
	 	ma = ta;

	FAP fa[N2];

	cout.setf(ios::fixed);

	 for(int i=0; i<N2; i++){
			fa[i].amp   = Z[i]*ma*0.99;
			if(usephase)
				fa[i].phase = P[i];
			cout.precision(8);
			cout << "Oberton" << setw(4) << i+1 << ":" << setw(12) << fa[i].amp;
			if(usephase){
				cout.precision(3);
				cout << "  Phase: " << setw(8) << fa[i].phase;
			}
			cout << endl;
		}

	int fd = fmopen("out.fms");
	mode(3,fd);
	name("---",4,fd);
	values(lo,bt,fd,fa,usephase);
	cleanup(fd);
	delete t.data;
	return 0;
}
