#include "include/fmplayer.h"
#include <iostream>

using namespace std;

int main() {

cout << "a composition for FMS" << endl;
	
const double tz=0.35;
const int    sz=2;

FMPlayer p;

p.setRate(22050);
p.setBytes(1);

p.aMixer->setTime(10*tz);

p.aSound->setFilemode(Noise);
p.aSound->setHVol();
p.aSound->hvol->setFilename(DATADIR "/sounds/gauss");

p.nextSound();

p.aSound->setFilename(DATADIR "/sounds/tri");
p.aSound->setHVol();
p.aSound->hvol->setFilename(DATADIR "/sounds/saw");
p.aSound->setFFreq();
p.aSound->ffreq->setFilemode(Noise);
p.aSound->ffreq->setMLen(44100/sz * tz);

//--------------------------------------\\

p.nextMixer();
p.aMixer->setTime(10*tz);

p.aSound->setFilename(DATADIR "/sounds/tri");
p.aSound->setFFreq();
p.aSound->ffreq->setFilemode(Noise);
p.aSound->ffreq->setMLen(44100/sz*tz);

p.nextSound();

p.aSound->setFilename(DATADIR "/sounds/tri");
p.aSound->setHVol();
p.aSound->hvol->setFilename(DATADIR "/sounds/saw");
p.aSound->setFFreq();
p.aSound->ffreq->setMax(4000);
p.aSound->ffreq->setMin(1000);
p.aSound->ffreq->setFilemode(Noise);
p.aSound->ffreq->setMLen(22050/sz*tz);

//--------------------------------------\\

p.nextMixer();
p.aMixer->setTime(10*tz);

p.aSound->setFFreq();
p.aSound->ffreq->setFilemode(Noise);
p.aSound->ffreq->setMLen(44100/sz*tz);

p.nextSound();

p.aSound->setFilename(DATADIR "/sounds/tri");
p.aSound->setFFreq();
p.aSound->ffreq->setFilename(DATADIR "/sounds/cosin");
p.aSound->ffreq->setIter(0.5);
p.aSound->ffreq->setMax(3000);
p.aSound->ffreq->setMin(300);

//--------------------------------------\\

p.nextMixer();
p.aMixer->setTime(10*tz);

p.aSound->setFFreq();
p.aSound->ffreq->setFilemode(Noise);
p.aSound->ffreq->setMLen(44100/sz*tz);

p.nextSound();

p.aSound->setFilename(DATADIR "/sounds/tri");
p.aSound->setFFreq();
p.aSound->ffreq->setFilename(DATADIR "/sounds/cosin");
p.aSound->ffreq->setIter(25.5);
p.aSound->ffreq->setMax(300);
p.aSound->ffreq->setMin(100);

//--------------------------------------\\

p.nextMixer();
p.aMixer->setTime(10*tz);

p.aSound->setFilename(DATADIR "/sounds/tri");
p.aSound->setHVol();
p.aSound->hvol->setFilename(DATADIR "/sounds/cosin");
p.aSound->hvol->setIter(0.5);
p.aSound->setFFreq();
p.aSound->ffreq->setFilemode(Noise);
p.aSound->ffreq->setMLen(44100/sz*tz);

p.nextSound();

p.aSound->setFilename(DATADIR "/sounds/tri");
p.aSound->setFFreq();
p.aSound->ffreq->setFilemode(Noise);
p.aSound->ffreq->setMin(500);
p.aSound->ffreq->setMaxH();
p.aSound->ffreq->maxh->setFilename(DATADIR "/sounds/gauss");
p.aSound->ffreq->maxh->setIter(0.5);
p.aSound->ffreq->maxh->setMin(300);
p.aSound->ffreq->maxh->setMax(1500);

p.syncPlay();

return 0;
}
