#include "include/version.h"
#include "include/fmplayer.h"
#include <iostream>

using namespace std;

int main(int argc, char * argv[]) {

    
cout << "syntax: " << argv[0] << " (options) [file]" << endl;
                cout << "options: \n"
			                << "\t-t [time]: playing lenght\n"
					                << "\t-V [volume %]: total volume\n"
							                << "\t-w [wav file]: wav output filename\n"
									                << "\t-b [bytes]: bytes per value (1 or 2)\n"
													                << "\t-v[n] [volume %]: relative volume for voice n or global\n"
															                << "\t-h[n] [fms envelope file]: envelope for voice n or global\n"
																	                << "\t-i[n] [fms instrument file]: instrument for voice n or global\n"
																			                << "\t-f [frequency]: concert pitch\n"
																							                << endl;
		
	
    cout << "Enjoy it, and always remember it _is_ music!" << endl;

    int voices=4, l=0;

    FMPlayer p; // make it seed the random

    PBSP  *recent[voices]    ; // aktuelle Wertkombination
    PBSP  *first[voices]     ; // Pointer auf Anfangswerte
    PBSP  *before[voices]    ; // Pointer auf vorherigen Wert

    double time = 12.0;
    double volume = 100.0, freq = 441;
    char *wavname=0;
    int bytes = 1;

	const int r_div = 4; // 4 different rhythms
	int takt[voices][r_div][9];

	float t;
	int tc;
	int rn,av;

if(debug_level) cout << "initializing rhythm patterns" << endl;

for(av=0; av<voices; av++)
  {
    if(debug_level) cout << "\t for voice " << av+1 << endl;
    for(rn=0; rn<r_div; rn++)
    {
      if(debug_level) cout << "\t\t for pattern " << rn+1 << endl;
      t=0.0; tc=0;
      while(t<4) // initialize rhythm patterns
      {
        takt[av][rn][tc]=3;
	int tt =(rand()%3); // sorry, cant bear +av with many voices;
	if(av) tt++;
	float at = 0.0;
	switch(tt){
	  case 0:
	    takt[av][rn][tc]=1; at = 0.5; tc++;
	    break;
	  case 1:
	    if(t<=3.0) {takt[av][rn][tc]=3; at = 1.0; tc++;}
	    break;
	  case 2:
	    if(t<=2.0) {takt[av][rn][tc]=5; at = 2.0; tc++;}
	    break;
	}
	t+=at;
      }
      takt[av][rn][tc]=0;
      if(debug_level>1) cout << "eot" << endl;
    }

  }

	int a1=7;
	int a2=-2;
	int a3=-5;

	int ntone[voices];
	double vvol[voices];
	char *dhvol=0, *dinst=0;
	char *hvol[voices];
	char *inst[voices];

if(debug_level) cout << "initializing attributes" << endl;    

for(l=0; l<voices; l++)
    {
    	recent[l] = new PBSP;
    	first[l] = recent[l];
    	before[l] = 0;
    	ntone[l] = 0;
	vvol[l]=100.0;
	hvol[l]=0;
	inst[l]=0;
    }

	for(int i=1;i<argc;i++)
	{
		if(argv[i][0]=='-'){
		switch(argv[i][1]){
		  case 't':
		  	time = atof(argv[i+1]); if(time<=0.0) time = 20.0; break;
		  case 'V':
			volume = atof(argv[i+1]); if(volume>100.0||volume<0.0) volume=100.0; break;
		  case 'v':
		  	if(voices>=atoi(argv[i]+2)>0){vvol[atoi(argv[i]+2)-1]=atof(argv[i+1]);
			if(vvol[atoi(argv[i]+2)-1]>100.0||vvol[atoi(argv[i]+2)-1]<0.0) vvol[atoi(argv[i]+2)-1]=100.0;} break;
		  case 'h':
			if(argv[i][2]=='\0')dhvol=argv[i+1];
		  	else if(voices>=atoi(argv[i]+2)>0){hvol[atoi(argv[i]+2)-1]=argv[i+1];}
			break;
		  case 'i':
			if(argv[i][2]=='\0')dinst=argv[i+1];
		  	if(voices>=atoi(argv[i]+2)>0){inst[atoi(argv[i]+2)-1]=argv[i+1];}
			break;
		  case 'w':
		  	wavname = argv[i+1]; break;
		  case 'b':
		  	bytes = atoi(argv[i+1]); break;
		  case 'f':
		  	freq = atof(argv[i+1]); break;
		}
		i++;
		}
	}

    int apitch; // aktuelle Tonhhe
    int takte; // schon abgespielte Takte
    int rn_c; // wie viele takte noch mit aktuellem rhythmus?
    
for(av=0; av<voices; av++){
    apitch=80;
    if(av)
	apitch-=20;

    takte=0;
    tc=0; // wievielter Ton aus Rhythmusmuster
    rn=0; // rhythm number
    rn_c=1;

    while(takte<int(time/2)){
	//cout << apitch << endl;
	switch(rand()%5){
	    case 0:
		  apitch+=a1; break;
	    case 1:
		  apitch+=(apitch>80-20*av)?a3:a1; break;
	    case 2:
		  apitch+=a3; break;
	    case 3:
		  apitch+=a2; break;
	    case 4:
	      apitch+=(apitch>80-20*av)?a3:a1; break;
	    //case 5:
	    //  apitch+=a3; break;
	}
	
	if(!rand()%3){
		int tmp= -a3;
		a3= -a1;
		a2= -a2;
		a1 = tmp;
	}

	if(!takt[av][rn][tc]){
		tc=0;
		takte++;
		rn_c--;
		if(rn_c<=0){
		  rn=!rn; // nur 2 rhythmen moeglich!
		  rn_c=int(pow(2.0,rand()%3)); // 1 - 4
		}
		if(debug_level) cout << "new rhythm: " << rn << endl;
	}

        ntone[av]++;
        recent[av]->next = new PBSP;
        recent[av] = recent[av]->next;

	recent[av]->pitch = apitch; // Tonhoehe
	recent[av]->length = takt[av][rn][tc]; // Notenwert
	if(debug_level>1) cout << "l[" << av << "][" << rn << "][" << tc << "]:" << recent[av]->length << endl;
	if(tc==0) // Betonung auf 1
		recent[av]->attr = 1;
	else
		recent[av]->attr = 0;

	tc++;

	//av = (av+1) % voices;

	apitch=recent[av]->pitch;
    }
    }
	p.setBytes(1+(bytes==2));
	if(debug_level)cout << time << endl;
	p.aMixer->setTime(time);
	if(debug_level)cout << volume << endl;
	p.aMixer->setVolume(volume/100.0);
    // convert from pbsp to pbs
    PBS *d[voices];

    for(av=0; av<voices; av++)
    {
	    d[av] = new PBS[ntone[av]];
	    recent[av]=first[av];
	    for(int i=0; i<ntone[av]; i++)
	    {
		    d[av][i].beats=beats(recent[av]->length,recent[av]->third);
		    d[av][i].pitch=pitch(recent[av]->pitch-1);
		    d[av][i].style=recent[av]->attr;
		    recent[av]=recent[av]->next;
	    }
	    p.aSound->setVolume(vvol[av]/100.0);
	    p.aSound->setFreq(freq);
	    p.aSound->setMode(2);
	    p.aSound->setVlen(ntone[av]);
	    if(debug_level) cout << "setVlen to " << ntone[av] << endl;
	    p.aSound->pbs=d[av];
	    p.aSound->setMidi();
	    p.aSound->midi->setMidiI(0,DATADIR "/sounds/oktav");
	    p.aSound->midi->setMidiI(1,DATADIR "/sounds/oktav");
	    p.aSound->midi->setMidiH(0,DATADIR "/midi/attack");
	    p.aSound->midi->setMidiH(1,DATADIR "/midi/attack");
		if(inst[av]){
			if(debug_level)
				cout << "individual filename: " << inst[av] << " " << av << endl;
			p.aSound->midi->setMidiI(0,inst[av]);
			p.aSound->midi->setMidiI(1,inst[av]);
		}
		else if(dinst){
			p.aSound->midi->setMidiI(0,dinst);
			p.aSound->midi->setMidiI(1,dinst);
		}
		else{
			if(debug_level>1)
				cout << "default filename" << endl;
			p.aSound->midi->setMidiI(0,DATADIR "/sounds/tri");
			p.aSound->midi->setMidiI(1,DATADIR "/sounds/tri");
		}

		if(hvol[av]){
			p.aSound->midi->setMidiH(0,hvol[av]);
			p.aSound->midi->setMidiH(1,hvol[av]);
		}
		else if(dhvol){
			p.aSound->midi->setMidiH(0,dhvol);
			p.aSound->midi->setMidiH(1,dhvol);
		}
	 // p.aSound->midi->setMidiVol(0,0.3); 
	 // p.aSound->midi->setMidiVol(1,1.0); // emphasis
	    p.aSound->midi->initMidi();
	    if(av<voices-1){
	    	p.aSound->next = new FMSound(p.aMixer);
		p.aSound = p.aSound->next;
	    }

    }
	if(wavname)
		p.setWavFile(wavname);
	if(debug_level)cout << "computing... [please be patient, and I mean it]" << endl;
//	p.compute();
//      p.syncPlayInit();
//
//	l=0;
//	char prog[60] = "|                                                   |   0%";
//	int perc = int(time*p.getRate()/100.0);
//	cout << "playing " << voices << " voices..." << endl;
//    while(!p.first->syncFin()){
//	    p.syncPlayValue();
//		l++;
//		if(l%perc==0){
//			if(int(l/perc)%2==0)
//				prog[int(l/perc*0.5)+1]='-';
//			else
//				prog[int(l/perc*0.5)+1]='=';
//			prog[56] = int(l/perc)%10+48;
//			prog[55] = int((int(l/perc)-int(l/perc)%10)/10)+48;
//			if(l/perc<10)
//				prog[55]=' ';
//
//			cout << prog << "\r" << flush;
//		}
//	}*/
//	p.syncPlay();
//	prog[55]=prog[56]='9';
//	cout << prog << "\r" << flush;
//	p.playCleanup();
//	prog[51]='='; prog[54]='1'; prog[55]='0'; prog[56]='0';
//	cout << prog << endl;
//	if(1){
//		if(debug_level)
//			cout << "beats per minute: ";
//		p.aMixer->firstSound();
//		for(av=0; av<voices; av++){
//			cout << p.aMixer->sound->midi->getBps() << " ";
//			p.aMixer->nextSound();
//		}
//		cout << endl;
//	}
//	
//	cout << "harmonic number a1 was " << a1 << endl;
	
	p.syncPlay(0); // do not open files

}

