/**************************************************************************
             fmdisplay.cpp  -  displaying fms-files on console
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <cmath>
#include <cstdio>

#include "include/fmlanguage_fmdisplay.h"
#include "include/fmplayer.h"
#include "include/version.h"
#include "include/checkint.h"

using namespace std;

int main(int argc, char *argv[]) {

	FMPlayer f;
	text_fmdisplay t; // the strings for communication with our user

	cout <<  t.title << endl;
	if(argc < 2 || argc > 4) {
		cout << t.syntax1 << ": " << argv[0] << t.syntax2 << endl;
		cout << t.version << fms_version << endl;
		cout << t.license << endl;
		cout << t.warranty << endl;
		return 0;
	}

	int	i             ;
	int	j             ;
	//int	fd            ;
	int	x   = 80      ;
	int	y   = 24      ;
	//int	y_recent      ;
	//float	x_recent = 0.0;
	//float	y_faktor      ;
	
	f.aSound->setFilename(argv[1]);
	f.aSound->setFreq(1);
	f.openFiles();

	cout << t.readsucc1 << f.aSound->getFilename() << t.readsucc2 << endl << t.mode << f.aSound->getMode() + 1 << endl << t.name << f.aSound->getName() << endl << t.bytes << f.aSound->getBytes() << endl;

	if(f.aSound->getMode()==2){
		cout << t.midierr << endl;
		return 0;
	}

	if(argc >= 3) {
		x = atoi(argv[2]);
		cout << "x:\t\t" << x << endl;
	}

	if(argc >= 4) {
		y = atoi(argv[3]);
		cout << "y:\t\t" << y << endl;
	}
	
	y = checkint(y, 1, 1000);
	x = checkint(x, 1, 1000);

	f.setRate(x);
	f.aSound->setFreq(1.0);
	f.aMixer->setTime(1.0);

	char data[x][y];
	for(i = 0; i < y; i++) {
		for(j = 0; j < x; j++) {
			data[j][i] = ' ';
		}
	}

	f.compute();

	for(i = 0; i < x; i++) {
		data[i][y-int(*f.aChannel->ptr * y / 256.0)-1] = '*';
		if(debug_level>0)
			cout << setw(2) << i << "|" << setw(2) << y-int(*f.aChannel->ptr * y / 256.0) << endl;
		f.aChannel->ptrInc();
	}

	cout << endl;

	for(i = 0; i < y; i++) {
		for(j = 0; j < x; j++) {
		cout << data[j][i];
		}
	cout << endl;
	}

	return 0;
}

