/**************************************************************************
                 fmfile.cpp  -  fms-file-creating software
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <iostream>
#include <cstring>
#include <cstdlib>
#include <cmath>

#include "include/checkint.h"
#include "include/fmofstream.h"
#include "include/fmlanguage_fmfile.h"
#include "include/version.h"

using namespace std;

int line_help();
int length_help(bool third);


int main(int argc, char *argv[]) {

	text_fmfile t; // strings for user communication

	cout<< t.title << endl;
	if(argc != 2) {
		cout << t.syntax1 << ": " << argv[0] << t.syntax2 << endl;
		cout << t.version << fms_version << endl;
		cout << t.license << endl;
		cout << t.warranty << endl;
		return 0;
	}

	int  file      ;
	int  amode     ; // mode of file recently written
	int  i;
	int  valuecount;
	int  bytecount = 1;
	char buff[256] ;

	file = fmopen(argv[1]);
	cout<< t.start << endl;

	cout<< t.mode;
	cin >> buff;
	if(buff[1] != '\0')      /* nothing > 9, please */
		buff[0] = 'h';

	if((amode = mode(buff[0], file)) == -1) {
		cout << t.modes1 << endl << t.modes2 << t.modes3;
		cin >> buff;
		amode = checkint(atoi(buff), 1, 4);
		buff[0] = amode + 48; // what a brilliant conversion ... *g* 
		if((amode = mode(buff[0], file)) == -1) {
			cout << t.error;
			return 0;
		}
	}

	cout<< t.name;
	cin.getline(buff, 256, '.');
	for(i = 0; i < int(strlen(buff)) - 1; i++){

/* The first char is \n for some reason.*
 * We have to shift everything		*/

		buff[i] = buff[i+1];
	}

	buff[strlen(buff) - 1] = '\0';
	name(buff, strlen(buff), file);

	if(amode == 0 || amode == 1 || amode == 3){
		cout<< t.bytes;
		cin >> buff;
		bytecount  = checkint(atoi(buff), 1, 256);

		if(amode != 3 && bytecount != 1) {
			cout << t.onebyte << endl;
			bytecount = 1;
		}
	}
	
	if(amode == 3){
		int otcount; // Anzahl Obertne
		FAP * fa;
		bool usephase = 0;

		cout<< t.otnr << flush;
		cin >> buff;
		otcount = checkint(atoi(buff),1,100);
		fa = new FAP[otcount];
		cout << t.usephase << flush;
		cin >> buff;
		if(buff[0] == t.yes || buff[0] == t.yes - 32)
			usephase = 1;

		for(i=0; i<otcount; i++){
			cout<< t.otamp1 << i+1 << t.otamp2 << flush;
			cin >> buff;
			fa[i].amp = checkfloat(atof(buff),0.0,1.0);
			if(usephase){
				cout<< t.otphase << flush;
				cin >> buff;
				fa[i].phase = checkfloat(atof(buff),0.0,180.0);
			}
			else
				fa[i].phase = 0.0;
		}

		values(otcount, bytecount, file, fa, usephase);
		delete []fa;
	}

	if(amode == 2){

		PBSP  *recent       ; // aktuelle Wertkombination
		PBSP  *first  = 0   ; // Pointer auf Anfangswerte
		PBSP  *before = 0   ; // Pointer auf vorherigen Wert
		int   third         ; // use "third" length values?
		int   tonecount = 1 ; // how many tones?
		bool  attr    = 0   ; // use attributes for every tone

		recent = new PBSP;
		cout<< t.firsttone << "(" << t.tonehelp << ")" << ": ";
		cin >> buff;
		recent->pitch = checkint(atoi(buff), 1, 121);

		cout<< t.third1 << t.third2;
		cin >> buff;
		buff[1] = '\0';
		if(buff[0] > 48 && buff[0] < 50){
			third = checkint(atoi(buff), 0, 2);
		}
		else
			third = checkint(3, 0, 2);

		if(!third){
			cout<< t.third;
			cin >> buff;
			if(buff[0] == t.yes || buff[0] == t.yes - 32)
				recent->third = 1;
		}
		if(third == 2)
			recent->third = 1;

		cout<< t.firstlength;
		recent->length = length_help(recent->third);

		cout<< t.attr1;
		cin >> buff;
		if(buff[0] == t.yes || buff[0] == t.yes - 32)
			attr = 1;

		if(attr){
			cout<< t.attr;
			cin >> buff;
			recent->attr = checkint(atoi(buff), 1, 32);
		}

		recent->next     = 0;
		first            = recent;
		before           = recent;

		do {

			recent = new PBSP;
			before->next = recent;
			recent->next = 0;

			cout<< t.tone << t.help << ": ";
			cin >> buff;
			if(buff[0] == 'h'){
				cout<< t.tonehelp;
				cin >> buff;
			}
			recent->pitch = checkint(atoi(buff), 1, 121);
   
			if(!third){
				cout<< t.third;
				cin >> buff;
				if(buff[0] == t.yes || buff[0] == t.yes - 32)
					recent->third = 1;
			}
			if(third == 2)
				recent->third = 1;
				
			cout<< t.length << t.help << ": ";;
			cin >> buff;
			if(buff[0] == 'h')
				recent->length = length_help(recent->third);
			else
				recent->length = checkint(atoi(buff), 1, 8);
				
			if(attr){
				cout<< t.attr;
				cin >> buff;
				recent->attr = checkint(atoi(buff), 1, 32);
			}

			cout<< t.lasttone;
			cin >> buff;
			if(buff[0] == t.yes || buff[0] == t.yes - 32)
				recent->end = 1;

			before = recent;
			tonecount++;
			
			if(tonecount == 65535){
				cout << t.lastval << endl;
				recent->end = 1;
			}

		} while(!recent->end);

		values(tonecount, file, first);

		delete first;
	}

	if(amode == 1){

		int   told = 0      ;
		int   valuecount = 1;
		VTLP  *recent       ; // aktuelle Wertkombination
		VTLP  *first  = 0   ; // Pointer auf Anfangswerte
		VTLP  *before = 0   ; // Pointer auf vorherigen Wert
		int   min = 0, max = 255;

		recent = new VTLP;
		cout<< t.firstval << "(1 - 256): ";
		cin >> buff;
		recent->setValue(checkint(atoi(buff), 1, 256) - 1);
		cout<< t.linetype << " " << t.help << ": ";
		cin >> buff;
		if(buff[0] < 49 || buff[0] > 55){ // if < 0 or > 7
			recent->setLinetype(line_help());
			recent->setLinetype(checkint(recent->getLinetype(), 1, 7));
		}
		else
			recent->setLinetype(checkint(atoi(buff), 1, 7));
		//if((recent->getLinetype() == 2 || recent->getLinetype() == 5) && recent->getValue() == 255) {
		//	cout << t.high1 << t.forlinetype << recent->getLinetype() << t.nfirstval << "(1 - 255): ";
		//	cin >> buff;
		//	recent->setValue(checkint(atoi(buff), 1, 255) - 1);
		//}

		//if((recent->getLinetype() == 3 || recent->getLinetype() == 4) && recent->getValue() == 0) {
		//	cout << t.low1 << t.forlinetype << recent->getLinetype() << t.nfirstval << "(2 - 256): ";
		//	cin >> buff;
		//	recent->setValue(checkint(atoi(buff), 2, 256) - 1);
		//}
		
		if(recent->getLinetype() == 4) {
			cout << "starting x value of gaussian (n/64): " << endl;
			cin >> buff;
			recent->setAttr1(checkint(atoi(buff), -256, -1));
		}


		if(recent->getLinetype() == 5) {
			cout << "ending x value of gaussian (n/64): " << endl;
			cin >> buff;
			recent->setAttr1(checkint(atoi(buff), 1, 256));
		}


		if(recent->getLinetype() == 6 || recent->getLinetype() == 7) {
			cout << t.parabola_start;
			cin >> buff;
			recent->setAttr1(checkint(atoi(buff), -8, 7));
			cout << t.parabola_end << "(" << int(recent->getAttr1()) + 1 << " - 8): ";
			cin >> buff;
			recent->setAttr2(checkint(atoi(buff), int(recent->getAttr1()) + 1, 8));

			if(recent->getLinetype() == 6 && abs(recent->getAttr1()) < abs(recent->getAttr2()) && recent->getValue() == 255){
				cout << t.high1 << t.forlinetype << recent->getLinetype() << t.wtattr << t.nfirstval << "(1 - 255): ";
				cin >> buff;
				recent->setValue(checkint(atoi(buff), 1, 255) - 1);
			}

			if(recent->getLinetype() == 7 && abs(recent->getAttr1()) > abs(recent->getAttr2()) && recent->getValue() == 255){
				cout << t.high1 << t.forlinetype << recent->getLinetype() << t.wtattr << t.nfirstval << "(1 - 255): ";
				cin >> buff;
				recent->setValue(checkint(atoi(buff), 1, 255) - 1);
			}

			if(recent->getLinetype() == 6 && abs(recent->getAttr1()) > abs(recent->getAttr2()) && recent->getValue() == 0){
				cout << t.low1 << t.forlinetype << recent->getLinetype() << t.wtattr << t.nfirstval << "(2 - 256): ";
				cin >> buff;
				recent->setValue(checkint(atoi(buff), 2, 256) - 1);
			}

			if(recent->getLinetype() == 7 && abs(recent->getAttr1()) < abs(recent->getAttr2()) && recent->getValue() == 0){
				cout << t.low1 << t.forlinetype << recent->getLinetype() << t.wtattr << t.nfirstval << "(2 - 256): ";
				cin >> buff;
				recent->setValue(checkint(atoi(buff), 2, 256) - 1);
			}

			recent->setAttr3(-1);

			if(abs(recent->getAttr1()) == abs(recent->getAttr2())){
				cout << t.paramp;
				cin >> buff;
				recent->setAttr3(int(checkfloat(atof(buff), 0.0, 100.0) * (255.0 / 100.0)));
				if(recent->getLinetype() == 6 && recent->getAttr3() < recent->getValue()){
					recent->setAttr3(int(recent->getValue() * 100.0/255.0)); // really?
					cout << t.low1 << t.forvalue << t.permissible << " " << recent->getAttr3() << "." << endl;
				}
				if(recent->getLinetype() == 7 && recent->getAttr3() > 255 - recent->getValue()){
					recent->setAttr3(int(float(255 - recent->getValue()) * 100.0/255.0)); // really?
					cout << t.high1 << t.forvalue << t.permissible << " " << recent->getAttr3() << "." << endl;
				}
			}

		}

		recent->setTime(0);
		recent->next     = 0;
		first            = recent;
		before           = recent;

		do {

			valuecount++;
			recent = new VTLP;
			before->next = recent;
			recent->next = 0;

			if(before->getLinetype() == 1 || before->getLinetype() == 2 || before->getLinetype() == 3 || before->getLinetype() == 4 || before->getLinetype() == 5) {
				min = 0; max = 255;
			}

			//if(before->getLinetype() == 2 || before->getLinetype() == 5) {
			//	min = before->getValue() + 1; max = 255;
			//}

			//if(before->getLinetype() == 3 || before->getLinetype() == 4) {
			//	min = 0; max = before->getValue() - 1;
			//}

			if(before->getLinetype() == 6 || before->getLinetype() == 7 && abs(before->getAttr1()) == abs(before->getAttr2())){
				min = before->getValue(); max = before->getValue();
			}

			if(before->getLinetype() == 6 && abs(before->getAttr1()) < abs(before->getAttr2())) {
				min = before->getValue() + 1;
				max = int(before->getValue() * pow(before->getAttr2() / 2.0, 2) / pow(before->getAttr1() / 2.0, 2));
			}

			if(before->getLinetype() == 6 && abs(before->getAttr1()) > abs(before->getAttr2())) {
				max = before->getValue() - 1;
				min = int(before->getValue() * pow(before->getAttr2() / 2.0, 2) / pow(before->getAttr1() / 2.0, 2));
				if(before->getAttr2() <= 0)
					min = 0;
			}

			if(before->getLinetype() == 7 && abs(before->getAttr1()) > abs(before->getAttr2())) {
				min = before->getValue() + 1;
				max = int(before->getValue() + (255 - before->getValue()) / pow(before->getAttr1() / 2.0, 2) * (pow(before->getAttr1() / 2.0, 2) -  pow(before->getAttr2() / 2.0, 2)));
			}

			if(before->getLinetype() == 7 && abs(before->getAttr1()) < abs(before->getAttr2())) {
				max = before->getValue() - 1;
				min = int(255 - (255 - before->getValue()) / pow(before->getAttr1() / 2.0, 2) * pow(before->getAttr2() / 2.0, 2));
			}

			if(min < 0 || min > 255)
				min = 0;
			if(max > 255 || max < 0)
				max = 255;

			cout<< t.time << "(" << told+1 << " - " << told+65536 << "): ";
			cin >> buff;
			recent->setTime(checkint(atoi(buff), told+1, told+65536));
			recent->setTime(recent->getTime() - told - 1);
			told = recent->getTime() + told + 1;

			if(min==max){
				recent->setValue(min);
				cout <<  '\a' << flush;
				cout << t.minismax1 << min+1 << t.minismax2 << min+1 << "." << endl;
			}
			else{
				cout<< t.val << "(" << min + 1 << " - " << max + 1 << "): ";
				cin >> buff;
				recent->setValue(checkint(atoi(buff), min + 1, max + 1) - 1);
			}

			cout<< t.linetype << ": ";
			cin >> buff;
			if(buff[0] < 49 || buff[0] > 55)
				recent->setLinetype(line_help());
			else
				recent->setLinetype(checkint(atoi(buff), 0, 7));

			/*if((recent->getLinetype() == 2 || recent->getLinetype() == 5) && recent->getValue() == 255) {
				cout << t.high1 << t.forlinetype << recent->getLinetype();
				if((min + 1) < max) {
					cout << t.nval << "(" << min + 1 << " - " << max << "): ";
					cin >> buff;
					recent->setValue(checkint(atoi(buff), min + 1, max) - 1);
				}
				if((min + 1) > max) {
					int pos[]={1, 3, 4};
					cout << t.nlinetype << "(" << pos[0] << ", " << pos[1] << " " << t.oder << " " << pos[2] << "): ";
					cin >> buff;
					recent->setLinetype(chooseint(atoi(buff), pos, 3));
				}
				if((min + 1) == max)
					recent->setValue(min);
			}*/

			/*if((recent->getLinetype() == 3 || recent->getLinetype() == 4) && recent->getValue() == 0) {
				cout << t.low1 << t.forlinetype << recent->getLinetype();
				if((min + 1) < max) {
					cout << t.nval << "(" << min + 2 << " - " << max + 1 << "): ";
					cin >> buff;
					recent->setValue(checkint(atoi(buff), min + 2, max + 1) - 1);
				}
				if((min + 1) > max) {
					int pos[]={1, 2, 5};
					cout << t.nlinetype << "(1, 3 " << t.oder << " 4): ";
					cin >> buff;
					recent->setLinetype(chooseint(atoi(buff), pos, 3));
				}
				if((min + 1) == max)
					recent->setValue(min);
			}*/
			
			if(recent->getLinetype() == 4) {
				cout << "starting x value of gaussian (n/64): " << endl;
				cin >> buff;
				recent->setAttr1(checkint(atoi(buff), -256, -1));
			}


			if(recent->getLinetype() == 5) {
				cout << "ending x value of gaussian (n/64): " << endl;
				cin >> buff;
				recent->setAttr1(checkint(atoi(buff), 1, 256));
			}

			if(recent->getLinetype() == 6 || recent->getLinetype() == 7) {
				cout << t.parabola_start;
				cin >> buff;
				recent->setAttr1(checkint(atoi(buff), -8, 7));
				cout << t.parabola_end << "(" << recent->getAttr1() + 1 << " - 8): ";
				cin >> buff;
				recent->setAttr2(checkint(atoi(buff), int(recent->getAttr1()) + 1, 8));

				if(recent->getLinetype() == 6 && abs(recent->getAttr1()) < abs(recent->getAttr2()) && recent->getValue() == 255){
					cout << t.high1 << t.forlinetype << recent->getLinetype() << t.wtattr << t.nfirstval << "(1 - 255): ";
					cin >> buff;
					recent->setValue(checkint(atoi(buff), 1, 255) - 1);
				}

				if(recent->getLinetype() == 7 && abs(recent->getAttr1()) > abs(recent->getAttr2()) && recent->getValue() == 255){
					cout << t.high1 << t.forlinetype << recent->getLinetype() << t.wtattr << t.nfirstval << "(1 - 255): ";
					cin >> buff;
					recent->setValue(checkint(atoi(buff), 1, 255) - 1);
				}

				if(recent->getLinetype() == 6 && abs(recent->getAttr1()) > abs(recent->getAttr2()) && recent->getValue() == 0){
					cout << t.low1 << t.forlinetype << recent->getLinetype() << t.wtattr << t.nfirstval << "(2 - 256): ";
					cin >> buff;
					recent->setValue(checkint(atoi(buff), 2, 256) - 1);
				}

				if(recent->getLinetype() == 7 && abs(recent->getAttr1()) < abs(recent->getAttr2()) && recent->getValue() == 0){
					cout << t.low1 << t.forlinetype << recent->getLinetype() << t.wtattr << t.nfirstval << "(2 - 256): ";
					cin >> buff;
					recent->setValue(checkint(atoi(buff), 2, 256) - 1);
				}

				recent->setAttr3(-1);

				if(abs(recent->getAttr1()) == abs(recent->getAttr2())){
					cout << t.paramp;
					cin >> buff;
					recent->setAttr3(int(checkfloat(atof(buff), 0.0, 100.0) * (255.0 / 100.0)));
					if(recent->getLinetype() == 6 && recent->getAttr3() * 255.0/100.0 < recent->getValue()){
						recent->setAttr3(int(float(recent->getValue()) * 100.0/255.0)); // really?
						cout << t.low1 << t.forvalue << t.permissible << " " << recent->getAttr3() << "." << endl;
					}
					if(recent->getLinetype() == 7 && recent->getAttr3() * 255.0/100.0 > 255 - recent->getValue()){
						recent->setAttr3(int(float(recent->getValue()) * 100.0/255.0)); // really?
						cout << t.low1 << t.forvalue << t.permissible << " " << recent->getAttr3() << "." << endl;
					}
				}

			}

			if(valuecount == 16777215 && recent->getLinetype() != 0){
				cout << t.lastval << endl;
				recent->setLinetype(0);
			}

			before = recent;

		} while(recent->getLinetype());

		values(valuecount, bytecount, file, first);

		delete first;
	}

	if(amode == 0){

		unsigned char * valarray;
		int             time    ;
		int             told    ;
		int             val     ;
		int             valold  ;
		float           awert   ;
		float           faktor  ;


	/* We need to know the number of values   *
	 * if the silly user wants to use mode 0. */

		cout<< t.values;
		cin >> buff;
		valuecount = checkint(atoi(buff), 2, 16777215);

		valarray = new unsigned char[valuecount];

		cout<< t.firstval << "(1 - 256): ";

		cin >> buff;
		val = checkint(atoi(buff), 1, 256) - 1;
		valarray[0] = val;

		valold  = val;
		told    =   0;

		do {

			cout<< t.time << "(" << told + 1 << " - " << valuecount << "): ";
			cin >> buff;
			time = checkint(atoi(buff), told + 1, valuecount);
			cout<< t.val << "(1 - 256): ";
			cin >> buff;
			val  = checkint(atoi(buff), 1, 256) - 1;

/* Jetzt sind die Werte eingelesen,
 * die alten Werte sind noch in told
 * und valold gespeichert. Die Werte
 * mssen mit einer Geraden verbunden
 * werden */

			awert  = valold;
			faktor = float((val - valold)) / float((time - told));
			cout <<  t.rise << faktor << endl;

			for(i = 1; i <= time - told; i++) {
				awert = awert + faktor;
				valarray[told+i] = int(awert);
			}

			told = time; valold = val;

		} while(time < valuecount);
		
		values(valuecount, bytecount, file, valarray);
		
		delete []valarray;
	}

	if(amode == 2){
	
	
	}

	if(amode < 0 || amode > 2){
		cout << t.error;
		return cleanup(file);
	}

	return cleanup(file);
}


int line_help() {

	text_line_help t; // strings for user communication

	char buff[2];
	cout<< t.types;
	cin >> buff;
	return checkint(atoi(buff), 0, 7);
}


int length_help(bool third) {

	text_length_help t; // strings for user communication
	
	char buff[2];

	if(third){
		cout<< t.third;
		cin >> buff;
		return checkint(atoi(buff), 1, 8);
	}
	
	cout<< t.normal;
	cin >> buff;
	return checkint(atoi(buff), 1, 8);
}
