/**************************************************************************
                   fmfoutools.cpp  -  some fourier rools
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmfoutools.h"
#include "include/version.h"

#include <iostream>
using namespace std;

wavFile truncWav(wavFile w, float l) {
	float lowl = 0.0, highl = 0.0;
	for(int i=0; i<w.length; i++){
		if(w.data[i]<lowl)
			lowl=w.data[i];
		if(w.data[i]>highl)
			highl=w.data[i];
	}
	//cout << lowl << " ------ " << highl << endl;
	int nlow=0, nhigh=0;
	while(nlow<w.length/l || nhigh<w.length/l){
		if(nlow<w.length/l)
			lowl++;
		if(nhigh<w.length/l)
			highl--;
		nlow = nhigh = 0;
		for(int i=0; i<w.length; i++){
			if(w.data[i]<lowl)
				nlow++;
			if(w.data[i]>highl)
				nhigh++;
		}
	}

	//cout << lowl << " ------ " << highl << endl;

	int highi = findHigh(w,highl      );
	int lowi  = findLow (w,lowl, highi);
	int endi  = findHigh(w,highl,lowi );
	
	if(endi<0){
		wavFile v; v.data = w.data; v.length = 0; return v;
	}

	if(debug_level>1)
		cout << highi << " < " << lowi << " < " << endi << endl;
	//cout << w.data[highi] << ">" << w.data[lowi] << "<" << w.data[endi] << endl;
	
	wavFile v;
	v.length = endi - highi + 1;
	v.data = new float[v.length];
	for(int i=highi; i<=endi; i++)
		v.data[i-highi] = w.data[i];

	return v;
}

FAP* fouAnalyse(wavFile t, int N2, bool usephase, float ll) {
  int U,K,I,N,R,N1;
	float A,B;

	N=t.length;
	N1=N/2;
	float SN[N], CO[N], Z[N2], P[N2];

	for(I=0; I<N; I++)
   {
    SN[I]=sin(3.1415926*(N1-I)/N1);              /* Sinus   Factor */
    CO[I]=cos(3.1415926*(N1-I)/N1);              /* Cosinus Factor */
   }

   U=0;
   for(K=0; K<N2; K++)
   {
	 	 Z[K]=P[K]=0.0;
     A=0.0;
     B=0.0;

     for(I=0; I<N; I++)
     {
       R=(K+1)*I-int((I*(K+1))/N)*N;
       A=A+t.data[I]*CO[R];
       B=B+t.data[I]*SN[R];
     }

     A=A/N1;
     //if( K==N2 )   // warum das?
		 //	A=A/2;
     B=B/N1;

     Z[K]=sqrt(A*A+B*B);
		 if(usephase)
     		P[K]=atan(A/B)*180/3.1415926;

     if(P[K]<0.0001)
	  P[K]=0.0;
     if(Z[K]<0.00001){
	  P[K]=0.0;
	  Z[K]=0.0;
     }
   }

	 int   lo = 0;
	 float ta = 0.0;
	 float ma = 0.0;
	for(int i=0; i<N2; i++){
	if(Z[i]>ll){
		lo = i+1;
		ta+=Z[i];
		if(ma<Z[i])
			ma=Z[i];
	}
	else{
		Z[i]=0.0;
		P[i]=0.0;
	}
	}
	 ta = 1.0/ta;
	 ma = 1.0/ma;
	 if(ta<ma)
	 	ma = ta;

	FAP* fa = new FAP[N2];

	cout.setf(ios::fixed);

	 for(int i=0; i<N2; i++){
			fa[i].amp   = Z[i]*ma*0.99;
			if(usephase)
				fa[i].phase = P[i];
	}
	return fa;
}

int findHigh(wavFile w, float highl, int offset){
	int i = offset;
	if(i<0){
		if(debug_level>1)
			cout << "findHigh: exiting with negative offset" << endl;
		return -1;
	}
	while(i<w.length && w.data[i]<highl)
		i++;
	while(i+1<w.length && w.data[i+1]>w.data[i])
		i++;
	if(i>=w.length){
		if(debug_level)
			cout << "findHigh reached end" << endl;
		return -1;
	}
	return i;
}

int findLow(wavFile w, float lowl, int offset){
	int i = offset;
	if(i<0){
		if(debug_level>1)
			cout << "findLow: exiting with negative offset" << endl;
		return -1;
	}
	while(i<w.length && w.data[i]>lowl)
		i++;
	while(i+1<w.length && w.data[i+1]<w.data[i])
		i++;
	if(i>=w.length){
		if(debug_level)
			cout << "findHigh reached end" << endl;
		return -1;
	}
	return i;
}