/**************************************************************************
       fmlanguage.cpp  -  initializing char * for user communication
                             -------------------
    begin                : May 10th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmlanguage_fmplay.h"

text_fmplay::text_fmplay() {
	title     = "FMPlayer";
	syntax2   = " [file] [file options] [sound mixer options] [general options]\n";
	foptions  = "file specific options:\n\n";
	freqopt   = "    -f [frequency/Hz]\n\tFrequency of played sound for normal fms sound files.\n\t"
				"If the sound file is a \"midi\" file, -f specifies the concert pitch.\n\t"
				"The frequency value is necessary for every sound.\n\n";
	ffreqopt  = "      -F [frequency file] [frequency file options]\n\t  "
				"Frequency of played sound will change following a curve\n\t  "
				"specified by the frequency file.\n\t  The frequency file has to"
				" be a normal fms sound file.\n\n";
	ffreqopt2 = "\t-Fr [frequency file iterations]\n\t    How often the frequency file is iterated."
				" 1 by default.\n\n";
	ffreqopt3 = "\t-Fl [min. frequency] -Fh [max. frequency]\n\t    Minimum and maximum frequency.\n\t"
				"    By default, minimum is 0 and maximum is specified by -f.\n\n";
	volopt	  = "    -v [relative volume]\n\tThe file's volume relative to the volume of all other files\n\t"
				"in the same sound mixer.\n\tNot changing the total volume,\n\t"
				"only the volume quota of one single sound. 100 by default.\n\n";
	hvolopt   = "      -h [relative volume file] [relative volume file options]\n\t"
				"  Relative volume of played sound will change following an\n\t"
				"  envelope curve specified by the relative volume file.\n\t"
				"  The relative volume file has to be a normal fms sound file.\n\n";
	hvolopt2  = "\t-hr [relative volume file iterations]\n\t    How often the relative volume"
				" file is iterated. 1 by default.\n\n";
	hvolopt3  = "\t-hl [min. relative volume] -hh [max. relative volume]\n\t    "
				"Minimum and maximum relative volume.\n\t    By default, minimum is 0 and maximum is 100.\n\n";
	mopt      = "    -mi[0-31] [midi instrument file] [midi options]\n\t"
				"The midi instrument defines what a \"midi\" file sounds like.\n\t"
				"It has to be a normal fms sound file.\n\tThere are 32 different midi "
				"instruments per midi file possible.\n\tOne is necessary for every midi file.\n\n";
	mhvolopt  = "      -mh[0-31] [midi attack volume file] [midi attack volume file options]\n\t  "
				"Volume of every tone will change following an envelope curve\n\t  specified by the midi"
				" attack volume file.\n\t  There is one attack volume file per midi instrument possible.\n\t"
				"  A midi attack volume file has to be a normal fms sound file.\n\n";
	mhvolopt2 = "\t-mhr[0-31] [midi attack volume iterations]\n\t    How often the midi attack volume file"
				" is iterated. 1 by default.\n\t    Again, one per midi instrument is possible.\n\n";
	mhvolopt3 = "\t-mhl[0-31] [min. midi attack volume] -hh [max. relative volume]\n\t    "
				"Minimum and maximum midi attack volume.\n\t    By default, minimum is 0"
				" and maximum is 100.\n\t    Again, one per midi instrument is possible.\n\n";
	foptions2 = "Several files and their specific options without dividing arguments (see below)\n"
				"in between are played simultaneously as one \"sound mixer\".\n\n";
	poptions  = "sound mixer specific options:\n\n";
	timeopt   = "    -t [time/s]\n\tSimply the length of a sound mixer in seconds.\n\n";
	pvolopt   = "    -V [volume/%]\n\tTotal volume percentage, 100 by default.\n\n";
	phvolopt  = "      -H [volume file] [volume file options]\n\t  Volume of sound mixer will change "
				"following an envelope curve\n\t  specified by the relative volume file.\n\t  "
				"The volume file has to be a normal fms sound file.\n\n";
	phvolopt2 = "\t-Hr [volume file iterations]\n\t    How often the volume file is iterated. 1 by default.\n\n";
	phvolopt3 = "\t-Hl [min. volume] -Hh [max. volume]\n\t    Minimum and maximum volume percentage.\n\t"
				"    By default, minimum is 0 and maximum is 100.\n\n";
	poptions2 = "Several sound mixers, divided by -n but not by -l are played one after anotheras"
				" a \"channel\".\n\n";
	goptions  = "general options:\n\n";
	goptn     = "    -n\n\tDividing argument between two sound mixers.\n\t"
				"You can repeat a sound mixer adding it's number (within the same\n\tchannel)"
				" or it's number * -1 (within the other channel).\n\tE.g. -n1 repeats the first mixer"
				" of the same channel,\n\t-n-1 the first mixer of the other channel.\n\n";
	goptl     = "    -l\n\tDividing argument between two channels (for stereo output).\n\n";
	goptq     = "    -q\n\tNo text output.\n\n";
	goptw     = "    -w [.wav file name]\n\tNo sound output, but output into a wave file.\n\n";
//gopta	  = "    -a\n\tAsynchronous mode (pre-computing, useful on slow machines)\n\n";
	chan      = "channel ";
	mixer   = "sound mixer ";
	pcopy     = "copy of sound mixer ";
	insfreq1  = "Please insert ";
	insfreq2  = " (Hz) for ";
	freq      = "frequency";			// must be > 5 && < 14 chars (with \ts)
	volume    = "volume:\t\t";			// must be 16 chars (with \ts)
	inssec    = "Please insert time (s): ";
	time      = "time:\t\t";			//must be 16 chars (with \ts)
	repeat    = "iterations:\t";		//must be 16 chars (with \ts)
	tvol      = "total volume:\t";		//must be 16 chars (with \ts)
	hvol      = "volume file:\t";		//must be 16 chars (with \ts)
	hiter     = "vol. iterat.:\t";		//must be 16 chars (with \ts)
	hmin      = "minimal volume:\t";	//must be 16 chars (with \ts)
	hmax      = "maximal volume:\t";	//must be 16 chars (with \ts)
	ffreq     = "frequency file:\t";	//must be 16 chars (with \ts)
	fiter     = "freq. iterat.:\t";		//must be 16 chars (with \ts)
	fmin      = "min. frequency:\t";	//must be 16 chars (with \ts)
	fmax      = "max. frequency:\t";	//must be 16 chars (with \ts)
	midii     = "midi instr. ";			//must be <= 13 chars
	midih     = "mi. vol. f. ";			//must be <= 13 chars
	midihmin  = "m. min. vol. ";		//must be <= 13 chars
	midihmax  = "m. max. vol. ";		//must be <= 13 chars
	midihiter = "m. vol. i. ";			//must be <= 13 chars
	nomidii   = "This argument is only possible for files in midi mode (mode 3). Ignoring.";
	midireaderror = "Error reading file for midi mode. Exiting...";
	wrongfreq = "You have to fill in a valid frequency value for ";
	wrongtime = "You have to fill in a valid time value (0.001 - 600) (s) for sound mixer ";
	wrongvol  = "You have to fill in a valid volume value (%) for ";
	wrongtvol = "You have to fill in a valid total volume value (%) for ";
	wronghiter= "You have to fill in a valid volume file iteration value for ";
	wronghmin = "You have to fill in a valid minimal volume volume value for ";
	wronghmax = "You have to fill in a valid maximal volume value for ";
	wrongfiter= "You have to fill in a valid frequency file iteration value for ";
	wrongfmin = "You have to fill in a valid minimal frequency volume value for ";
	wrongfmax = "You have to fill in a valid maximal frequency value for ";
	missing_midii = "Missing midi instrument. \nSyntax: -mi [fms sound file]\nExiting.";
	dsperr    = "Error opening /dev/dsp.";
	chanerr   = "Error setting channels.";
	formaterr   = "Error setting format.";
	rateerr   = "Error setting sampling rate.";
	linetypeerr   = "unknown linetype: ";
	wavwriteerr   = "Error writing wav file.";
	syncerr   = "Error synchronizing.";
}
