/**************************************************************************
          fmofstream.cpp  -  providing fms-file writing utilities
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002-2005 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <cstdlib>
#include <cmath>
#include <iostream>

#include "include/fmofstream.h"
#include "include/version.h"

using namespace std;

// order:
// fmopen
// mode
// name
// values
// cleanup

bool cleanup(int file) { // should we have error handling here? oh, well...

	close(file);
	return 1;
}

int mode(char buff, int file) {

	if(buff == 49 || buff == 50 || buff == 51 || buff == 52) { // if '1', '2' or '3'
		buff = buff - 49;

	/* please note:                          *
	 * The mode called "mode 1" for the user *
	 * is mode 0 for fms.			 *
	 * "Mode 2" is mode 1 for fms.		 *
	 * This is because of atoi returning 0	 *
	 * on error. We don't want to have mode	 *
	 * 0 if we type something stupid.	 */

		write(file, &buff, 1);
		return buff;
	}

	return -1;
}

int mode(int m, int file) {
	char buff = m;
	write(file, &m, 1);
	return buff;
}

bool name(char *pointer, int size, int file) {

	char buff = size;
	write(file, &buff, 1);
	write(file, pointer, size);
	return 1;
}


bool values(int valuecount, int bytecount, int file, unsigned char * v) {  // bare values

	char  buff[3];

/* Umrechnung der Dezimalzahlen
 * in eine Art 256er-System */

	buff[2] = valuecount % 256;
	buff[1] = ((valuecount % 65536) - (valuecount % 256)) / 256;
	buff[0] =(valuecount - (valuecount % 65536)) / 65536;
	write(file, buff, 3);

	buff[0] = bytecount;
	buff[1] = '\0';
	write(file, buff, 1);

	write(file, v, valuecount);

	return 1;
}

bool values(int valuecount, int bytecount, int file, VTLP * v) {  // Functions

	char  buff[5]      ;

	buff[2] = valuecount % 256;
	buff[1] = ((valuecount % 65536) - (valuecount % 256)) / 256;
	buff[0] =(valuecount - (valuecount % 65536)) / 65536;
#ifdef fileformat_debug
		cout << "ffd: valuecount is " << valuecount 
		     << ", will write " << int(buff[0]) << " " << int(buff[1]) << " " << int(buff[2]) << endl;
#endif
	write(file, buff, 3);

	buff[0] = bytecount;
#ifdef fileformat_debug
		cout << "ffd: bytecount is " << bytecount 
		     << ", will write " << int(buff[0]) << endl;
#endif
	write(file, buff, 1);

/* Die Werte sind eingelesen               *
 * und befinden sich in den TVLP-Klassen,  *
 * die nicht alle direkt erreichbar, aber  *
 * durch eine Pointerliste verbunden sind. *
 * Jetzt werden sie ausgelesen und in die  *
 * Datei geschrieben.                      */

	while(v) {
		buff[1] = v->getTime() % 256;
		buff[0] = ((v->getTime() % 65536) - (v->getTime() % 256)) / 256;
		buff[2] = v->getValue();
		buff[3] = v->getLinetype();
		write(file,buff,4);

		if(v->getLinetype() == 4 || v->getLinetype() == 5){
			buff[0] = int(v->getAttr1());
#ifdef fileformat_debug
			cout << "ffd: linetype 4 || 5 - attribute is " << v->getAttr1() 
			     << ", will write " << int(buff[0]) << endl;
#endif
			write(file,buff,1);
	}

		if(v->getLinetype() == 6 || v->getLinetype() == 7){
			buff[0] = int(v->getAttr1() + 8) + int(v->getAttr2() + 7) * 16;
			write(file,buff,1);
			if(v->getAttr3() >= 0){
				buff[0] = v->getAttr3();
				write(file,buff,1);
			}
		}
		
		v = v->next;
	};

	return 1;

}


bool values(int tonecount, int file, PBSP * v) {  // Midi-like

	char  buff[2];

	buff[1] = tonecount % 256;
	buff[0] = (tonecount - (tonecount % 256)) / 256;
	write(file, buff, 2);

/* Die Werte sind eingelesen               *
 * und befinden sich in den PBSP-Klassen,  *
 * die nicht alle direkt erreichbar, aber  *
 * durch eine Pointerliste verbunden sind. *
 * Jetzt werden sie ausgelesen und in die  *
 * Datei geschrieben.                      */

	buff[0] = v->pitch - 1;
	if(v->third)
		buff[0] = buff[0] + 128;
	buff[1] = 8 * v->attr + v->length - 9; // 8 * (v->attr - 1) + (v->length - 1);

	write(file,buff,2);

	do {

		v = v->next;
		buff[0] = v->pitch - 1;
		if(v->third)
			buff[0] = buff[0] + 128;
		buff[1] = 8 * v->attr + v->length - 9; // 8 * (v->attr - 1) + (v->length - 1);

		write(file,buff,2);
		if(v->attr==32) // chord
		{
			buff[0] = v->chord;
			write(file,buff,1);
		}

	} while(v->next);

	return 1;

}

bool values(int otcount, int bytecount, int file, FAP * v, bool usephase) {

	if(bytecount>3){
		if(debug_level)
			cout << "bytecount " << bytecount << " too high in mode 3" << endl;
		return 0;
	}

	if(debug_level)
		cout << "writing file in mode 3 with otcount=" << otcount << " and bytecount=" << bytecount << endl;

	unsigned char  buff[3+bytecount];

/* Umrechnung der Dezimalzahlen
 * in eine Art 256er-System */

	buff[1] = otcount % 256;
	buff[0] = ((otcount % 65536) - (otcount % 256)) / 256;
	write(file, buff, 2);

	buff[0] = bytecount+usephase*128;
	buff[1] = '\0';
	write(file, buff, 1);

	for(int i=0; i<otcount; i++){
		if(v[i].amp>1.0){
			if(debug_level)
				cout << "amplitude > 1; exiting..." << endl;
			return 0;
		}
		if(debug_level>1)
			cout << "set amplitude from " << v[i].amp;
		v[i].amp = v[i].amp * pow(255.0,bytecount) * (pow(255.0,bytecount)-1.0) / pow(255.0,bytecount);
		if(debug_level>1)
			cout << " to " << v[i].amp << endl;
		for(int j=0; j<bytecount; j++){
			if(debug_level>1)
				cout << int(pow(256.0,j)) << "-digit of " << v[i].amp << " is " << (int(v[i].amp) % int(pow(256.0,j+1))) << " / " << int(pow(256.0,j)) << " = ";
			buff[bytecount-j-1]=(int(v[i].amp) % int(pow(256.0,j+1))) / int(pow(256.0,j));
			if(debug_level>1)
				cout << int(buff[bytecount-j-1]) << " at position " << bytecount-j-1 << endl;
			v[i].amp-= int(v[i].amp) % int(pow(256.0,j+1));
		}
		if(usephase){
			buff[bytecount]=int(v[i].phase*256.0/180.0);
			if(debug_level>1)
				cout << "phase of " << v[i].phase << " => " << int(buff[bytecount]) << "\nwriting that values" << endl;
		}
		write(file,buff,bytecount+usephase);
	}

	if(debug_level)
		cout << "writing file finished!" << endl;
	return 1;
}


int fmopen(char *file, bool override) {

	int fd=open(file, O_RDONLY);
	if(fd>0)
	  close(fd);
	else if(fd<=0 && override==0)
	  return 0;
	
	return (open(file, O_WRONLY | O_CREAT | O_TRUNC, 0644));	/* rw-r--r-- */
}
