/**************************************************************************
                    fmplay.cpp  -  playing fms-sound-files
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// requested features:	midi auto-detect
//						GUI
//						proper command-line parsing


#include <iostream>
#include <cstring>
#include <cmath>
#include <cstdlib>
#include <cstdio>

#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

#include "include/fmlanguage_fmplay.h"
#include "include/checkint.h"
#include "include/fmplayer.h"
#include "include/version.h"

using namespace std;

int main(int argc, char *argv[]) {

	text_fmplay          t; // strings for user communication
	FMPlayer             p; // FMPlayer, the API that has Anything(c) you need

	char    buff[256];

	bool    talk = 1; // if false: print no messages
	bool    sync = 1; // play in sync mode?
	bool    parseerror = 0;
	bool    got_sound=0; // do we have a user requested sound file on out recent sound mixer?

	int i, m;

	if(argc<2) {
		if(talk){
		cout << t.version << fms_version << endl;
		cout << t.license << endl;
		cout << t.warranty << endl << endl;
		cout << t.syntax1 << ": " << argv[0] << t.syntax2 << endl << t.foptions << t.freqopt << t.ffreqopt << t.ffreqopt2 << t.ffreqopt3 << t.volopt << t.hvolopt << t.hvolopt2 << t.hvolopt3 << t.mopt << t.mhvolopt << t.mhvolopt2 << t.mhvolopt3 << t.foptions2 << t.poptions << t.timeopt << "    -R [repetitions]\n\thow often the mixer is repeated.\n\n" << t.pvolopt << t.phvolopt << t.phvolopt2 << t.phvolopt3 << t.poptions2 << t.goptions << t.goptn << t.goptl << t.goptq << t.goptw << "    -a\n\tAsynchronous mode (pre-computing, useful on slow machines)\n\n" << flush;
		}
	}


	/* parse all the command line args */

	for(i = 1; i < argc; i++){

		if(argv[i][0] == '-' && argv[i][1] == 'f'){  // frequency option
			if(i+1<argc)
				p.aSound->setFreq(atof(argv[i+1]));
			else
			{
				cout << "warning: switch -f requires an argument" << endl; 
			}
			i++;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'F'){ // frequency file option
			switch(argv[i][2]){
			  case '\0':
					p.aSound->setFFreq(); // just to make sure we have ffreq
					if(i+1<argc)
						p.aSound->ffreq->setFilename(argv[i+1]);
					else
					{
						cout << "warning: switch -F requires an argument" << endl; 
					}
				i++;
				continue;

			  case 'r':
				p.aSound->setFFreq(); // just to make sure we have ffreq
				if(i+1<argc)
					p.aSound->ffreq->setIter(atof(argv[i+1]));
				else
				{
					cout << "warning: switch -Fr requires an argument" << endl; 
				}
				i++;
				continue;

			  case 'l':
				p.aSound->setFFreq(); // just to make sure we have ffreq
				if(i+1<argc)
					p.aSound->ffreq->setMin(atof(argv[i+1]));
				else
				{
					cout << "warning: switch -Fr requires an argument" << endl; 
				}
				i++;
				continue;

			  case 'h':
				p.aSound->setFFreq(); // just to make sure we have ffreq
				if(i+1<argc)
					p.aSound->ffreq->setMax(atof(argv[i+1]));
				else
				{
					cout << "warning: switch -Fr requires an argument" << endl; 
				}
				i++;
				continue;

			  default:
				parseerror = 1;
			}
		}

		if(argv[i][0] == '-' && argv[i][1] == 'h'){ // sound hvol file option
			switch(argv[i][2]){
			  case '\0':
				p.aSound->setHVol(); // just to make sure we have hvol
				if(i+1<argc)
					p.aSound->hvol->setFilename(argv[i+1]);
				else
				{
					cout << "warning: switch -h requires an argument" << endl; 
				}
				i++;
				continue;

			  case 'r':
				p.aSound->setHVol(); // just to make sure we have hvol
				if(i+1<argc)
					p.aSound->hvol->setIter(atof(argv[i+1]));
				else
				{
					cout << "warning: switch -hr requires an argument" << endl; 
				}				i++;
				continue;

			  case 'l':
				p.aSound->setHVol(); // just to make sure we have hvol
				if(i+1<argc)
					p.aSound->hvol->setMin(atof(argv[i+1])/100.0);
				else
				{
					cout << "warning: switch -hl requires an argument" << endl; 
				}
				i++;
				continue;

			  case 'h':
				p.aSound->setHVol(); // just to make sure we have hvol
				if(i+1<argc)
					p.aSound->hvol->setMax(atof(argv[i+1])/100.0);
				else
				{
					cout << "warning: switch -hh requires an argument" << endl; 
				}
				i++;
				continue;

			  default:
				parseerror = 1;
			}
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'H'){ // mixer hvol file option
			switch(argv[i][2]){
			  case '\0':
				p.aMixer->setHVol(); // just to make sure we have hvol
				if(i+1<argc)
					p.aMixer->hvol->setFilename(argv[i+1]);
				else
				{
					cout << "warning: switch -H requires an argument" << endl; 
				}
				i++;
				continue;

			  case 'r':
				p.aMixer->setHVol(); // just to make sure we have hvol
				if(i+1<argc)
					p.aMixer->hvol->setIter(atof(argv[i+1]));
				else
				{
					cout << "warning: switch -Hr requires an argument" << endl; 
				}
				i++;
				continue;

			  case 'l':
				p.aMixer->setHVol(); // just to make sure we have hvol
				if(i+1<argc)
					p.aMixer->hvol->setMin(atof(argv[i+1])/100.0);
				else
				{
					cout << "warning: switch -Hl requires an argument" << endl; 
				}
				i++;
				continue;

			  case 'h':
				p.aMixer->setHVol(); // just to make sure we have hvol
				if(i+1<argc)
					p.aMixer->hvol->setMax(atof(argv[i+1])/100.0);
				else
				{
					cout << "warning: switch -Hh requires an argument" << endl; 
				}
				i++;
				continue;

			  default:
				parseerror = 1;
			}
		}

		if(argv[i][0] == '-' && argv[i][1] == 'l'){ // switch to other channel
			p.switchChannel();
			got_sound=0;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'm'){ // midi options
			switch(argv[i][2]){
			  case 'i': // midi instrument
			    m = 3;
				while(argv[i][m] != '\0'){
					buff[m-3] = argv[i][m];
					m++;
				}
				buff[m-3] = '\0';
				p.aSound->setMidi(); // just to make sure we have midi
				if(i+1<argc)
					p.aSound->midi->setMidiI(atoi(buff), argv[i+1]);
				else
				{
					cout << "warning: switch -mi requires an argument" << endl; 
				}
				i++;
				continue;

			  case 'h': // midi envelope
				 switch(argv[i][3]){
				  case '\0':
				  case  '0':
				  case  '1':
				  case  '2':
				  case  '3':
					 m = 3;
					 while(argv[i][m] != '\0'){
						buff[m-3] = argv[i][m];
						m++;
					 }
					 buff[m-3] = '\0';
					 p.aSound->setMidi(); // just to make sure we have midi
					 if(i+1<argc)
					 	p.aSound->midi->setMidiH(atoi(buff), argv[i+1]);
					 else
					 {
					 	cout << "warning: switch -mh requires an argument" << endl; 
						p.aSound->midi->setMidiH(atoi(buff), "midi/attack");
					 }
					 i++;
					 continue;
				  case 'r':
					 m = 4;
					 while(argv[i][m] != '\0'){
						 buff[m-4] = argv[i][m];
						 m++;
					 }
					 buff[m-4] = '\0';
					 p.aSound->setMidi(); // just to make sure we have midi
					 if(i+1<argc)
					 	p.aSound->midi->setMidiHIter(atoi(buff), atof(argv[i+1]));
					 else
					 {
					 	cout << "warning: switch -mhr requires an argument" << endl; 
					 }
					 i++;
					 continue;
				  case 'l':
					 m = 4;
					 while(argv[i][m] != '\0'){
						 buff[m-4] = argv[i][m];
						 m++;
					 }
					 buff[m-4] = '\0';
					 p.aSound->setMidi(); // just to make sure we have midi
					 if(i+1<argc)
					 	p.aSound->midi->setMidiHMin(atoi(buff), atof(argv[i+1])/100.0);
					 else
					 {
					 	cout << "warning: switch -mhl requires an argument" << endl; 
					 }
					 i++;
					 continue;
					case 'h':
					 m = 4;
					 while(argv[i][m] != '\0'){
						buff[m-4] = argv[i][m];
						m++;
					 }
					 buff[m-4] = '\0';
					 p.aSound->setMidi(); // just to make sure we have midi
					 if(i+1<argc)
					 	p.aSound->midi->setMidiHMax(atoi(buff), atof(argv[i+1])/100.0);
					 else
					 {
					 	cout << "warning: argument -mhr requires a filename" << endl; 
					 }
					 i++;
					 continue;
				  default:
				   parseerror = 1;
					 continue;
				 }
				continue;

			  default:
				parseerror = 1;
				continue;
			}
		}

		if(argv[i][0] == '-' && argv[i][1] == 'n'){ // next mixer
			p.nextMixer();
			got_sound=0;
			if(argv[i][2] != '\0'){
				m = 2;
				while(argv[i][m] != '\0'){
					buff[m-2] = argv[i][m];
					m++;
				}
				buff[m-2] = '\0';
				p.aMixer->setSelf(atoi(buff));
			}
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'q'){ // shhh, be quiet
			talk = 0;
			continue;
		}
		
		if(argv[i][0] == '-' && argv[i][1] == 'a'){ // asynchronous
			sync = 0;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'r'){ // iterations
			if(i+1<argc && atof(argv[i+1])>0)
				p.aMixer->setRepeat(atof(argv[i+1]));
			else
			{
				cout << "warning: switch -r requires an argument > 0" << endl; 
			}
			i++;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'R'){ // iterations
			if(i+1<argc)
				p.aChannel->setRepeat(atoi(argv[i+1]));
			else
			{
				cout << "warning: switch -R requires an argument" << endl; 
			}
			i++;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 't'){ // time
			if(i+1<argc && atof(argv[i+1])>=0)
				p.aMixer->setTime(atof(argv[i+1]));
			else
			{
				cout << "warning: switch -t requires an argument >= 0" << endl; 
			}
			i++;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'v'){ // relative sound volume
			if(i+1<argc)
				p.aSound->setVolume(atof(argv[i+1]) / 100.0);
			else
			{
				cout << "warning: switch -v requires an argument" << endl; 
			}
			i++;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'V'){ // mixer overall volume
			if(i+1<argc)
				p.aMixer->setVolume(atof(argv[i+1]) / 100.0);
			else
			{
				cout << "warning: switch -V requires an argument" << endl; 
			}
			i++;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'w'){ // write to wav instead
			if(i+1<argc)
				p.setWavFile(argv[i+1]);
			else
			{
				cout << "warning: switch -w requires an argument" << endl; 
			}
			i++;
			continue;
		}

		if(argv[i][0] != '-'){ // it is a sound file!
			if(got_sound){
				p.nextSound();
			}
			p.aSound->setFilename(argv[i]);
			got_sound=1;
		}
	}


	// here should be some checking stuff
	// and maybe some informative output as well!
	
	if(talk)
		cout <<  t.title << endl;


	if(parseerror) {
		if(talk){
		cout << t.version << fms_version << endl;
		cout << t.license << endl;
		cout << t.warranty << endl << endl;
		cout << t.syntax1 << ": " << argv[0] << t.syntax2 << endl << t.foptions << t.freqopt << t.ffreqopt << t.ffreqopt2 << t.ffreqopt3 << t.volopt << t.hvolopt << t.hvolopt2 << t.hvolopt3 << t.mopt << t.mhvolopt << t.mhvolopt2 << t.mhvolopt3 << t.foptions2 << t.poptions << t.timeopt << t.pvolopt << t.phvolopt << t.phvolopt2 << t.phvolopt3 << t.poptions2 << t.goptions << t.goptn << t.goptl << t.goptq << t.goptw << flush;
		}
		return 0;
	}

	/* go for it */


 try{
	if(sync)
		p.syncPlay();
	else
		p.play();
 }
 catch(int x){
	cout << "an error occurred: " << x << endl;
	return 0;
 }
	// that took some 100 lines before, but now my api does it All(c)
	
 return 0;
}

