#include "include/fmplayer.h"
#include <cstdlib>
#include <iostream>

using namespace std;

int main(int argc, char * argv[]){
	if(argc==1){
		cout << argv[0] << " 0: 3-tone-music\n"
		     << argv[0] << " 1: random music\n"
		     << argv[0] << " 2 [mlen]: constant-value noise (Noise)\n"
		     << argv[0] << " 3: random-value noise (Random)\n"
		     << argv[0] << " 4 [min.Freq.] [max.Freq.] [file1] [file2]: random frequency modulation\n"
				 << argv[0] << " 5 [min.Freq.] [max.Freq.] [file1] [file2] [minmlen] maxmlen] [file3] : random music -> noise\n"
				 << argv[0] << " 6: four kinds of noise\n" << endl;
		return 0;
	}
	int option;
	option=atoi(argv[1]);
	FMPlayer p; 
	if(option==0){
		p.aMixer->setTime(10);
		p.aSound->setFilename("sounds/sin");
		p.aSound->setFFreq();
		p.aSound->ffreq->setMin(250);
		p.aSound->ffreq->setMax(1000);
		p.aSound->ffreq->setFilename("sounds/verteilung");
		p.aSound->ffreq->setFilemode(RandNoise);
		p.aSound->ffreq->setMLen(5000);
		p.play();
	}
	if(option==1){
		p.aMixer->setTime(10);
		p.aSound->setFilename("sounds/sin");
		p.aSound->setFFreq();
		p.aSound->ffreq->setMin(250);
		p.aSound->ffreq->setMax(1000);
		p.aSound->ffreq->setFilename("sounds/gauss");
		p.aSound->ffreq->setFilemode(Noise);
		p.aSound->ffreq->setMLen(10000);
		p.play();
	}
	if(option==2){
		float mlen = 5.0;
		if(argc>2)
			mlen = atof(argv[2]);
		p.setRate(44100);
		p.aSound->setFilename("sounds/gauss");
		p.aSound->setFilemode(Noise);
		p.aSound->setMLen(mlen);
		p.nextMixer();
		p.aMixer->setTime(0.3);
		p.aSound->setFilename("sounds/pause");
		p.nextMixer();
		p.aSound->setFilename("sounds/sin");
		p.aSound->setFilemode(Noise);
		p.aSound->setMLen(mlen);
		p.nextMixer();
		p.aMixer->setTime(0.3);
		p.aSound->setFilename("sounds/pause");
		p.nextMixer();
		p.aSound->setFilename("sounds/saw");
		p.aSound->setFilemode(Noise);
		p.aSound->setMLen(mlen);
		p.nextMixer();
		p.aMixer->setTime(0.3);
		p.aSound->setFilename("sounds/pause");
		p.nextMixer();
		p.aSound->setFilename("sounds/par");
		p.aSound->setFilemode(Noise);
		p.aSound->setMLen(mlen);
		p.nextMixer();
		p.aMixer->setTime(0.3);
		p.aSound->setFilename("sounds/pause");
		p.nextMixer();
		p.aSound->setFilename("sounds/verteilung");
		p.aSound->setFilemode(Noise);
		p.aSound->setMLen(mlen);
		p.play();
	}
	if(option==3){
		//p.setRate(44100);
		p.aMixer->setTime(1);
		p.aSound->setFilename("sounds/gauss");
		p.aSound->setFilemode(Rand);
		p.nextMixer();
		p.aMixer->setTime(0.3);
		p.aSound->setFilename("sounds/pause");
		p.nextMixer();
		p.aMixer->setTime(1);
		p.aSound->setFilename("sounds/sin");
		p.aSound->setFilemode(Rand);
		p.nextMixer();
		p.aMixer->setTime(0.3);
		p.aSound->setFilename("sounds/pause");
		p.nextMixer();
		p.aMixer->setTime(1);
		p.aSound->setFilename("sounds/verteilung");
		p.aSound->setFilemode(Rand);
		p.play();
	}
	if(option==4){
		float minfreq=0.0;
		float maxfreq=3000.0;
		char  *file="sounds/sin";
		char  *file2="sounds/sin";
		if(argc>2)
			minfreq = atof(argv[2]);
		if(argc>3)
			maxfreq = atof(argv[3]);
		if(argc>4)
			file = argv[4];
		if(argc>5)
			file2 = argv[5];

		p.aMixer->setTime(3);
		p.aSound->setFilename(file2);
		p.aSound->setFFreq();
		p.aSound->ffreq->setMin(minfreq);
		p.aSound->ffreq->setMax(maxfreq);
		p.aSound->ffreq->setFilename(file);
		p.aSound->ffreq->setFilemode(Rand);
		p.play();
		p.setWavFile("noise.wav");
		p.play();
	}
	if(option==5){
		float minfreq=0.0;
		float maxfreq=3000.0;
		char  *file="sounds/sin";
		char  *file2="sounds/sin";
		char  *file3="sounds/flatgauss2";
		float minmlen=1.0;
		float maxmlen=1000.0;
		if(argc>2)
			minfreq = atof(argv[2]);
		if(argc>3)
			maxfreq = atof(argv[3]);
		if(argc>4)
			file = argv[4];
		if(argc>5)
			file2 = argv[5];
		if(argc>6)
			minmlen = atof(argv[6]);
		if(argc>7)
			maxmlen = atof(argv[7]);
		if(argc>8)
			file3 = argv[8];
		p.aMixer->setTime(10);
		p.aSound->setFilename(file2);
		p.aSound->setFFreq();
		p.aSound->ffreq->setMin(minfreq);
		p.aSound->ffreq->setMax(maxfreq);
		p.aSound->ffreq->setFilename(file);
		p.aSound->ffreq->setFilemode(Noise);
		p.aSound->ffreq->setMLM();
		p.aSound->ffreq->mlm->setFilename(file3);
		p.aSound->ffreq->mlm->setMin(minmlen);
		p.aSound->ffreq->mlm->setMax(maxmlen);
		p.play();
	}
	if(option==6){
		p.aMixer->setTime(2);
		p.aSound->setFilename("sounds/gauss");
		p.aSound->setFilemode(Noise);
		
		p.nextMixer();
		p.aMixer->setTime(2);
		p.aSound->setFilename("sounds/gauss");
		p.aSound->setFilemode(NoiseRand);
		p.aSound->setRNF();
		p.aSound->rnf->setFilename("sounds/gauss");
		
		p.nextMixer();
		p.aMixer->setTime(2);
		p.aSound->setFilename("sounds/gauss");
		p.aSound->setFilemode(RandNoise);
		p.aSound->setRNF();
		p.aSound->rnf->setFilename("sounds/gauss");

		p.nextMixer();
		p.aMixer->setTime(2);
		p.aSound->setFilename("sounds/gauss");
		p.aSound->setFilemode(Rand);
		
		p.play();
	}
	if(option==7){
		p.aMixer->setTime(5);
		p.aSound->setFilename("sounds/s");
		p.aSound->setFFreq();
			p.aSound->ffreq->setFilename("sounds/gauss");
			p.aSound->ffreq->setFilemode(Noise);
			p.aSound->ffreq->setMLM();
				p.aSound->ffreq->mlm->setFilename("sounds/gauss");
				p.aSound->ffreq->mlm->setMin(1);
				p.aSound->ffreq->mlm->setMax(50);
			p.aSound->ffreq->setMinH();
				p.aSound->ffreq->minh->setFilename("sounds/sin");
				p.aSound->ffreq->minh->setMin(300);
				p.aSound->ffreq->minh->setMax(400);
			p.aSound->ffreq->setMaxH();
				p.aSound->ffreq->maxh->setFilename("sounds/cosin");
				p.aSound->ffreq->maxh->setMin(1000);
				p.aSound->ffreq->maxh->setMax(1700);
		p.play();
	}
	if(option==8){
		p.aMixer->setTime(5);
		p.aSound->setFilename("sounds/sinpart");
		p.aSound->setFreq(300);
		p.aSound->setHVol();
			p.aSound->hvol->setFilename("sounds/gauss");
			p.aSound->hvol->setFilemode(Noise);
			p.aSound->hvol->setMode(AmpMod);
			p.aSound->hvol->setMLen(1);
		p.play();
	}
}


