#include "include/fmplayer.h"
#include <cstdlib>
#include <iostream>

using namespace std;

int main(int argc, char *argv[]) {
	cout << "FMS Recursive Frequency Modulator" << endl;
	if(argc<2){
		cout << "syntax: " << argv[0] << " [number of modulation generations]" << endl;
		return 0;
	}
	int gen = atoi(argv[1]);
	FMPlayer p;
	p.setRate(44100);
	p.aMixer->setTime(30);
	p.aSound->setFilename("sounds/sin");
	
	if(gen>0){
		// 1. Generation
		p.aSound->setFFreq();
		p.aSound->ffreq->setFilename("sounds/sin");
		p.aSound->ffreq->setMin(300);
	}

	if(gen>1){
		// 2. Generation
		p.aSound->ffreq->setFFreq();
		p.aSound->ffreq->ffreq->setFilename("sounds/sin");
		p.aSound->ffreq->setMinIter(0);
		p.aSound->ffreq->setMaxIter(400);
		p.aSound->ffreq->ffreq->setIter(2);
	}

	if(gen>2){
		// 3. Generation
		p.aSound->ffreq->ffreq->setFFreq();
		p.aSound->ffreq->ffreq->ffreq->setFilename("sounds/sin");
		p.aSound->ffreq->ffreq->setMinIter(0);
		p.aSound->ffreq->ffreq->setMaxIter(205);
		p.aSound->ffreq->ffreq->ffreq->setIter(12.5);
	}

	if(gen>3){
		// 4. Generation
		p.aSound->ffreq->ffreq->ffreq->setFFreq();
		p.aSound->ffreq->ffreq->ffreq->ffreq->setFilename("sounds/sin");
		p.aSound->ffreq->ffreq->ffreq->setMinIter(0);
		p.aSound->ffreq->ffreq->ffreq->setMaxIter(25);
		p.aSound->ffreq->ffreq->ffreq->ffreq->setIter(1250);
	}
	
	if(gen>4){
		// 5. Generation
		p.aSound->ffreq->ffreq->ffreq->ffreq->setFFreq();
		p.aSound->ffreq->ffreq->ffreq->ffreq->ffreq->setFilename("sounds/sin");
		p.aSound->ffreq->ffreq->ffreq->ffreq->setMinIter(0);
		p.aSound->ffreq->ffreq->ffreq->ffreq->setMaxIter(2500);
		p.aSound->ffreq->ffreq->ffreq->ffreq->ffreq->setIter(1);
	}

	p.syncPlay();
}

