// this is free software

#include "include/fmplayer.h"
#include "include/version.h"

#include <iostream>
#include <cstring>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <sys/types.h>

#include <pthread.h>
// using Posix Threads with the help of the following
// tutorial: http://dis.cs.umass.edu/~wagner/threads_html/

//#define debug_mode

using namespace std;

FMPlayer *Player;
bool reading,playing; // states

enum FMSoundAttribute {
	APath,
	AFrequency,
	AVolume,
	ASweep,
	AMidiInstrument,
	AMidiHVol,
	ASoundNone
};

enum FMMixerAttribute {
	MATime,
	MAVolume,
	MANone
};

enum Operator {
	OPlus,
	OMinus,
	OEqual,
	ONone
};

void set(FMSound *sound, FMSoundAttribute attr, Operator oper, char* arg)
// actually set sound's attr oper arg
{
#ifdef debug_mode
  cout << "setting with argument " << arg << "=" << atof(arg) << endl;
#endif // debug_mode
  switch (attr)
  {
    case APath: 
		// if no absolute path or starting with ., it's relative to datadir
		// copied from tags-0.09
		/*if ((arg[1]!='/') && (arg[1]!='.'))
		{
			char *filename = new char[255];
			filename[0]='\0';
			strcat(filename, DATADIR);
			strcat(filename, "sounds/");
			strcat (filename, arg); 
			sound->setFilename(filename);
			sound->openFile();
		} else*/
		{
			sound->setFilename(arg);
			sound->openFile();
		}
	break;
    case AFrequency:
    	switch (oper)
	{
	   case OPlus:
#ifdef debug_mode
	     cout << sound->getFreq() << " Plus " << atof(arg) << endl;
#endif // debug_mode
	     sound->setFreq(sound->getFreq()+atof(arg));
	     break;
	   case OMinus:
#ifdef debug_mode
	     cout << sound->getFreq() << " Minus " << atof(arg) << endl;
#endif // debug_mode
	     sound->setFreq(sound->getFreq()-atof(arg));
	     break;
	   case OEqual:
#ifdef debug_mode
	     cout << "Equal" << endl;
#endif // debug_mode
	     sound->setFreq(atof(arg));
	     break;
	}
	break;
    case AVolume:
	switch (oper)
	{
	   case OPlus:
	     sound->setVolume(sound->getVolume()+atof(arg));
	     break;
	   case OMinus:
	     sound->setVolume(sound->getVolume()-atof(arg));
	     break;
	   case OEqual:
	     sound->setVolume(atof(arg));
	     break;
	}
	break;
	case ASweep:
	switch (oper)
	{
	   case OPlus:
	   case OMinus:
	     cout << "no +- operator for sweep implemented, sorry" << endl;
	   case OEqual:
	     sound->setSweep(atof(arg));
		 break; 
	} 
	break;
    case AMidiInstrument:
    	sound->setMidi();
	// if no absolute path or starting with ., it's relative to datadir
	/*if ((arg[1]!='/') && (arg[1]!='.'))
	{
		char *filename = new char[255];
		filename[0]='\0';
		strcat(filename, DATADIR);
		strcat(filename, "sounds/");
		strcat (filename, arg); 
		sound->midi->setMidiI(0,filename);
	} 
	else*/
	{
	sound->midi->setMidiI(0,arg);
	}
	break;
    case AMidiHVol:
    	sound->setMidi();
	// if no absolute path or starting with ., it's relative to datadir
	/*if ((arg[1]!='/') && (arg[1]!='.'))
	{
		char *filename = new char[255];
		filename[0]='\0';
		strcat(filename, DATADIR);
		strcat(filename, "sounds/");
		strcat (filename, arg); 
		sound->midi->setMidiH(0,filename);
	} 
	else*/
	{
		sound->midi->setMidiH(0,arg);
	}
	break;
    default:
    	cout << "argument error, ignoring..." << endl;
	break;
  } 
}

void set(FMMixer *mixer, FMMixerAttribute attr, Operator oper, char* arg)
// actually set mixer's attr oper arg
{
#ifdef debug_mode
  cout << "setting with argument " << arg << "=" << atof(arg) << endl;
#endif // debug_mode
  switch (attr)
  {
    case MATime:
    	switch (oper)
	{
	   case OPlus:
	     mixer->setTime(mixer->getTime()+atof(arg));
	     break;
	   case OMinus:
	     if(mixer->getTime()>atof(arg))
	     	mixer->setTime(mixer->getTime()-atof(arg));
	     break;
	   case OEqual:
	     mixer->setTime(atof(arg));
	     break;
	}
	break;
    case MAVolume:
	switch (oper)
	{
	  case OPlus:
	  case OMinus:
		  cout << "+- for mixer volume not implemented" << endl;
	  case OEqual:
	     mixer->setVolume(atof(arg));
	}
   }
}


void config(FMSound *sound, char *line)
// extract sound config commands from line
{
#ifdef debug_mode
	cout << "configuring sound " << sound->soundnr << " with " << line << flush;
#endif // debug_mode
	int i=0;
	int j=0;
	char arg[256];
	FMSoundAttribute attr=ASoundNone;
	Operator oper=ONone;
	while(i<strlen(line))
	{
	  // if no operator yet
	  if(oper==ONone)  switch(line[i])
	  {
	    case 'p':
	    	attr=APath;
		break;
	    case 'f':
	    	attr=AFrequency;
		break;
	    case 'v':
	    	attr=AVolume;
		break;
		case 's':
			attr=ASweep;
		break;
	    case 'm': // midi option
	    	i++;
		switch(line[i])
		{
		  case 'i':
		     attr=AMidiInstrument;
		     break;
		  case 'h':
		     attr=AMidiHVol;
		     break;
		  default:
#ifdef debug_mode
	    	     cout << "syntax error; ignoring" << endl;
#endif // debug_mode
		     break;
		} 
		break;
	    case '+':
	    	oper=OPlus;
		j=0;
		arg[0]='\0';
		break;
	    case '-':
	        oper=OMinus;
		j=0;
		arg[0]='\0';
		break;
	    case '=':
	        oper=OEqual;
		j=0;
		arg[0]='\0';
		break;
	    default:
	    	cout << "syntax error; ignoring" << endl;
		break;
	  }
	  else switch(line[i])
	  {
	    case '\n':
	    case ':':
	        set(sound,attr,oper,arg);
		attr=ASoundNone;
		oper=ONone;
		break;
	    default:
	        arg[j]=line[i];
		j++;
		arg[j]='\0';
		// TODO: buffer overflow fix
		break;  
	  }
	  i++;
	}
}

void config(FMMixer *mixer, char *line)
// extract mixer config commands from line
{
#ifdef debug_mode
	cout << "configuring mixer with " << line << flush;
#endif // debug_mode
	int i=0;
	int j=0;
	char arg[256];
	FMMixerAttribute attr=MANone;
	Operator oper=ONone;
	while(i<strlen(line))
	{
	  // if no operator yet
	  if(oper==ONone)  switch(line[i])
	  {
	    case 't':
	    	attr=MATime;
		break;
	    case 'v':
		attr=MAVolume;
		break;
	    case '+':
	    	oper=OPlus;
		j=0;
		arg[0]='\0';
		break;
	    case '-':
	        oper=OMinus;
		j=0;
		arg[0]='\0';
		break;
	    case '=':
	        oper=OEqual;
		j=0;
		arg[0]='\0';
		break;
	    default:
	    	cout << "syntax error; ignoring" << endl;
		break;
	  }
	  else switch(line[i])
	  {
	    case '\n':
	    case ':':
	        set(mixer,attr,oper,arg);
		attr=MANone;
		oper=ONone;
		break;
	    default:
	        arg[j]=line[i];
		j++;
		arg[j]='\0';
		// TODO: buffer overflow fix
		break;  
	  }
	  i++;
	}
}

void playfms(void *ptr)
{
	// argument for threads is a void * -> have to convert!
	FMPlayer *Player = (FMPlayer *) ptr;
	while(reading)
	// global variable to check wheather still reading
	{
	  bool have_played=0;
	  if(playing){
	    Player->syncPlayInit();  
	    have_played=1;
	  }
	  while(playing)
	  {
	    Player->syncPlayValue();
	  }
	  if(have_played)
	    Player->syncPlayCleanup();
	  
	  sleep(1); // avoid processor cycles; Linux only
	}
	pthread_exit(0);
}

void readuds(void *ptr)
{
    int sd = *(int *) ptr;
    char line[256];
    char buf[1];
    int i,j;
    int soundnr=1;
    bool protocol_comply=0; // did we read the right protocol version line?
    
    do{
	buf[0]='\0';
	line[0]='\0';
	i=0;
	while(buf[0]!='\n')
	{
		if(read(sd,buf,1)<1)
		{
			cout << "Error reading from socket. Exiting..." << endl;
			shutdown(sd, 2);
			pthread_exit(0);
		}
		
		line[i]=buf[0];
		line[i+1]='\0';
		i++;
		if(i>255)
		{
			cout << "Buffer overflow. Exiting..." << endl;
			shutdown(sd, 2);
			pthread_exit(0); 
		}
	}
#ifdef debug_mode
	cout << line << " was read" << endl;
#endif // debug_mode
	
	// process line
	if(!strcmp(line,"protocol fms-0.9\n"))
	{	
		protocol_comply=1;
		continue; // hope this works
	}
	if(!protocol_comply)
		cout << "warning: protocols don't comply" << endl;

	if(!strcmp(line,"play\n"))
	{
		playing=1;
		continue;
	}
	
	if(!strcmp(line,"stop\n"))
	{
		playing=0;
		continue;
	}
	
	if(line[0]=='s' && line[1]==':') // FMSound option
	{
		
		soundnr=atoi(line+4); // might even be negative, 0 on error, uh, oh
		
		FMChannel *channel=Player->firstChannel; // at the moment only one channel
		FMMixer *mixer=channel->firstMixer; // and only one mixer supported
		FMSound *sound=mixer->firstSound;
		
		while(sound->soundnr!=soundnr && sound->next)
			sound=sound->next;
		
		if(sound->soundnr!=soundnr)
		{
			mixer->nextSound();
			sound=sound->next;
			sound->soundnr=soundnr;
		}
		
		if(line[2]=='d') // delete
		{
			sound->deleteMe();
			continue;
		}
		
		// ok, so let's configure sound
		j=4;
		while(line[j]!=':' && j<strlen(line))
			j++;
		config(sound,line+j+1);
		continue;
	}
	else if(line[0]=='m' && line[1]==':') // FMMixer option
	{
		// we'll just take the first mixer, I hope you don't mind
		config(Player->firstChannel->firstMixer,line+2);
	}
	
    } while (strcmp(line,"quit\n")); // be careful with the \n!
    
    	reading = 0;
	// tell other thread we're not reading any more
	shutdown(sd, 2);
	pthread_exit(0);
}

int main(int argc, char *argv[])
{
	FMPlayer p;
	Player=&p;

	/* directory scheme
	char udsfile[128];
	int uid = getuid();
#ifdef debug_mode
	cout << "uid: " << uid;
#endif // debug_mode
	char uid_string[8];
	sprintf(uid_string,"%d",uid);
	strcpy(udsfile,"/tmp/frocor-");
	strcat(udsfile,uid_string);

	mkdir(udsfile, 0777);
	
	strcat(udsfile,"/fms-uds.0"); */
	
	char *filename;
	if(argc==2) filename=argv[1];
	else filename="/tmp/fms-uds";
#ifdef debug_mode
	cout << "uds filename: " << filename << endl;
#endif // debug_mode
	
	// a socket descriptor; uds; streaming; protocol 0
	int sd, len;
	sd=socket(AF_UNIX,SOCK_STREAM,0);
	int *p_sd = &sd;
	sockaddr_un addr;
	addr.sun_family=AF_UNIX;
	strcpy(addr.sun_path, filename);
	len=strlen(addr.sun_path)+sizeof(addr.sun_family); 
	// taken from ../testudsc/udsc.cpp

	connect(sd,(struct sockaddr *)&addr,len);
#ifdef debug_mode
	cout << "UDS connection is established" << endl;
#endif // debug_mode


	// we are now in reading state
	
	reading = 1;
	playing = 0;    
	pthread_t fms_player, uds_reader;
	
	pthread_create( &fms_player, 0, (void *(*)(void *))playfms, (void *) Player);
	pthread_create( &uds_reader, 0, (void *(*)(void *))readuds, (void *) p_sd);
	// thread, options (stack size?), function to call, argument to pass
	// awkward conversion from http://dis.cs.umass.edu/~wagner/threads_html/problems.html
	
	//struct timespec delay;
        //delay.tv_sec = 20;
        //delay.tv_nsec = 0;
        //pthread_delay_np( &delay );
	// np stands for "not portable"
	// this might work on other unixes
	// do not use sleep() there, because it stops all threads (the whole process)
	
	// on linux, this is done differently
	// sleep() here only affects the current thread
	// pthread_delay_np does not exist
	
	while(reading)
		sleep(2); // could do fancy displaying stuff kinda things
	
	return 0;
}
