/**************************************************************************
                   fmwav.cpp  -  writing into .wav-files
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "include/fmwav.h"
#include "include/version.h"

#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>

#include <iostream>
#include <cmath>

using namespace std;

int wavfd;

bool writeWavHeader(char * filename, int datalength, int rate, int chan, int bytes){

	if(chan > 1 || chan < 0){
		return 0;
	}

	if(bytes > 2 || bytes < 1){
		return 0;
	}

	if(rate > 4194303 || rate < 1){
		return 0;
	}

	wavfd = open(filename, O_WRONLY | O_CREAT, 0644);

	if(wavfd<=0){
		return 0;
	}

	unsigned char buff[44];

	buff[0]  = 'R';
	buff[1]  = 'I';
	buff[2]  = 'F';
	buff[3]  = 'F';
	buff[4]  = (datalength + 36) % 256;
	buff[5]  = (((datalength + 36) % 65536) - ((datalength + 36) % 256)) / 256;
	buff[6]  = (((datalength + 36) % 16711680) - ((datalength + 36) % 65536)) / 65536;
	buff[7]  = ((datalength + 36) - ((datalength + 36) % 16711680)) / 16711680;
	buff[8]  = 'W';
	buff[9]  = 'A';
	buff[10] = 'V';
	buff[11] = 'E';
	buff[12] = 'f';
	buff[13] = 'm';
	buff[14] = 't';
	buff[15] = ' ';
	buff[16] = 0x10;
	buff[17] = 0x00;
	buff[18] = 0x00;
	buff[19] = 0x00;
	buff[20] = 0x01;
	buff[21] = 0x00;
	buff[22] = chan + 1;
	buff[23] = 0x00;
	buff[24] = rate % 256;
	buff[25] = ((rate % 65536) - (rate % 256)) / 256;
	buff[26] = (rate - (rate % 65536)) / 65536;
	buff[27] = 0x00; // no sampling rates > 16777215, please
	buff[28] = buff[24]; // bytes per second = sampling rate (if bytes = 1 and channels = 1)
	buff[29] = buff[25];
	buff[30] = buff[26];
	buff[31] = buff[27];
	buff[32] = bytes * (chan + 1);
	buff[33] = 0x00;
	buff[34] = bytes * 8;
	buff[35] = 0x00;
	buff[36] = 'd';
	buff[37] = 'a';
	buff[38] = 't';
	buff[39] = 'a';
	buff[40] = datalength % 256;
	if(debug_level>1)
		cout << "set 1st digit of data length to " << datalength << " % 256 = " << int(buff[40]) << endl;
	buff[41] = ((datalength % 65536) - (datalength % 256)) / 256;
	if(debug_level>1)
		cout << "set 2nd digit of data length to " << int(buff[41]) << endl;
	buff[42] = ((datalength % 16711680) - (datalength % 65536)) / 65536;
	if(debug_level>1)
		cout << "set 3rd digit of data length to " << int(buff[42]) << endl;
	buff[43] = (datalength - (datalength % 16711680)) / 16711680;
	if(debug_level>1)
		cout << "set 4th digit of data length to " << int(buff[43]) << endl;

	write(wavfd, buff, 44);

	return 1;
}

bool writeWavByte(char * byte, int bytes){
	byte[0]-=128;
	if(bytes==2)
		byte[1]-=128;
	if(wavfd > 0 && write(wavfd, byte, bytes) == bytes)
		return 1;
	return 0;
}

wavFile readWav(char * filename){
	int fd = open(filename, O_RDONLY);
	if(debug_level>1)
		cout << "opened wav file " << filename << ", fd=" << fd << endl;
	wavFile t;
	char * data;
	int dbuffer=0;
	unsigned char * header = new unsigned char[46];
	read(fd, header, 45);
	if(header[40]=='t' && header[41]=='a'){
		dbuffer=2;
		if(debug_level)
			cout << "need dbuffer of 2" << endl;
	}
	t.length = header[40+dbuffer]+header[41+dbuffer]*256+header[42+dbuffer]*65536;//+header[43]*16711680;
	t.data   = 0;
	if(debug_level)
		cout << "reading " << t.length << " bytes of wav data" << endl;
	if(t.length > 10000000)
		return t;
	if(header[34] != 8 && header[34] != 16){
		if(debug_level)
			cout << "bitrate to big: " << int(header[34]) << endl;
		return t;
	}
	data = new char[header[42]+header[43]*256+header[44]*65536+header[45]*16711680];
	read(fd, data, header[42]+header[43]*256+header[44]*65536+header[45]*16711680);
	t.data = new float[t.length / (int(header[34])/8)];
	charToFloat(int(header[34])/8, t.length, data, t.data);
	t.length /= int(header[34])/8;
	return t;
}


void charToFloat(int byterate, int n, char *c, float *f){
	// convert it to float
	for(int i=0; i<n; i++){
		if(byterate == 1)
			f[i] = c[i];
		else if(byterate == 2){
			f[i/2] = c[i]*256+c[i+1];
			i++;
		}
		else{
			if(debug_level)
				cout << "wrong byterate" << endl;
			return;
		}
	}
	// find highest and lowest
	float highest = -10000000.0;
	float lowest  = 10000000.0;
	for(int i=0; i<n/byterate; i++){
		if(f[i] < lowest)
			lowest = f[i];
		if(f[i] > highest)
			highest = f[i];
	}
	if(debug_level>1)
		cout << "highest: " << highest << " lowest: " << lowest << endl;
	// normalize char (|lowest| == highest)
	float diff = (fabs(lowest) - fabs(highest)) / 2.0;
	for(int i=0; i<n/byterate; i++)
		f[i]  += diff;
	lowest  += diff;
	highest += diff;
	if(debug_level>1)
		cout << "normalizing...\nhighest: " << highest << " lowest: " << lowest << endl;
	// put it into floats (lowest == 0, highest == 255)
	for(int i=0; i<n/byterate; i++){
		f[i] = (f[i] - lowest) * 255.0/(highest-lowest);
		//cout << f[i] << endl;
	}
}


void cleanupWav() {close(wavfd);}

