/**************************************************************************
           fmofstream.cpp  -  defining fms-file writing utilities
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef _FMOFSTREAM_
#define _FMOFSTREAM_

#include "vtl.h"

int mode(char buff, int file);
/* writes and returns the mode of saving the values */

int mode(int m, int file);
/* writes and returns the mode of saving the values */

bool name(char *pointer, int size, int file);
/* writes the specified name */

bool values(int valuecount, int bytecount, int file, unsigned char * v);
/* writes values in mode 0 */

bool values(int valuecount, int bytecount, int file, VTLP * v);
/* writes values in mode 1 */

bool values(int tonecount, int file, PBSP * v);
/* writes tones in mode 2 */

bool values(int otcount, int bytecount, int file, FAP * v, bool usephase=1);
/* writes values in mode 3 */

bool cleanup(int file);
/* closes the file */

int fmopen(char *file, bool override=1);
/* returns the file descriptor */

#endif

