/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*----------------------------------------------------------------*/

#include <cstring>

int FMFile::lfd_nr = 1;

void FMFile::fakeOpen()
{ open_lock=1; }


FMFile::FMFile(FMMixer *parentMixer){
	if(debug_level>1)
		cout << "FMFile::FMFile called" << endl;
	mixer  = parentMixer;
	filename = new char[strlen(DATADIR "/sounds/sin")];
	strcpy(filename,DATADIR "/sounds/sin");
	freq     = 1;
	hvol    = 0;
	ffreq   = 0;
	mlm     = 0;
	rnf     = 0;
	sweep   = 0;
	sweepfrequency = 0.0;
	sweepvolume = 0.5;
	atime    = 0.0;
	open_lock = 0;
	anti     = 0;
	volume   = 1.0;
	m    = Sound;
	mlen = 10.0;
	till = 0;
	nval = 0.0;
	nr = lfd_nr;
	lfd_nr++;
	if(debug_level>1)
		cout << "FMFile::FMFile finished, FMFile No." << nr << " has been created" << endl;
}

FMFile::~FMFile(){
	if(debug_level>1)
		cout << "FMFile::~FMFile called" << endl;
	cleanup();
	if(filename)
		delete []filename;
	filename = 0;
	if(hvol)
		delete hvol;
	if(ffreq)
		delete ffreq;
	if(mlm)
		delete mlm;
	if(rnf)
		delete rnf;
	if(sweep)
	    delete sweep;
	if(debug_level>1)
		cout << "FMFile::~FMFile finished" << endl;
}

bool FMFile::openLock(){
	if(debug_level>1)
		cout << "FMFile::openLock called (" << open_lock << ")" << endl;
	if(ffreq && !ffreq->openLock())
		return 0;
	if(hvol && !hvol->openLock())
		return 0;
	if(mlm && !mlm->openLock())
		return 0;
	if(rnf && !rnf->openLock())
		return 0;
	if(sweep && !sweep->openLock())
	    return 0;
	return open_lock;
}

bool FMFile::compLock(){
	if(debug_level>1)
		cout << "FMFile::compLock called" << endl;
	if(ffreq && !ffreq->compLock())
		return 0;
	if(hvol && !hvol->compLock())
		return 0;
	if(mlm && !mlm->compLock())
		return 0;
	if(rnf && !rnf->compLock())
		return 0;
	if(sweep && !sweep->compLock())
	    return 0;
	return 1;
}

void FMFile::compute(){
	if(debug_level>1)
		cout << "FMFile::compute called" << endl;
	if(hvol)
		hvol->compute();
	if(ffreq)
		ffreq->compute();
	if(mlm)
		mlm->compute();
	if(rnf)
		rnf->compute();
	if(sweep)
	    sweep->compute();
}

char * FMFile::getFilename() const {
	if(debug_level>1)
		cout << "FMFile::getFilename called: " << filename << endl;
	return filename;
}

void   FMFile::setFilename(char * dfilename) {
	if(debug_level>1)
		cout << "FMFile::setFilename called, filename=" << dfilename << endl;
	char rdfilename[strlen(filename)+strlen(DATADIR)+strlen("sounds/")];
	strcpy(rdfilename, DATADIR);
	strcat(rdfilename, "sounds/");
	strcat(rdfilename, dfilename);
	
	int tfd=open(dfilename,O_RDONLY); // only works if filename exists
	if(tfd==-1)
	{
#ifdef debug_mode
		cout << "trying relative path..." << endl;
#endif
		dfilename=rdfilename; // we try the absolute version
		tfd=open(dfilename, O_RDONLY);
		if(tfd==-1)
		{
#ifdef debug_mode
			cout << "filename wrong, exiting setFilename" << endl;
#endif
			return;
		}
		else
			close(tfd);
	}
	else
		close(tfd);

	if(filename)
		delete []filename;
	
	filename = new char[strlen(dfilename)+1];
	strcpy(filename,dfilename);
	filename[strlen(dfilename)] = '\0';
	open_lock = 0;
	if(sweep)
		sweep->setFilename(dfilename);
	if(debug_level>1)
		cout << "FMFile::setFilename finished, filename=" << filename << endl;
}

/*void   FMFile::setFilename(const char * dfilename) {
	cout << "const cast required" << endl;
	string fn = dfilename;
	setFilename(fn.c_str());
}*/


float  FMFile::getFreq() const {
	if(debug_level>1)
		cout << "FMFile::getFreq called" << endl;
	return freq;
}

void   FMFile::setFreq(float dfreq, bool complock) {
	freq = dfreq;
	if(sweep)
		sweep->setFreq(freq+sweepfrequency,complock);
	if(!ffreq && complock)
		mixer->compLockAll();
	// uh, oh, that might not work
	// should we set ffreq->max, too?
}

void  FMFile::setVolume(float dvolume, bool setptvol){
	if(debug_level>1)
		cout << "FMFile::setVolume called" << endl;
	if(setptvol){
		if(debug_level>1)
			cout << "changing total volume (" << volume << ", " << dvolume << ")" << endl;
		mixer->volumeChanged(volume, dvolume);
	}
	volume=dvolume;
	mixer->compLockAll();
}

float FMFile::getVolume() const {
	if(debug_level>1)
		cout << "FMFile::getVolume called" << endl;
	return volume;
}

void  FMFile::setFilemode(FileMode dm){
	if(debug_level>1)
		cout << "FMFile::setFilemode called" << endl;
	m = dm;
}

FileMode FMFile::getFilemode() const {
	if(debug_level>1)
		cout << "FMFile::getFilemode called" << endl;
	return m;
}

void  FMFile::setMLen(float dmlen){
	if(debug_level>1)
		cout << "FMFile::setMLen called" << endl;
	mlen = dmlen;
}

float FMFile::getMLen() const {
	return mlen;
}

void  FMFile::setAnti(bool danti){
	if(debug_level>1)
		cout << "FMFile::setAnti(" << danti << ") called" << endl;
	anti = danti;
}

bool  FMFile::getAnti() const {
	if(debug_level>1)
		cout << "FMFile::getAnti called" << endl;
	return anti;
}

void   FMFile::setFFreq(){
	if(debug_level>1)
		cout << "FMFile::setFFreq called" << endl;
	if(!ffreq){
		ffreq = new FMModulator(mixer,Frequency,0.0,freq);
	}
}

void   FMFile::unsetFFreq(){
	if(debug_level>1)
		cout << "FMFile::unsetFFreq called" << endl;
	if(ffreq){
		delete ffreq;
		ffreq=0;
		mixer->compLockAll();
	}
}

void   FMFile::setHVol(){
	if(debug_level>1)
		cout << "FMFile::setHVol called" << endl;
	if(!hvol)
		hvol = new FMModulator(mixer,Volume,0.0,1.0);
}

void   FMFile::unsetHVol(){
	if(debug_level>1)
		cout << "FMFile::unsetHVol called" << endl;
	if(hvol){
		delete hvol;
		hvol=0;
		mixer->compLockAll();
	}
}

void   FMFile::setMLM(){
	if(debug_level>1)
		cout << "FMFile::setMLM called" << endl;
	if(!mlm)
		mlm = new FMModulator(mixer,MLen,0.0,mlen);
}

void   FMFile::unsetMLM(){
	if(debug_level>1)
		cout << "FMFile::unsetMLM called" << endl;
	if(mlm){
		delete mlm;
		mlm=0;
		mixer->compLockAll();
	}
}

void   FMFile::setRNF(){
	if(debug_level>1)
		cout << "FMFile::setRNF called" << endl;
	if(!rnf)
		rnf = new FMFile(mixer);
}

void   FMFile::unsetRNF(){
	if(debug_level>1)
		cout << "FMFile::unsetRNF called" << endl;
	if(rnf){
		delete rnf;
		rnf=0;
		mixer->compLockAll();
	}
}

void   FMFile::setSweep(float dsweepfrequency)
{
	if(debug_level>1)
		cout << "FMFile::setSweep called, sweep frequency " << dsweepfrequency << endl; 
	sweepfrequency=dsweepfrequency;
	/*if(sweepfrequency==0){
		unsetSweep();
		return;
	}*/
	if(!sweep){
		sweep = new FMFile(mixer); // do we maybe need a fake parent mixer?
		sweep->setCopyFrom(this);
	}
	
	sweep->setFreq(freq+sweepfrequency);
	mixer->compLockAll();
}

void   FMFile::setSweepVolume(float dsweepvolume)
{
	if(debug_level>1)
		cout << "FMFile::setSweepVolume called, sweep volume " << dsweepvolume << endl;
	if(dsweepvolume>1)
		cout << "warning: sweep volume > 1" << endl;
	sweepvolume=dsweepvolume;
	mixer->compLockAll();
}

void   FMFile::unsetSweep()
{
	if(sweep)
		delete sweep;
	sweep=0;
	mixer->compLockAll();
}

void   FMFile::setAtime(double datime) {
	if(debug_level>1)
		cout << "FMFile::setAtime called, atime=" << datime << endl;
	atime = datime; /*should there be a comp_lock=0 here?*/
}

void   FMFile::incAtime() {
  if(mode==0)
    atime = fmod((atime + getVlen() * freq / mixer->channel->player->getRate()), getVlen());
  if(mode==1){
	  atime = fmod((atime + vtl[getVlen()-1].getTime() * freq / mixer->channel->player->getRate()),
		vtl[getVlen()-1].getTime());
#ifdef valuecore_debug
	cout << "atime=" << atime << ", datime=" << vtl[getVlen()-1].getTime() * freq / mixer->channel->player->getRate() << ", maxtime=" << vtl[getVlen()-1].getTime() << ", rate=" << mixer->channel->player->getRate() << ", freq=" << freq << endl; 
#endif
		}
	if(mode==3)
		atime = fmod((atime+2.0*PI*freq/double(mixer->channel->player->getRate())),2.0*PI);
}

void   FMFile::setIniTInd(double dtind) {
	cout << "Sorry, there ain't no implementation for FMFile::setInitTInd" << endl;
	dtind=0; // so we don't have to feel ashamed
}

double  FMFile::getIniTInd() {
	cout << "Sorry, there ain't no implementation for FMFile::getInitTInd" << endl;
	return 0;
}


double  FMFile::getMaxTInd() {
 if(mode==0)
   return getVlen();
 if(mode==1)
   return vtl[getVlen()-1].getTime();
 if(mode==2)
   return 2.0*PI;
 if(debug_level)
 	cout << "getMaxTInd: wrong mode!" << endl;
 return 0;
}


void   FMFile::openFile() {
  if(debug_level)
	 cout << "FMFile::openFile called, filename: " << filename << endl;
	try{
		if(filename && !open_lock)
			init(filename);
		else if(!filename){
			cout << "FIF_NFNM_ERR" << endl;
			throw FIF_NFNM_ERR;
		}
		if(hvol)
			hvol->openFile();
		if(ffreq)
			ffreq->openFile();
		if(mlm)
			mlm->openFile();
		if(rnf)
			rnf->openFile();
		if(sweep)
			sweep->openFile();
		open_lock=1;
	}
	catch(...){
		throw;
		open_lock=0;
	}
}

void   FMFile::closeFile() {
	if(debug_level>1)
		cout << "FMFile::closeFile called" << endl;
	if(filename)
		cleanup();
	open_lock=0;
}

float  FMFile::value(bool count_on)
// with all implemented functions:
// mlen modulation
// noise mode
// noiserand mode
// randnoise mode
// rand mode
// volume modulation
// frequency modulation
// sweep
{
	float avalue = 0.0;

	if(mlm){
		mlen = mlm->HFValue(count_on);
		//cout << mlen << endl;
	}

	if(m == Sound){
		avalue = fmval(this, atime);
		if(sweep){
			avalue = (1.0-sweepvolume)*avalue + sweepvolume*sweep->value(count_on);
		}

		if(count_on){
			if(ffreq)
				setFreq(ffreq->HFValue(),0);
			incAtime();
		}
		
	}

	if(m == Noise){
		if(till<=0){
			till = int(fmrand(this, mlen))+1;
			nval = float(rand() % 255999) / 1000.0;
		}
		avalue = nval;
		if(count_on)
			till--;
	}

	if(m == NoiseRand){
		if(till<=0){
			till = int(fmrand(this, mlen))+1;
			nval = fmrand(rnf ? rnf : this, 128.0);
		}
		avalue = nval;
		if(count_on)
			till--;
	}

	if(m == RandNoise){
		if(till<=0){
			till = int(fmrand(rnf ? rnf : this, rnf ? rnf->getMLen() : mlen))+1;
			nval = fmrand(this, 128.0);
		}
		avalue = nval;
		if(count_on)
			till--;
	}

	if(m == Rand){
		avalue = fmrand(this, 128.0);
	}

	if(hvol){
			avalue = hvol->HVolVal(avalue);
	}

	return anti ? (avalue * -1.0) + 255.0 : avalue;
}

int FMFile::rval(){ // how many values until we repeat ourselves
 if(debug_level>1)
 	cout << "FMFile::rval called" << endl;
 int drval = 1;
 if(m == Sound){
	if(ffreq){
		freq = 0.5*(ffreq->getMax()+ffreq->getMin());
		drval = int(kgv(drval,ffreq->rval()));
		if(freq < ffreq->getFreq()*mixer->channel->player->getFFFuzzyness())
			drval = int(kgv(drval, mixer->channel->player->getRate() / freq));
	}
	else
		drval = int(kgv(drval,mixer->channel->player->getRate() / freq));

	if(hvol)
		drval = int(kgv(drval, hvol->rval()));
	if(mlm)
		drval = int(kgv(drval, mlm->rval()));
	if(rnf)
		drval = int(kgv(drval, rnf->rval()));
	if(sweep)
	    drval = int(kgv(drval, sweep->rval()));
	if(drval < 0.0 || drval > mixer->channel->player->getRate() * mixer->getTime())
		drval = int(mixer->channel->player->getRate() * mixer->getTime());
 }
 else
    drval = int(mixer->channel->player->getRate() * mixer->getTime());

 return drval;
}

void FMFile::setCopyFrom(FMFile *f) {
 if(debug_level>1)
 	cout << "FMFile::setCopyFrom called" << endl;

	setFilemode(f->getFilemode());
    setFreq(f->getFreq());
    setVolume(f->getVolume());
    setMLen(f->getMLen());
    setFilename(f->getFilename());
    setAnti(f->getAnti());

	if(f->ffreq){
		setFFreq(); ffreq->setCopyFrom(f->ffreq);
	}
	if(f->hvol){
		setHVol(); hvol->setCopyFrom(f->hvol);
	}
	if(f->mlm ){
		setMLM(); mlm->setCopyFrom(f->mlm );
	}
	if(f->rnf ){
		setRNF(); rnf->setCopyFrom(f->rnf);
	}
	
	mixer->compLockAll();
}

/*----------------------------------------------------------------*/

