/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*----------------------------------------------------------------*/

// TODO: re-check bps in case mixer time changes (sync!), not only at initMidi
// TODO: make file-not-found resistant

FMMidi::FMMidi(FMFile *parent) {
#ifdef debug_mode
	if(debug_level>1)
		cout << "FMMidi::FMMidi called" << endl;
#endif // debug_mode
	midifile = parent;
	fakeMixer = new FMMixer(midifile->mixer->channel);

	for(int i=0; i<32; i++){
		//cout << i << endl;
		g[i] = 0; //new FMSound(fakeMixer);
	}
	
	setMidiI(0,DATADIR "/sounds/sin");

	bps = 0;

	rt = -1;
	rv = 0;
#ifdef debug_mode
		cout << "FMMidi::FMMidi finished" << endl;
#endif // debug_mode
}

float FMMidi::MidiValue(bool count_on) {
	if(rv==0){ // we need to switch to another tone
		setBpsAuto(); // for security reasons...
		rt=rt+1;
		rt = rt % midifile->getVlen();
		// avoid to take a tone that doesn't exit - but do we need that?
		// 19.12.2004: yes, indeed we need that!
		
		fakeMixer->setTime(midifile->pbs[rt].beats / bps);
		// time of our new tone
#ifdef debug_mode
		cout << midifile->pbs[rt].beats << " beats, " << bps << " bps, set fake mixer time to "
		     << fakeMixer->getTime() << " s" << endl;
		cout << "midi frequency: " << midifile->pbs[rt].pitch * midifile->getFreq() << endl;
#endif // debug_mode
		g[midifile->pbs[rt].style]->setFreq(midifile->pbs[rt].pitch *
			midifile->getFreq());
		// set frequency, and beware of chords
	if(midifile->pbs[rt].style==31){ // oh my god, it's a chord!
			// we should handle different chords, but for the time being...
	        double q1,q2;
#ifdef debug_mode
		cout << "chord type " << midifile->pbs[rt].chord << endl;
#endif // debug_mode
			switch(midifile->pbs[rt].chord){
				case 1: // Dur (C-e-g)
					q1=5.0/4.0; q2=3.0/2.0;
					break;
				case 2: // Moll (C-es-g)
					q1=6.0/5.0; q2=3.0/2.0;
					break;
				case 3: // sus2 (C-d-g)
					q1=9.0/8.0; q2=3.0/2.0;
					break;
				case 4: // sus4 (C-f-g)
					q1=4.0/3.0; q2=3.0/2.0;
					break;
				case 5: // verminderter
					q1=6.0/5.0; q2=36.0/25.0;
					break;
				case 6: // uebermaessiger
					q1=5.0/4.0; q2=25.0/16.0;
					break;
				default:
					q1=q2=0.0;
#ifdef debug_mode
			cout << "unknown chord" << endl;
#endif // debug_mode
			}

		g[midifile->pbs[rt].style]->next
			->setFreq(midifile->pbs[rt].pitch *
			midifile->getFreq()*q1);
	        g[midifile->pbs[rt].style]->next->next
			->setFreq(midifile->pbs[rt].pitch *
			midifile->getFreq()*q2);
	}

		if(g[midifile->pbs[rt].style]->hvol){
			g[midifile->pbs[rt].style]->hvol->setAtime(0.0);
			g[midifile->pbs[rt].style]->hvol->compute();
		}
	}
	if(count_on)
		rv++;
	if(rv >= fakeMixer->getTime() * fakeMixer->channel->player->getRate())
		rv = 0;
	if(midifile->pbs[rt].style==31){ // chord
		return (g[midifile->pbs[rt].style]->value(count_on) +
		        g[midifile->pbs[rt].style]->next->value(count_on) +
		        g[midifile->pbs[rt].style]->next->next->value(count_on))
				/ 3.0;

	}
	return g[midifile->pbs[rt].style]->value(count_on);
}


void FMMidi::initMidi() {
try{
if(!g[0] || midifile->getMode()!=2){
	throw MID_NDEF_ERR;
}
}
catch(...){
	cout <<  "catch error in FMMidi::initMidi" << endl;
	throw;
	return;
}
g[0]->openFile();
#ifdef debug_mode
	cout << "initializing midifile with " << midifile->getVlen() << " tones" << endl;
#endif // debug_mode

for(int i=0; i<midifile->getVlen(); i++)
   {
	if(g[midifile->pbs[i].style])
	if(g[midifile->pbs[i].style]->getMode() != -1){

#ifdef debug_mode
		cout << "midi " << i << ": file already opened" << endl;
#endif // debug_mode
		continue;
	}
#ifdef debug_mode
		cout << "going to check style... " << midifile->pbs[i].style << endl;
#endif // debug_mode
		if(!g[midifile->pbs[i].style])
			g[midifile->pbs[i].style] = new FMSound(fakeMixer);

		// default since some newer version: has auto-filename (sin) !
		//if(!g[midifile->pbs[i].style]->getFilename()){
		//	cout << "has no filename" << endl;
		//	g[midifile->pbs[i].style]->setFilename(g[0]->getFilename());
		//}

		g[midifile->pbs[i].style]->openFile(); // open it
		if(midifile->pbs[i].style==31){ // in case of a chord
#ifdef debug_mode
			cout << "going to init chord" << endl;
#endif // debug_mode
			if(!g[31]->next)  // yes, we need all that crap!
				g[31]->next = new FMSound(fakeMixer);
			g[31]->next->setFilename(g[31]->getFilename());
#ifdef debug_mode
			cout << "set filename" << endl;
#endif // debug_mode
			g[31]->next->openFile();
			if(!g[31]->next->next)
				g[31]->next->next = new FMSound(fakeMixer);
			g[31]->next->next->setFilename(g[31]->getFilename());
			g[31]->next->next->openFile();
			// should I also initialize the filenames here?
#ifdef debug_mode
			cout << "init chord completed" << endl;
#endif // debug_mode
		}
#ifdef debug_mode
		cout << "midi " << i << ": opened file regularily" << endl;
#endif // debug_mode
   }

setBpsAuto();
#ifdef debug_mode
	cout << "bps: " << bps;
#endif // debug_mode
if(g[0]->hvol){
g[0]->hvol->openFile();
for(int i = 1; i < 33; i++){
	if(g[i] && !g[i]->hvol){
		g[i]->setHVol();
		g[i]->hvol->setFilename(g[0]->hvol->getFilename());
		g[i]->hvol->openFile();
	}
}
}
fakeMixer->setTVol(1.0);
}

void FMMidi::setMidiI(int nr, char * filename){

#ifdef debug_mode
		cout << "FMMidi::setMidiI called, nr=" << nr << 
		", filename=" << filename << endl;
#endif // debug_mode

	if(nr > 31 || nr < 0){

#ifdef debug_mode
			cout << "FMMidi::setMidiI finished: index too high or too low" << endl;
#endif // debug_mode
		
		return;
	}

#ifdef debug_mode
		cout << "checking for existing instrument with index " << nr << endl;
#endif // debug_mode

	if(!g[nr]){

#ifdef debug_mode
			cout << "creating new FMSound for Midi instrument" << endl;
#endif // debug_mode
		
		g[nr] = new FMSound(fakeMixer);
	}

	g[nr]->setFilename(filename);

	if(nr==31){ // chord!
		g[nr]->next = new FMSound(fakeMixer);
		g[nr]->next->setFilename(filename);
		g[nr]->next->next = new FMSound(fakeMixer);
		g[nr]->next->next->setFilename(filename);
	}
	
#ifdef debug_mode
		cout << "FMMidi::setMidiI finished" << endl;
#endif // debug_mode

}


void FMMidi::setMidiH(int nr, char * filename){

#ifdef debug_mode
	if(debug_level>1)
		cout << "FMMidi::setMidiH called" << endl;
#endif // debug_mode

	if(nr > 31 || nr < 0){

#ifdef debug_mode
		if(debug_level)
			cout << "invalid mi nr " << nr << endl;
#endif // debug_mode
		
		return;
	}

	if(!g[nr]){ // damn, why did I ever comment this out
		g[nr] = new FMSound(fakeMixer);
	}

	g[nr]->setHVol();
	g[nr]->hvol->setFilename(filename);
	//g[nr]->hvol->setMax(1);
	//g[nr]->hvol->setMin(0);

#ifdef debug_mode
	if(debug_level>1)
		cout << "FMMidi::setMidiH finished" << endl;
#endif // debug_mode

}

float FMMidi::getMidiHMin(int nr){
	if(nr > 31 || nr < 0 || !g[nr])
		return 0.0;
	if(g[nr]->hvol)
		return g[nr]->hvol->getMin();
	return 0.0;
}

void FMMidi::setMidiHMin(int nr, float dhmin) {
	if(nr > 31 || nr < 0 || dhmin >= 1 || dhmin < 0 || !g[nr]){

#ifdef debug_mode
		if(debug_level)
			cout << "invalid hmin" << endl;
#endif // debug_mode
		
		return;
	}
	if(g[nr]->hvol)
		g[nr]->hvol->setMin(dhmin);
}

float FMMidi::getMidiHMax(int nr){
	if(nr > 31 || nr < 0 || !g[nr])
		return 1.0;
	if(g[nr]->hvol)
		return g[nr]->hvol->getMax();
	return 1.0;
}

void FMMidi::setMidiHMax(int nr, float dhmax) {
	if(nr > 31 || nr < 0 || dhmax <= 0 || dhmax > 1 || !g[nr]){

#ifdef debug_mode
		if(debug_level)
			cout << "invalid hmax" << endl;
#endif // debug_mode
		
		return;
	}
	if(g[nr]->hvol)
		g[nr]->hvol->setMax(dhmax);
}

float FMMidi::getMidiHIter(int nr){
	if(nr > 31 || nr < 0 || !g[nr])
		return 1.0;
	if(g[nr]->hvol)
		return g[nr]->hvol->getIter();
	return 0.0;
}

void FMMidi::setMidiHIter(int nr, float dhiter) {
	if(nr > 31 || nr < 0 || !g[nr])
		return;
	if(g[nr]->hvol)
		g[nr]->hvol->setIter(dhiter);
}

float  FMMidi::getMidiVol(int nr) {
	if(nr > 31 || nr < 0 || !g[nr])
		return 1.0;
	return g[nr]->getVolume();
}

void   FMMidi::setMidiVol(int nr, float dvol) {
	if(nr > 31 || nr < 0 || !g[nr])
		return;
	g[nr]->setVolume(dvol,0);
}

double FMMidi::getBps() {return bps; }

void   FMMidi::setBps(double dbps) {bps = dbps; }

void   FMMidi::setBpsAuto()
{
  double tbeats=0;
  int i;
  for(i = 0; i < midifile->getVlen(); i++)
	tbeats += midifile->pbs[i].beats;
#ifdef debug_mode
  cout << "setBpsAuto: tbeats=" << tbeats << ", time=" << midifile->mixer->getTime() << endl;
#endif
  setBps(tbeats/midifile->mixer->getTime());
}

/*-------------------------------------------------------------------------*/

