/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*----------------------------------------------------------------*/

int FMMixer::lfd_nr = 1;

FMMixer::FMMixer(FMChannel *parentChannel){
	if(debug_level>1)
		cout << "FMMixer::FMMixer called" << endl;
	channel = parentChannel;
	if(channel == channel->player->firstChannel)
		other = channel->player->secondChannel;
	else
		other = channel->player->firstChannel;
	// TODO: wouldn't other = channel->other work?

	self   = this;
	next   = 0;
	hvol   = 0;
	tvol   = 0.0; // have to do this before FMSound::FMSound(this)
	aSound  = new FMSound(this);
	firstSound  = aSound;
	time   = 1.0;
	vol    = 1.0;
	repeat = 1.0;
	rval   = 0;
	nr     = lfd_nr;
	values = 0;
	recursive_delete = 1;
	lfd_nr++;
	comp_lock=0;
}

FMMixer::~FMMixer() {
	if(debug_level>1)
		cout << "FMMixer::~FMMixer " << nr << " called" << endl;
	if(next&&recursive_delete)
		delete next;
	delete firstSound;
	if(hvol)
		delete hvol;
	if(values && self==this)
		delete []values;
	if(debug_level>1)
		cout << "FMMixer::~FMMixer " << nr << " finished" << endl;
}

void FMMixer::deleteMe(){
	if(debug_level>1)
		cout << "FMMixer::deleteMe called" << endl;
       if(this==channel->firstMixer)
               return;
       FMMixer * before = channel->firstMixer;
       while(before->next && before->next != this){
         before = before->next;
       }
       if(!next){
         before->next = 0;
       }
       else{
         before->next = next;
       }
       channel->aMixer = channel->firstMixer;
       while(channel->aMixer->next)
         channel->aMixer = channel->aMixer->next;
       recursive_delete = 0;
       delete this;
}

void FMMixer::nextSound() {
	if(debug_level>1)
		cout << "FMMixer::nextSound called" << endl;
	if(!aSound->next){
		aSound->next = new FMSound(this);
		comp_lock=0;
	}
	aSound = aSound->next;
	channel->syncPointer();
}

void FMMixer::gotoFirstSound() {
	if(debug_level>1)
		cout << "FMMixer::gotoFirstSound called" << endl;
	aSound = firstSound;
}

bool FMMixer::isFirstSound() {
	return (aSound==firstSound);
}

float FMMixer::getTime() const {
	return time;
}

void  FMMixer::setTime(float dtime) {
	if(debug_level>1)
		cout << "FMMixer::setTime called: time=" << dtime << endl;
	time = dtime;
	compLockAll();
	if(debug_level>1)
		cout << "FMMixer::setTime finished" << endl;
}

float FMMixer::getVolume() const {
	if(debug_level>1)
		cout << "FMMixer::getVolume called" << endl;
	return vol;
}

void  FMMixer::setVolume(float dvol) {
	if(debug_level>1)
		cout << "FMMixer::setVolume called" << endl;
	if(dvol>1){
		dvol = 1.0;
		if(debug_level)
			cout << "avoided volume>1" << endl;
	}
	vol = dvol; comp_lock=0;
}

int   FMMixer::getRval() const {
	return rval;
}

float FMMixer::getRepeat() const {
	return repeat;
}

void FMMixer::setTVol(float dtvol) {
	if(debug_level>1)
		cout << "FMMixer::setTVol called" << endl;
	tvol = dtvol;
}

float FMMixer::getTVol() const {
	return tvol;
}

void  FMMixer::setRepeat(float drepeat) {
	if(debug_level>1)
		cout << "FMMixer::setRepeat called" << endl;
	repeat = drepeat;
}

void  FMMixer::setSelf(FMMixer *dself) {
	if(debug_level>1)
		cout << "FMMixer::setSelf called" << endl;
	self = dself; comp_lock=0;
}

void  FMMixer::setSelf(int selfnr) {
	if(debug_level>1)
		cout << "FMMixer::setSelf called" << endl;
	comp_lock=0;
	FMMixer * tmpself;
	tmpself = channel->firstMixer;

	while(tmpself->getNr() < selfnr && tmpself->next)
		tmpself = tmpself->next;
	if(tmpself->getNr() == selfnr)
		self = tmpself;
	else
		cerr << "Unexpected Error 1" << endl;
}

void  FMMixer::setHVol() {
	if(debug_level>1)
		cout << "FMMixer::setHVol called" << endl;
	if(!hvol){
		hvol = new FMModulator(this,Volume,0.0,1.0);
		comp_lock=0;
	}
}

int   FMMixer::getNr() const {
	if(debug_level>1)
		cout << "FMMixer::getNr called" << endl;
	return nr;
}

void  FMMixer::volumeChanged(float oldv, float newv){
	if(debug_level>1)
		cout << "FMMixer::volumeChanged called" << endl << "Volume changed: " << tvol << " - ";
	tvol += newv - oldv;
	if(debug_level>1)
		cout << tvol << endl;
	comp_lock=0;
	if(debug_level>1)
		cout << "FMMixer::volumeChanged finished" << endl;
}

void  FMMixer::openFiles() {
	if(debug_level>1)
		cout << "FMMixer::openFiles called" << endl;
	try{
	if(self==this){
		if(hvol && !hvol->openLock())
			hvol->openFile();
		FMSound * tmpsound = firstSound;
		while(tmpsound){
			if(!tmpsound->openLock()){
				if(debug_level>1)
				cout << "need to open this soundfile" << endl;
				tmpsound->openFile();
			}
			tmpsound = tmpsound->next;
			if(debug_level>1)
				cout << "opening of one file finished" << endl;
		}
		if(debug_level)
			cout << "opening of all files in mixer " << nr << " finished" << endl;
	}
	}
	catch(int i){
		cout <<  "caught error " << i << " in FMMixer::openFiles" << endl;
		throw;
	}
}

void  FMMixer::compute() {
	computeInit();
	computeMalloc();
	computeValues();
}

void  FMMixer::computeInit() {
	if(debug_level>1)
		cout << "FMMixer::computeInit called" << endl;
	if(hvol && !hvol->compLock())
			hvol->compute();
	if(comp_lock){
		FMSound * tmp = firstSound;
		bool ac = 1;
		while(tmp){
			ac = ac * tmp->compLock();
			tmp = tmp->next;
		}
		if(ac){
			if(debug_level)
				cout << "already computed" << endl;
			return;
		}
	}
	
	FMSound *tmpsound = firstSound;
	while(tmpsound){
		tmpsound->compute();
		tmpsound->setAtime(0.0);
		tmpsound = tmpsound->next;
	}
	
	phvol = vol; // if we don't have a phvol file, this will simply stay
}

void FMMixer::computeMalloc(){
	if(debug_level>1)
		cout << "FMMixer::computeMalloc called" << endl;

	if(values && self==this){
		if(debug_level)
			cout << "recomputing mixer" << endl;
		delete []values;
	}

	if(self!=this){
		self->compute();
		values = self->values;
		rval = self->getRval();
		return;
	}

	// first, how many values do we need?
	rval = 1;
	//int numsounds = 0;
	FMSound *tmpsound = firstSound;
	while(tmpsound){
		tmpsound->compute(); // do we need that __AGAIN__ (after FMPlayer::computeInit)
		tmpsound->setAtime(0.0);
		rval = int(kgv(rval, tmpsound->rval()));
		tmpsound = tmpsound->next;
	}

	if(hvol){
		rval = int(kgv(rval, hvol->rval()));
	}

	if(rval > channel->player->getRate() * time || rval < 0)
		rval = int(channel->player->getRate() * time);


	// ok, so we'll make a new value array
	if(debug_level>1)
		cout << rval << " values will be computed in mixer " << nr << endl;
	values = new float[rval];
}

void  FMMixer::computeValues() {
	if(debug_level>1)
		cout << "FMMixer::computeMalloc called" << endl;
	ptr = values;
	if(debug_level>1)
		cout << "values starting @ " << ptr << endl;
	
	while(ptr < values+rval){
		*ptr = value();
		ptr++;
	}
	comp_lock=1;
}

float FMMixer::value(bool count_on)
{
	float v = 0.0;
	phvol = vol;
	if(hvol)
		phvol = hvol->HFValue(count_on);
	FMSound *tmpsound;
	tmpsound = firstSound;
	while(tmpsound){
		v = v + tmpsound->value(count_on) * phvol;
		tmpsound = tmpsound->next;
	}
	return v;
}

void FMMixer::compLockAll(){
	if(debug_level>1)
		cout << "FMMixer::compLockAll called" << endl;
	FMSound * tmp = firstSound;
	while(tmp){
		if(tmp->hvol)
			tmp->hvol->compLockMe();
		if(tmp->ffreq)
			tmp->ffreq->compLockMe();
		if(tmp->mlm)
			tmp->mlm->compLockMe();
		tmp = tmp->next;
	}
	if(hvol)
		hvol->compLockMe();
	comp_lock=0;
	if(debug_level>1)
		cout << "FMMixer::compLockAll finished" << endl;
}

/*----------------------------------------------------------------*/

