/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*----------------------------------------------------------------*/

FMModulator::FMModulator(FMMixer *parentMixer, ModType dtype, float dmin, float dmax) : FMFile(parentMixer){
	if(debug_level>1)
		cout << "FMModulator::FMModulator called" << endl;
	min    = dmin;
	max    = dmax;
	type   = dtype;
	// check wheather min/max fit type
	minh   = 0;
	maxh   = 0;
	iter   = 1.0;
	miniter = maxiter = -1.0;
	comp_lock=0;
	m      = Envelope;
}

FMModulator::~FMModulator(){
	if(debug_level>1)
		cout << "FMModulator::~FMModulator called" << endl;
	if(minh)
		delete minh;
	if(maxh)
		delete maxh;
	if(debug_level>1)
		cout << "FMModulator::~FMModulator finished" << endl;
}

void FMModulator::openFile(){
	FMFile::openFile();
	if(minh)
		minh->openFile();
	if(maxh)
		maxh->openFile();
}

void FMModulator::setFFreq(){
	if(miniter==maxiter==-1.0){
		miniter = 0.0;
		maxiter = iter;
		// again, same problem as with
		// FMFile::setFreq()
	}
	FMFile::setFFreq();
}

void FMModulator::setMode(HFMode dm){
	m = dm;
	comp_lock=0;
	mixer->compLockAll();
}

HFMode FMModulator::getMode() const {
	return m;
}

bool FMModulator::compLock(){
	if(debug_level>1)
		cout << "FMModulator::compLock called" << endl;
	if(!FMFile::compLock())
		return 0;
	return comp_lock;
}

void FMModulator::compLockMe(){
	if(debug_level>1)
		cout << "FMModulator::compLockMe called" << endl;
	comp_lock=0;
	if(ffreq)
		ffreq->compLockMe();
	if(hvol)
		hvol->compLockMe();
	if(mlm)
		mlm->compLockMe();
}

float FMModulator::HFValue(bool count_on){
 float dmin = minh ? minh->HFValue(count_on) : min;
 float dmax = maxh ? maxh->HFValue(count_on) : max;
 if(debug_level>1 && dmax < dmin)
 	cout << "error: FMModulator::max<FMModulator::min" << endl;
 return (dmax-dmin)/255.0 * FMFile::value(count_on) + dmin;
 //cout << dmax << " " << x << " " << dmin << " " << FMFile::value(0) << endl;
 //return x;
}

void  FMModulator::compute(){
	if(debug_level>1)
		cout << "FMModulator::compute called" << endl;
	freq   = iter / mixer->getTime();
	if(debug_level>1) cout << "set HFFFile::freq=iter/time=" << iter << "/" << mixer->getTime() << endl;
	if(freq>100&&debug_level) cout << "WARNING: HIGH FMHFFILE FREQUENCY" << endl;
	if(mode==2) cout << "WARNING: WRONG MODE FOR FMHFFILE" << endl;
	if(ffreq){
		if(debug_level>1)
			cout << "need to set FMModulator::ffreq min and max" << endl;
		ffreq->setMin(miniter / mixer->getTime());
		ffreq->setMax(maxiter / mixer->getTime());
		//ffreq->compute();
	}
	if(max<min){
		if(debug_level)
			cout << "max<min: set min to " << max << endl;
		min = max;
	}
	if(minh){
		if(minh->getMax() > (maxh ? maxh->getMin() : max)){
			if(debug_level)
				cout << "minh->max too high, set to " << (maxh ? maxh->getMin() : max) << endl;
			minh->setMax(maxh ? maxh->getMin() : max);
		}
		minh->compute();
	}
	if(maxh){
		if(maxh->getMin() < (minh ? minh->getMax() : min)){
			if(debug_level)
				cout << "maxh->min too low, set to " << (minh ? minh->getMax() : min) << endl;
			maxh->setMin(minh ? minh->getMax() : min);
		}
		maxh->compute();
	}

	FMFile::compute();
	comp_lock=1;
}

float FMModulator::HVolVal(float aval){
  float x = aval;
	if(m==Envelope)
		x = aval * HFValue();
	if(m==AmpMod)
		x = aval * HFValue(0) + (1.0-HFValue())*128.0;
	if(m==Ring)
		x = ((aval-128.0) * (value()-128.0)/128.0)+128.0;
 return x;
}

float FMModulator::getMin() const {
	if(debug_level>1)
		cout << "FMModulator::getMin called" << endl;
	return min;
}

void  FMModulator::setMin(float dmin){
	if(debug_level>1)
		cout << "FMModulator::setMin called, min=" << min << endl;
	min = dmin;
	comp_lock=0;
}

float FMModulator::getMax() const {
	if(debug_level>1)
		cout << "FMModulator::getMax called" << endl;
	return max;
}

void  FMModulator::setMax(float dmax){
	if(debug_level>1)
		cout << "FMModulator::setMax called, max=" << max << endl;
	max = dmax;
	if(max < min)
		max = min;
	comp_lock=0;
}

float FMModulator::getIter() const {
	if(debug_level>1)
		cout << "FMModulator::getIter called" << endl;
	return iter;
}

void  FMModulator::setIter(float diter) {
	if(debug_level>1)
		cout << "FMModulator::setIter called, iter=" << diter << endl;
	iter = diter;
	comp_lock=0;
}

float FMModulator::getMinIter() const {
	if(debug_level>1)
		cout << "FMModulator::getMinIter called" << endl;
	return miniter;
}

void  FMModulator::setMinIter(float dminiter) {
	if(debug_level>1)
		cout << "FMModulator::setMinIter called, miniter=" << dminiter << endl;
	miniter = dminiter;
	comp_lock=0;
}

float FMModulator::getMaxIter() const {
	if(debug_level>1)
		cout << "FMModulator::getMaxIter called" << endl;
	return maxiter;
}

void  FMModulator::setMaxIter(float dmaxiter) {
	if(debug_level>1)
		cout << "FMModulator::setMaxIter called, maxiter=" << dmaxiter << endl;
	maxiter = dmaxiter;
	comp_lock=0;
}

void   FMModulator::setMinH(){
	if(debug_level>1)
		cout << "FMModulator::setMinH called" << endl;
	if(!minh)
		minh = new FMModulator(mixer,Minimum,min,max/2.0);
}

void   FMModulator::unsetMinH(){
	if(debug_level>1)
		cout << "FMModulator::unsetMinH called" << endl;
	if(minh){
		delete minh;
		minh=0;
		mixer->compLockAll();
	}
}

void   FMModulator::setMaxH(){
	if(debug_level>1)
		cout << "FMModulator::setMaxH called" << endl;
	if(!maxh)
		maxh = new FMModulator(mixer,Maximum,max/2.0,max);
}

void   FMModulator::unsetMaxH(){
	if(debug_level>1)
		cout << "FMModulator::unsetMaxH called" << endl;
	if(maxh){
		delete maxh;
		maxh=0;
		mixer->compLockAll();
	}
}

int  FMModulator::rval(){
	int drval = FMFile::rval();
	if(minh)
		drval = int(kgv(drval,minh->rval()));
	if(maxh)
		drval = int(kgv(drval,maxh->rval()));
	if(drval < 0.0 || drval > mixer->channel->player->getRate() * mixer->getTime())
		drval = int(mixer->channel->player->getRate() * mixer->getTime());
	return drval;
}

void FMModulator::setCopyFrom(FMModulator *f){
	FMFile::setCopyFrom(f);
	min=f->getMin();
	max=f->getMax();
	iter=f->getIter();
	maxiter=f->getMaxIter();
	miniter=f->getMinIter();
	m=f->getMode();
	if(f->maxh){
		setMaxH(); maxh->setCopyFrom(f->maxh);
	}
	if(f->minh){
		setMinH(); minh->setCopyFrom(f->minh);
	}
}

/*----------------------------------------------------------------*/

