/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

int dspfd = 0;

/*----------------------------------------------------------------*/

FMPlayer::FMPlayer() {
	if(debug_level>1)
		cout << "FMPlayer::FMPlayer called" << endl;
	firstChannel   = new FMChannel(this);
	aChannel = firstChannel;
	secondChannel  = 0;
	syncPointer();
	rate    = D_SAMPRATE;
	bytes   = D_BYTES;
	fffuzzyness = 10.0;  //wtf?
	mode    = DSP;
	wavfile = "output.wav";
	srand(time((time_t *)NULL));
	if(debug_level>1)
		cout << "FMPlayer::FMPlayer finished" << endl;
}

FMPlayer::~FMPlayer() {
	if(debug_level>1)
		cout << "FMPlayer::~FMPlayer called" << endl;
	delete firstChannel;
	if(secondChannel)
		delete secondChannel;
	if(debug_level>1)
		cout << "FMPlayer::~FMPlayer finished" << endl;
}

void FMPlayer::switchChannel() {
	if(debug_level>1)
		cout << "FMPlayer::switchChannel called" << endl;
	if(aChannel==secondChannel)
		aChannel = firstChannel;

	if(aChannel==firstChannel && secondChannel)
		aChannel = secondChannel;

	if(aChannel==firstChannel && !secondChannel){
		secondChannel  = new FMChannel(this);
		aChannel = secondChannel;
	}
	
	syncPointer();
}

void FMPlayer::gotoFirstChannel() {
	if(debug_level>1)
		cout << "FMPlayer::firstChannel called" << endl;
	aChannel = firstChannel;
	syncPointer();
}

void FMPlayer::nextMixer(bool create) {
	if(debug_level>1)
		cout << "FMPlayer::nextMixer called" << endl;
	aChannel->nextMixer(create);
	syncPointer();
}

void FMPlayer::gotoFirstMixer() {
	if(debug_level>1)
		cout << "FMPlayer::firstMixer called" << endl;
	aChannel->gotoFirstMixer();
	syncPointer();
}

void FMPlayer::nextSound() {
	if(debug_level>1)
		cout << "FMPlayer::nextSound called" << endl;
	aChannel->nextSound();
	syncPointer();
}

void FMPlayer::gotoFirstSound() {
	if(debug_level>1)
		cout << "FMPlayer::firstSound called" << endl;
	aChannel->gotoFirstSound();
	syncPointer();
}

void FMPlayer::resetPlayer() {
	if(debug_level>1)
		cout << "FMPlayer::resetPlayer called" << endl;
	delete firstChannel;
	if(secondChannel)
		delete secondChannel;
	firstChannel = new FMChannel(this);
	aChannel = firstChannel;
	secondChannel  = 0;
	aMixer = aChannel->aMixer;
	aSound   = aChannel->aSound;
	rate    = D_SAMPRATE;
}

void FMPlayer::setRate(int drate) {
	if(debug_level>1)
		cout << "FMPlayer::setRate called, rate=" << drate << endl;
	rate = drate;
	FMMixer *tmp = firstChannel->firstMixer;
	while(tmp){
		tmp->compLockAll();
		tmp = tmp->next;
	}
	if(secondChannel){
		tmp = secondChannel->firstMixer;
		while(tmp){
			tmp->compLockAll();
			tmp = tmp->next;
		}
	}
}

int  FMPlayer::getRate() const {
	return rate;
}

void FMPlayer::setBytes(int dbytes) {
	if(debug_level>1)
		cout << "FMPlayer::setBytes(" << dbytes << ") called" << endl;
	bytes = dbytes;
}

int FMPlayer::getBytes() const {
	if(debug_level>1)
		cout << "FMPlayer::getBytes called" << endl;
	return bytes;
}

//void FMPlayer::setFFFuzzyness(float df) { // unused functionality!
//	if(debug_level>1)
//		cout << "FMPlayer::setFFFuzzyness(" << df << ") called" << endl;
//	fffuzzyness = df;
//}

float FMPlayer::getFFFuzzyness() const {
	if(debug_level>1)
		cout << "FMPlayer::getFFFuzzyness called" << endl;
	return fffuzzyness;
}

void FMPlayer::setPlayMode(PlayMode dmode) {
	if(debug_level>1)
		cout << "FMPlayer::setPlayMode called" << endl;
	mode = dmode;
}

PlayMode  FMPlayer::getPlayMode() const {
	return mode;
}

void FMPlayer::setWavFile(char * dwavfile) {
	if(debug_level>1)
		cout << "FMPlayer::setWavFile called" << endl;
	wavfile = dwavfile;
	mode = WAV;
}

void FMPlayer::openFiles() {
	if(debug_level>1)
		cout << "FMPlayer::openFiles called" << endl;
 try{
	firstChannel->openFiles();
	if(secondChannel && secondChannel->play())
		secondChannel->openFiles();
 }
 catch(...){
 	cout <<  "caught error in FMPlayer::openFiles" << endl;
  throw;
 }
}

void FMPlayer::compute() {
	if(debug_level>1)
		cout << "FMPlayer::compute called" << endl;
	firstChannel->compute();
	if(secondChannel && secondChannel->play())
		secondChannel->compute();
}

void FMPlayer::syncPointer() {
	if(debug_level>1)
		cout << "FMPlayer::syncPointer called" << endl;
	aMixer = aChannel->aMixer;
	aSound   = aChannel->aSound;
	if(debug_level>1)
		cout << "FMPlayer::syncPointer finished" << endl;
}

void FMPlayer::play() {
 try{
	if(debug_level>1)
		cout << "FMPlayer::play called" << endl;
  openFiles();
  compute();
  playInit();
  while((firstChannel->ptr && firstChannel->play())|| (secondChannel && secondChannel->play() && secondChannel->ptr))
    playValue();
  playCleanup();
 }
 catch(int x){
 	if(x>0) // wenn's eine Fehlermeldung ist
	  throw;
 }
}

void FMPlayer::syncPlayInit(bool open_files) {
  if (open_files)
  	openFiles();
  playInit();
  firstChannel->syncPlayInit();
  if(secondChannel)
  	secondChannel->syncPlayInit();
}

void FMPlayer::syncPlay(bool open_files) {
  syncPlayInit(open_files);
  if(secondChannel && secondChannel->play())
  	while(!(secondChannel->syncFin() && firstChannel->syncFin()))
		syncPlayValue();
  else
  	while(!(firstChannel->syncFin()))
		syncPlayValue();  
  playCleanup(); // means inline void syncPlayCleanup() {playCleanup();}
}

void FMPlayer::syncPlayValue() {
	char buff[2];
	float a=firstChannel->syncValue();
	if(secondChannel && secondChannel->play()){
		float b=secondChannel->syncValue();
		if(bytes==1)
			buff[0] = int(a);
		else{ // assume bytes=2
			buff[0] = int(fmod(a,1)*255.0);
			buff[1] = int(a);
		}
	
		writeSoundByte(buff, mode==WAV,bytes,dspfd);
		
		if(bytes==1)
			buff[0] = int(b);
		else{ // assume bytes=2
			buff[0] = int(fmod(b,1)*255.0);
			buff[1] = int(b);
		}
		
		writeSoundByte(buff, mode==WAV,bytes,dspfd);
	}

	else{
		if(bytes==1)
			buff[0] = int(a);
		else{ // assume bytes=2
			buff[0] = int(fmod(a,1)*255.0);
			buff[1] = int(a);
		}
		writeSoundByte(buff, mode==WAV, bytes, dspfd);
	}
}
  

void FMPlayer::playInit() {
	if(debug_level>1)
		cout << "FMPlayer::playInit called" << endl;

	int format = AFMT_U8;
	if(bytes==2)
		format = AFMT_U16_LE;
	int chan = 0;

 	firstChannel->pointerReset();
	if(secondChannel && secondChannel->play())
		secondChannel->pointerReset();

 try{

	if(mode == DSP && !dspfd){
	
#ifdef debug_mode  
			cout << "going to open and initialize /dev/dsp" << endl;
#endif
		if(secondChannel && secondChannel->play())
			chan = 1;
			
#ifdef debug_mode
			cout << "set chan parameter: " << chan << endl;
#endif

		if((dspfd = open("/dev/dsp", O_WRONLY)) == -1) {
			mode = NONE;
			dspfd = 0;
			throw DSP_OPEN_ERR;
			return;
		}
		
#ifdef debug_mode
			cout << "dspfd=" << dspfd << ", format=" << format << ", rate=" << rate << endl;
#endif

		int drate = rate; // this could be changed by ioctl

		if(ioctl(dspfd, SNDCTL_DSP_STEREO, &chan) == -1) {
			throw DSP_CHAN_ERR;
		}

		if(ioctl(dspfd, SNDCTL_DSP_SETFMT, &format) == -1) {
			throw DSP_SFMT_ERR;
		}

		if(ioctl(dspfd, SNDCTL_DSP_SPEED, &drate) == -1) {
			throw DSP_RATE_ERR;
		}
		
		if(rate!=drate && debug_level)
			cout << "warning: IOCTL changed rate from " << rate << " to " << drate << endl;
	}

	else if(mode == WAV){

		int neededv1 = 0;
		int neededv2 = 0;
		FMMixer * tmpmixer = firstChannel->firstMixer;

		while(tmpmixer){
			neededv1 = neededv1 + int(rate * tmpmixer->getTime()* tmpmixer->getRepeat());
			tmpmixer = tmpmixer->next;
		}

		if(secondChannel && secondChannel->play()){
			tmpmixer = secondChannel->firstMixer;
			while(tmpmixer){
				neededv2 = neededv2 + int(rate * tmpmixer->getTime() * tmpmixer->getRepeat());
				tmpmixer = tmpmixer->next;
			}
			if(neededv2 > neededv1)
				neededv1 = neededv2;

			if(writeWavHeader(wavfile, neededv1 * 2 * bytes, rate, 1, bytes) == 0){
				throw WAV_OPEN_ERR;
				return;
			}
		}

		else{
			if(writeWavHeader(wavfile, neededv1 * bytes, rate, 0, bytes) == 0){
				throw WAV_OPEN_ERR;
				return;
			}
		}

	}

	else if(mode==NONE)
		return;

	else{
		if(debug_level)
			cout << "PlayMode " << mode << " not implemented!" << endl;
		throw PLY_MODE_ERR;
		return;
	}
 }

  catch(...){
  	throw;
  }

	if(debug_level>1)
		cout << "FMPlayer::playInit finished" << endl;
}

void FMPlayer::playValue(){

	char buff[2];

	/*if(bytes!=1 && bytes!=2){
		if(debug_level)
			cout << "bytes=" << bytes << ": not implemented" << endl;
		return;
	}*/

	if(secondChannel && secondChannel->play()){
		if(!firstChannel->ptr){
			buff[0] = 128;
		}
		else{
			if(bytes==1)
				buff[0] = int(*firstChannel->ptr);
			else{ // assume bytes=2
				buff[0] = int(fmod(*firstChannel->ptr,1)*255.0);
				buff[1] = int(*firstChannel->ptr);
			}
			firstChannel->ptrInc();
		}
		writeSoundByte(buff, mode==WAV,bytes,dspfd);

		if(!secondChannel->ptr){
			buff[0] = 128;
		}
		else{
			if(bytes==1)
				buff[0] = int(*secondChannel->ptr);
			else{ // assume bytes=2
				buff[0] = int(fmod(*secondChannel->ptr,1)*255.0);
				buff[1] = int(*secondChannel->ptr);
			}
			secondChannel->ptrInc();
		}
			writeSoundByte(buff, mode==WAV,bytes,dspfd);
	}

  else{
	if(bytes==1)
		buff[0] = int(*firstChannel->ptr);
	else{ // assume bytes=2
		buff[0] = int(fmod(*firstChannel->ptr,1)*255.0);
		buff[1] = int(*firstChannel->ptr);
	}
	writeSoundByte(buff, mode==WAV, bytes, dspfd);
	firstChannel->ptrInc();
  }
}

void FMPlayer::playCleanup() {
	if(debug_level>1)
		cout << "FMPlayer::playCleanup called" << endl;

	if(mode == DSP){
    if(ioctl(dspfd, SNDCTL_DSP_SYNC) == -1) {
			throw DSP_SYNC_ERR;
		}
		close(dspfd); dspfd = 0;
  }
}

/*----------------------------------------------------------------*/

