/**************************************************************************
                    fmplayer.cpp  -  all the FMPlayer-API
                            -------------------
    begin                : September 20th 2002
    copyright            : (C) 2002-2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*----------------------------------------------------------------*/

int FMSound::lfd_nr = 0;

FMSound::FMSound(FMMixer *parentMixer) : FMFile(parentMixer){
	if(debug_level>1)
		cout << "FMSound::FMSound called" << endl;
	midi    = 0;
	next    = 0;
	freq    = 441.0;
	soundnr = lfd_nr;
	lfd_nr++;
	mixer->volumeChanged(0.0, 1.0);
	if(debug_level>1)
		cout << "FMSound::FMSound finished" << endl;
}

FMSound::~FMSound(){
	if(debug_level>1)
		cout << "FMSound::~FMSound called" << endl;
	if(next)
		delete next;
	if(midi)
		delete midi;
	if(debug_level>1)
		cout << "FMSound::~FMSound finished" << endl;
}

void  FMSound::setMidi(){
	if(debug_level>1)
		cout << "FMSound::setMidi called" << endl;
	if(!midi){
		midi = new FMMidi(this);
		mixer->compLockAll();
	}
	if(debug_level>1)
		cout << "FMSound::setMidi finished" << endl;
}

void  FMSound::openFile(){
	if(debug_level>1)
		cout << "FMSound::openFile called" << endl;
	FMFile::openFile();
	if(mode==2) // midi mode
		setMidi();
	else if(midi){
		delete midi;
	}
		
	if(midi){
		midi->initMidi();
	}
}

float FMSound::value(bool count_on){
	//cout << "FMSound::value still standing 1" << endl;
	float x,y;
	switch(getMode()){
		case 0:
		case 1:
		case 3:
	//		cout << "FMSound::value normal file" << endl;
			return FMFile::value(count_on) * (volume/mixer->getTVol());
		case 2:
	//		cout << "FMSound::value midi" << endl;
			if(hvol)
				return hvol->HVolVal(midi->MidiValue(count_on)) * (volume/mixer->getTVol());
	//		cout << "FMSound::value midi still standing 1" << endl;
	//		cout << midi->rt << " " << midi->rv << endl;
			x = midi->MidiValue(count_on);
	//		cout << "FMSound::value midi still standing 2" << endl;
			y = (volume/mixer->getTVol());
	//		cout << "FMSound::value midi still standing 3" << endl;
			return x * y;
		default:
	//		cout << "FMSound::value dunno" << endl;
			return 0.0;
	}
}

int   FMSound::rval(){
	if(getMode()==2)
		return int(mixer->channel->player->getRate() * mixer->getTime());
	
	return FMFile::rval();
}

void  FMSound::deleteMe(){
	if(debug_level>1)
		cout << "FMSound::deleteMe called" << endl;
	
	mixer->volumeChanged(volume,0.0);
		
	if(this==mixer->firstSound)
	{	
	   if(next)
	   {
		mixer->firstSound=next;
		next=0; // important, otherwise recursive destruction
		delete this;
		return;
	   }
	   else
	   {
	     if(debug_level)
	   	cout << "can't delete completely" << endl;
	   	setFreq(0);
		return;
	   }
	}
		
	FMSound *before=mixer->firstSound;
	while(before->next!=this && before->next)
		before=before->next;
	
	before->next = next;
	next=0;
	delete this;
}

/*----------------------------------------------------------------*/

