/**************************************************************************
              xfmdisplay.cpp  -  displaying fms-files with SDL
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include "config.h"

using namespace std;

#ifdef HAVE_LIBSDL_GFX

#include <cstdlib>
#include <cstring>
#include <cstdio>

#include <SDL.h>
#include <SDL_gfxPrimitives.h>

#include "include/fmlanguage_xfmdisplay.h"
#include "include/checkint.h"
#include "include/fmplayer.h"
#include "include/version.h"

int main(int argc, char *argv[]) {

	FMPlayer p;
	text_xfmdisplay t; // strings for user communication
	//FMPlayer q;  // the un-mixed one

	int	i            ;
	int	j         = 0;
	int x         = 300;
	int y         = 300;
	int soundcount = 0;
	
	int r         = 0;
	int g         = 128;
	int b         = 255;

	float y_faktor;

	//bool parseerror = 0;
	bool ani = 0;

	cout <<  t.title << endl;
	
	for(i = 1; i < argc; i++){
		if(argv[i][0] == '-' && argv[i][1] == 'x'){
				x = (atoi(argv[i+1]));
		}

		if(argv[i][0] == '-' && argv[i][1] == 'y'){
				y = (atoi(argv[i+1]));
		}
	}
	
	if(x < 1 || x > 10000) {
		//cout <<  '\a' << flush;
		//cout << t.wrongcoord1 << "x" << t.wrongcoord2;
		//cin >> x;
		x = 300; // checkint(x, 1, 10000);
	}

	if(y < 1 || y > 10000) {
		//cout <<  '\a' << flush;
		//cout << t.wrongcoord1 << "y" << t.wrongcoord2;
		//cin >> y;
		y = 300; //checkint(y, 1, 10000);
	}
	
	p.setPlayMode(NONE);
	p.setRate(x);
	p.aMixer->setTime(1.0);
	//q.setRate(x);
	//q.aMixer->setTime(1.0);
	p.aSound->setFreq(1.0);

	/* parse all the sound command line args */

	for(i = 1; i < argc; i++){

		if(argv[i][0] == '-' && (argv[i][1] == 'x' || argv[i][1] == 'y')){  
				i++;
				continue;
		}

		/*if(argv[i][0] == '-' && argv[i][1] == 'r'){  // frequency (in this case, iteration) option
				p.aSound->setFreq(1.0/float(atof(argv[i+1])));
				q.aSound->setFreq(1.0/float(atof(argv[i+1])));
				i++;
				continue;
		}*/

		if(argv[i][0] == '-' && argv[i][1] == 'r'){  // frequency (in this case, iteration) option
			if(i+1<argc) p.aSound->setFreq(atof(argv[i+1]));
		//	q.aSound->setFreq(atof(argv[i+1]));
			i++;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'F'){ // frequency file option
			switch(argv[i][2]){
			  case '\0':
				p.aSound->setFFreq(); // just to make sure we have ffreq
				if(i+1<argc) p.aSound->ffreq->setFilename(argv[i+1]);
			//	q.aSound->setFFreq();
			//	q.aSound->ffreq->setFilename(argv[i+1]);
				i++;
				continue;

			  case 'r':
				p.aSound->setFFreq(); // just to make sure we have ffreq
				if(i+1<argc) p.aSound->ffreq->setIter(atof(argv[i+1]));
			//	q.aSound->setFFreq();
			//	q.aSound->ffreq->setIter(atof(argv[i+1]));
				i++;
				continue;

			  case 'l':
				p.aSound->setFFreq(); // just to make sure we have ffreq
				if(i+1<argc) p.aSound->ffreq->setMin(atof(argv[i+1]));
			//	q.aSound->setFFreq();
			//	q.aSound->ffreq->setMin(atof(argv[i+1])/100.0);
				i++;
				continue;

			  case 'h':
				p.aSound->setFFreq(); // just to make sure we have ffreq
				if(i+1<argc) p.aSound->ffreq->setMax(atof(argv[i+1]));
			//	q.aSound->setFFreq();
			//	q.aSound->ffreq->setMax(atof(argv[i+1])/100.0);
				i++;
				continue;

			  //default:
				//parseerror = 1;
			}
		}

		if(argv[i][0] == '-' && argv[i][1] == 'h'){ // sound hvol file option
			switch(argv[i][2]){
			  case '\0':
				p.aSound->setHVol(); // just to make sure we have hvol
				if(i+1<argc) p.aSound->hvol->setFilename(argv[i+1]);
			//	q.aSound->setHVol();
			//	q.aSound->hvol->setFilename(argv[i+1]);
				i++;
				continue;

			  case 'r':
				p.aSound->setHVol(); // just to make sure we have hvol
				if(i+1<argc) p.aSound->hvol->setIter(atof(argv[i+1]));
			//	q.aSound->setHVol();
			//	q.aSound->hvol->setIter(atof(argv[i+1]));
				i++;
				continue;

			  case 'l':
				p.aSound->setHVol(); // just to make sure we have hvol
				if(i+1<argc) p.aSound->hvol->setMin(atof(argv[i+1])/100.0);
			//	q.aSound->setHVol();
			//	q.aSound->hvol->setMin(atof(argv[i+1])/100.0);
				i++;
				continue;

			  case 'h':
				p.aSound->setHVol(); // just to make sure we have hvol
				if(i+1<argc) p.aSound->hvol->setMax(atof(argv[i+1])/100.0);
			//	q.aSound->setHVol();
			//	q.aSound->hvol->setMax(atof(argv[i+1])/100.0);
				i++;
				continue;

			  //default:
				//parseerror = 1;
			}
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'v'){ // relative sound volume
			if(i+1<argc) p.aSound->setVolume(atof(argv[i+1]) / 100.0);
		//	q.aSound->setVolume(atof(argv[i+1]) / 100.0);
			i++;
			continue;
		}

		if(argv[i][0] == '-' && argv[i][1] == 'a'){ // animated
			ani = 1;
			continue;
		}

		if(argv[i][0] != '-'){ // it is a sound filename!
			p.aSound->setFilename(argv[i]);
			p.nextSound();
			p.aSound->setFreq(1.0);
			soundcount++;
		//	q.aSound->setFilename(argv[i]);
		//	q.nextMixer();
		//	q.aMixer->setTime(1.0);
		//	q.aSound->setFreq(1.0);
		}
	}

	if(soundcount<1)
	{
		cout << "syntax error\nusage: " << argv[0] << " [general options] [sound options] [sound file] ... [sound options] [sound file]" << endl;
		cout << "\ngeneral options:\n\t-x XDIM -y YDIM: x and y dimensions of output window\n\t-a: animated output" << endl;
		cout << "\nsound options:\n\t-r N: repetitions (equals frequency)\n\t-v VOL: relative sound volume\n\t-h / -hl / -hh / -hr: amplitude modulation options as in fmplay\n\t-F / -Fl / -Fh / -Fr: frequency modulation options as in fmplay" << endl;
		return -1;
	}
	
	p.aSound->deleteMe();
//	q.aMixer->deleteMe();

	/* now initializing all the files */

//	cout << "1" << endl;


	p.syncPlayInit();  // kinda easy, isn't it

//	q.openFiles();
//	cout << "2" << endl;
//	p.compute(); // we don't want it pre-computed any more
//	q.compute();
//	cout << "3" << endl;
	SDL_Init(SDL_INIT_VIDEO);
	SDL_Init(SDL_INIT_TIMER);
	SDL_Surface *screen;
	screen = SDL_SetVideoMode(x, y, 16, SDL_SWSURFACE | SDL_ANYFORMAT);
	SDL_WM_SetCaption("xfmdisplay","xfmdisplay");

	y = y - 2;
	y_faktor = float(y) / 256.0;
	
	if(debug_level)
		cout << "going to paint raster" << endl;

	for(i=0; i<x; i=i+10){
		lineRGBA(screen, i, y, i, 0, 100, 100, 100, 255);
  }

	// Raster

  for(i=0; i<y; i=i+10){
		lineRGBA(screen, x, i, 0, i, 100, 100, 100, 255);
  }

  	lineRGBA(screen, 0, int(y/2), x, int(y/2), 200, 200, 200, 255);
		
	if(debug_level)
		cout << "finished painting raster" << endl;
		
	int before_y[soundcount+1]; // so we can draw lines
	int yshift=int(0.5*y*(1.0-1.0/soundcount)); // shift single sounds
#ifdef debug_mode	
	cout << "yshift: " << yshift << endl;
#endif

	for(j=0; j<x-2; j++){
		// q.gotoFirstMixer(); // can't trust that
 		// q.aChannel->gotoFirstMixer(); //=q.aChannel->firstMixer;
		r = 0;
		g = 128;
		b = 255;
		
		//int tempy1 = y-int(*q.aChannel->ptr * y_faktor);
		//q.aChannel->ptrInc();
		//int tempy2 = y-int(*q.aChannel->ptr * y_faktor);
		//lineRGBA(screen, j, tempy1, j+1, tempy2, r, g, b, 255);
		//r = r + 10;
		//g = g + 20;
		//b = b + 30;

		int k=0;
		p.aMixer->gotoFirstSound();
		do{
			before_y[k] = y-int(p.aMixer->aSound->value(0) * y_faktor); // 0 -> do not count on
			k++;

			p.aMixer->aSound=p.aMixer->aSound->next;
		} while(p.aMixer->aSound && k<soundcount);

		before_y[soundcount] = y-int(p.aMixer->value() * y_faktor); // here we count on
		lineRGBA(screen, j, before_y[soundcount], j+1, 
		         y-int(p.aMixer->value(0) * y_faktor), 0, 255, 0, 255);

		k=0;
		p.aMixer->gotoFirstSound();
		do{
			lineRGBA(screen, j, before_y[k]-yshift, j+1, 
			        y-int(p.aMixer->aSound->value(0) * y_faktor)-yshift, r, g, b, 255);
			r = (r + 50) % 256;
			g = (g + 70) % 256;
			b = (b + 100) % 256;
		    p.aMixer->aSound=p.aMixer->aSound->next;
			k++;
		}while(p.aMixer->aSound && k<soundcount);
				 
		if(ani)
			SDL_UpdateRect(screen, 0, 0, 0, 0);
	}

	SDL_UpdateRect(screen, 0, 0, 0, 0);

	SDL_Event event;

	cout << t.keyquit;

        while (SDL_WaitEvent(&event) >= 0){
            switch (event.type){
	        case SDL_KEYDOWN: {
		    SDL_Quit();
		    return 0;
	        }
            }
        }

	return 0;
}
#endif

#ifndef HAVE_LIBSDL_GFX
int main() {
	cout << "You need to install libSDL and libSDL_gfx and recompile to get this program running... \n I apologize for the inconvenience." << endl;
	return 0;
}
#endif
