/**************************************************************************
         xfmspectrum.cpp  -  displaying fms-fourier-files with SDL
                             -------------------
    begin                : February 16th 2003
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// TODO: make it analyze also files in mode 1/2

#include <iostream>
#include "config.h"

#ifdef HAVE_LIBSDL_GFX

#include <cstdlib>
#include <cstring>
#include <cstdio>

#include <SDL.h>
#include <SDL_gfxPrimitives.h>

#include "include/fmlanguage_xfmdisplay.h"
#include "include/checkint.h"
#include "include/fmifstream.h"
#include "include/version.h"

using namespace std;

int main(int argc, char *argv[]) {

	text_xfmdisplay t; // strings for user communication
	FMData d;
	
	int x         = 300;
	int y         = 300;

	int r         = 0;
	int g         = 0;
	int b         = 255;
	
	bool n = 0;

	char * filename = "";

	cout << "FMS Fourier Analyzer" << endl;

	if(argc<2)
	{
		cout << "syntax: " << argv[0] << " -x [XDIM] -y [YDIM] [filename]" << endl;
		return 0;
	}

	for(int i = 1; i < argc; i++){
		if(argv[i][0] == '-' && argv[i][1] == 'x'){
				x = (atoi(argv[i+1]));
		}

		if(argv[i][0] == '-' && argv[i][1] == 'y'){
				y = (atoi(argv[i+1]));
		}
	}

	if(x < 1 || x > 10000) {
		cout <<  '\a' << flush;
		cout << t.wrongcoord1 << "x" << t.wrongcoord2;
		cin >> x;
		x = checkint(x, 1, 10000);
	}

	if(y < 1 || y > 10000) {
		cout <<  '\a' << flush;
		cout << t.wrongcoord1 << "y" << t.wrongcoord2;
		cin >> y;
		y = checkint(y, 1, 10000);
	}

	/* parse all the sound command line args */

	for(int i = 1; i < argc; i++){

		if(argv[i][0] == '-' && (argv[i][1] == 'x' || argv[i][1] == 'y')){  // frequency (in this case, iteration) option
				i++;
				continue;
		}
		
		if(argv[i][0] == '-' && argv[i][1] == 'n'){ // relative sound volume
			n = 1;
			continue;
		}

		if(argv[i][0] != '-'){ // it is a sound filename!
			filename = argv[i];
		}
	}

	/* now initializing all the files */

 try{
	 d.init(filename);
	}
	catch(...)
	{
		cout << "An error occured" << endl;
		return 0;
	}

	if(d.getMode()!=3){
		cout << "input file has to be in mode 4" << endl;
		return 0;
	}

	SDL_Init(SDL_INIT_VIDEO);
	SDL_Init(SDL_INIT_TIMER);
	SDL_Surface *screen;
	screen = SDL_SetVideoMode(x, y, 16, SDL_SWSURFACE | SDL_ANYFORMAT);
	SDL_WM_SetCaption("xfmspectrum","xfmspectrum");

	//y = y - 2;

	float maxa = 0.0;

	for(int j=0; j<d.getVlen(); j++){
		if(d.fa[j].amp>maxa)
			maxa = d.fa[j].amp;
	}

	maxa = 1.0/maxa;

	for(int j=0; j<d.getVlen(); j++){

		boxRGBA(screen, int(j*x/d.getVlen()), y, int((j+0.7)*x/d.getVlen()), int((1.0-d.fa[j].amp*maxa*0.9)*y), int(255.0*d.fa[j].phase/90.0), 0, int(255.0*(1.0-d.fa[j].phase/90.0)), 255);
		if(n){
			char num[4];
			sprintf(num, "%u", j+1);
			stringRGBA(screen, int((j+0.3)*x/d.getVlen()), y-10, num, 255,255,255,255);
		}
		if(debug_level)
			cout << "overtone " << j+1 << ": " << d.fa[j].amp << " phase: " << d.fa[j].phase << endl;
	}

	SDL_UpdateRect(screen, 0, 0, 0, 0);

	SDL_Event event;

	cout << t.keyquit;

  while (SDL_WaitEvent(&event) >= 0){
   switch (event.type){
	  case SDL_KEYDOWN: {
	   SDL_Quit();
	   return 0;
	  }
  case SDL_MOUSEMOTION: {
		 boxRGBA(screen, x-50, 50, x, 0, 0,0,0,255);
		 char num[14];
		 sprintf(num, "%f", d.fa[int(float(event.motion.x)/x*float(d.getVlen()))].amp*100.0);
		 num[4]='\0';
		 stringRGBA(screen, x-130, 20, "Amplitude:", 255,255,255,255);
		 stringRGBA(screen, x-40, 20, num, 255,255,255,255);
		 sprintf(num, "%u", int(d.fa[int(float(event.motion.x)/x*float(d.getVlen()))].phase));
		 stringRGBA(screen, x-130, 40, "Phase:", 255,255,255,255);
		 stringRGBA(screen, x-40, 40, num, 255,255,255,255);
		 SDL_UpdateRect(screen, x-150, 0, 150, 50);
		 break;
		}
   }
  }

	return 0;
}
#endif

#ifndef HAVE_LIBSDL_GFX
int main() {
	cout << "You need to install libSDL and libSDL_gfx and recompile to get this program running... \n I apologize for the inconvenience." << endl;
	return 0;
}
#endif

