/**************************************************************************
              xtruncwavtest.cpp  -  displaying fms-files with SDL
                             -------------------
    begin                : February 16th 2003
    copyright            : (C) 2003 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include "config.h"

#ifdef HAVE_LIBSDL_GFX

#include <cstdlib>
#include <cstring>
#include <cstdio>

#include <SDL.h>
#include <SDL_gfxPrimitives.h>

#include "include/fmlanguage_xfmdisplay.h"
#include "include/checkint.h"
#include "include/fmfoutools.h"
#include "include/version.h"

using namespace std;

int main(int argc, char *argv[]) {

	text_xfmdisplay t; // strings for user communication

	int x         = 0;
	int y         = 0;

	int r         = 0;
	int g         = 0;
	int b         = 255;

	char * filename = "";

	cout << "FMS Fourier Analyzer" << endl;

	for(int i = 1; i < argc; i++){
		if(argv[i][0] == '-' && argv[i][1] == 'x'){
				x = (atoi(argv[i+1]));
		}

		if(argv[i][0] == '-' && argv[i][1] == 'y'){
				y = (atoi(argv[i+1]));
		}
	}

	if(x < 1 || x > 10000) {
		cout <<  '\a' << flush;
		cout << t.wrongcoord1 << "x" << t.wrongcoord2;
		cin >> x;
		x = checkint(x, 1, 10000);
	}

	if(y < 1 || y > 10000) {
		cout <<  '\a' << flush;
		cout << t.wrongcoord1 << "y" << t.wrongcoord2;
		cin >> y;
		y = checkint(y, 1, 10000);
	}

	/* parse all the sound command line args */

	for(int i = 1; i < argc; i++){

		if(argv[i][0] == '-' && (argv[i][1] == 'x' || argv[i][1] == 'y')){
				i++;
				continue;
		}

		if(argv[i][0] != '-'){ // it's a filename!
			filename = argv[i];
		}
	}

	if(!strcmp("",filename))
	{
		cout << "usage: " << argv[0] << " -x [XDIM] -y [YDIM] wavfilename" << endl;
		return 0;
	}

	/* now initializing all the files */

	wavFile w = readWav(filename);
	wavFile v = truncWav(w);
	

	SDL_Init(SDL_INIT_VIDEO);
	SDL_Init(SDL_INIT_TIMER);
	SDL_Surface *screen;
	screen = SDL_SetVideoMode(x, y, 16, SDL_SWSURFACE | SDL_ANYFORMAT);
	SDL_WM_SetCaption("xtruncwav","xtruncwav");

	for(int i=0; i<x-1; i++){
		lineRGBA(screen, i, y*w.data[int(w.length*i/x)]/256.0, i+1, y*w.data[int(w.length*(i+1.0)/x)]/256.0, 255, 0, 0, 255);
		lineRGBA(screen, i, y*v.data[int(v.length*i/x)]/256.0, i+1, y*v.data[int(v.length*(i+1.0)/x)]/256.0, 255, 255, 255, 255);
		SDL_UpdateRect(screen, 0,0,0,0);
	}

	SDL_Event event;

  while (SDL_WaitEvent(&event) >= 0){
   switch (event.type){
	  case SDL_KEYDOWN: {
	   SDL_Quit();
	   return 0;
	  }
		}
   }

	return 0;
}

#endif

#ifndef HAVE_LIBSDL_GFX
int main() {
	cout << "You need to install libSDL and libSDL_gfx and recompile to get this program running... \n I apologize for the inconvenience." << endl;
	return 0;
}
#endif
