#include "include/colorconv.h"
#include <cmath>

int color16(int r, int g, int b)
{
	int r5=int(float(r)/8.0); // 5 bits 
	int g5=int(float(g)/4.0); // 6 bits
	int b5=int(float(b)/8.0); // 5 bits
	
	// bitwise: rrrrrggggggbbbbb
	// that's weird!
	
	return (b5)+(32*g5)+(32*64*r5); 
}

int color16(double frequency)
{
int r, g, b;

// basic idea:
// f=0 => r=max, g=0, b=0
// f=1/2 max => r=0, g=max, b=0
// f=max => r=0, g=0, b=max
// not as strict as that with of<1

r = int(255.0 * (1.0 - of*frequency/(maxfreq)));
if(r<0) 
	r=0;

g = int(255.0 * (1.0 - of*fabs(frequency-(maxfreq/2.0))/(maxfreq))); 
if(g<0)
	g=0;

b = int(255.0 * (1.0 - of*(maxfreq-frequency)/(maxfreq)));
if(b<0)
	b=0;

return color16(r,g,b);

}

