#include <iostream>
#include <cstring>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

#include <qtextcodec.h>
#include <qtranslator.h>

#include <qapplication.h>
#include <qhbox.h>
#include <qstring.h>
#include "qsoundoptions.h"

// #define debug_mode 1
//
#ifndef DATADIR
#define DATADIR "/usr/local/share/frocor-player"
#endif

using namespace std;

int main(int argc, char *argv[])
{
	//taken from quint.cpp
	char *frocor_uds_file= "/tmp/frocor-uds";
  	unlink(frocor_uds_file);
	int frocor_clsd;
	int frocor_sd = socket(AF_UNIX, SOCK_STREAM, 0);
	socklen_t frocor_cllen;
	struct sockaddr_un frocor_addr,frocor_claddr; // address, client address
	frocor_addr.sun_family=AF_UNIX;
	strcpy(frocor_addr.sun_path, frocor_uds_file);

	if(bind(frocor_sd,(struct sockaddr *)&frocor_addr,strlen(frocor_addr.sun_path) 
				+sizeof(frocor_addr.sun_family))<0)
	{
		cout << "binding uds failed. exiting..." << endl;
		return 0;
	}
	// geh horch
	if(listen(frocor_sd,1))
	{
		cout << "listening failed. exiting..." << endl;
		return 0;
	}
	frocor_cllen=sizeof(frocor_claddr); // sb was smart enough to do bind and accept differently
	frocor_clsd=accept(frocor_sd,(struct sockaddr *)&frocor_claddr, &frocor_cllen);
	if(frocor_clsd<0)
	{
		cout << "accept failed. exiting..." << endl;
		return 0;
	}
#ifdef debug_mode
	cout << "frocor_uds successfully established" << endl;
#endif // debug_mode	
	char *fms_uds_file= "/tmp/fms-uds";   //vorlaeufig
  	char line[256];
	unlink(fms_uds_file);
	int fms_clsd;
	int fms_sd = socket(AF_UNIX, SOCK_STREAM, 0);
	socklen_t fms_cllen;
	struct sockaddr_un fms_addr,fms_claddr; // address, client address
	fms_addr.sun_family=AF_UNIX;
	strcpy(fms_addr.sun_path, fms_uds_file);

	if(bind(fms_sd,(struct sockaddr *)&fms_addr,strlen(fms_addr.sun_path) 
				+sizeof(fms_addr.sun_family))<0)
	{
		cout << "binding uds failed. exiting..." << endl;
		return 0;
	}
	// geh horch
	if(listen(fms_sd,1))
	{
		cout << "listening failed. exiting..." << endl;
		return 0;
	}
	fms_cllen=sizeof(fms_claddr); // sb was smart enough to do bind and accept differently
	fms_clsd=accept(fms_sd,(struct sockaddr *)&fms_claddr, &fms_cllen);
	if(fms_clsd<0)
	{
		cout << "accept failed. exiting..." << endl;
		return 0;
	}

#ifdef debug_mode
	cout << "fms_uds successfully established" << endl;
#endif // debug_mode	

	// ocor init
	
	strcpy(line,"protocol frocor-pre1\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode	
	
	strcpy(line, "n:0:t=c:x0=1:y0=1:r=5:c=400\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode	
	
	strcpy(line, "n:1:t=p:n=3:x0=0:y0=-1:x1=2:y1=2:x2=-2:y2=3:c=400\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode	
	
	strcpy(line, "n:2:t=p:n=4:x0=-1:y0=-1:x1=-1:y1=1:x2=1:y2=1:x3=1:y3=-1:c=400\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode	
	
//	strcpy(line, "n:3:t=p:n=4:x0=-1:y0=-1:x1=1:y1=1:x2=-1:y2=1:x3=1:y3=-1:c=400\n\0");
//      actually, the proper way to do this is using the ocor move transformation.
//      The frocor protocol would have to be extended for that though. -FS
	strcpy(line, "n:3:t=p:n=4:x0=-3:y0=-3:x1=-1:y1=-1:x2=-3:y2=-1:x3=-1:y3=-3:c=400\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode	
	
	// fms init
	
	strcpy(line,"protocol fms-0.9\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"s:n:0:p=sin:f=400\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"s:n:1:p=sin:f=400\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"s:n:2:p=tri:f=400\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"s:n:3:p=tri:f=400\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"s:n:4:p=square:f=400\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"s:n:5:p=square:f=400\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"s:n:6:p=saw:f=400\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"s:n:7:p=saw:f=400\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"play\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	

	// bring up Qt interface
	
	QApplication QApp( argc, argv );

	QTranslator fptranslator(0);
	fptranslator.load (QString("frocorplayer_")+QTextCodec::locale(), DATADIR);
	QApp.installTranslator (&fptranslator);

	QHBox QHBMain;	
	
	QSoundOptions QSOSinus(&QHBMain);
	QSoundOptions QSOTri(&QHBMain);
	QSoundOptions QSOSquare(&QHBMain);
	QSoundOptions QSOSaw(&QHBMain);
	
	// sd and number
	QSOSinus.setSocket (frocor_clsd, fms_clsd, 0);
	QSOTri.setSocket   (frocor_clsd, fms_clsd, 2);
	QSOSquare.setSocket(frocor_clsd, fms_clsd, 4);
	QSOSaw.setSocket(frocor_clsd, fms_clsd, 6);
	
	// img
	QSOSinus.setPixmap(DATADIR "img/sinus.png");
	QSOTri.setPixmap(DATADIR "img/tri.png");
	QSOSquare.setPixmap(DATADIR "img/square.png");
	QSOSaw.setPixmap(DATADIR "img/saw.png");
	

	// caption
	QSOSinus.setCaption(QObject::tr("Sine"));
	QSOTri.setCaption(QObject::tr("Triangle"));
	QSOSquare.setCaption(QObject::tr("Square"));
	QSOSaw.setCaption(QObject::tr("Saw"));
	
	QApp.setMainWidget( &QHBMain );
	QHBMain.resize(645,340);
	QHBMain.show();
	
	QApp.exec();
	
	strcpy(line,"quit\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode	
	
	strcpy(line,"quit\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode	
	
	unlink(frocor_uds_file);
	unlink(fms_uds_file);
	
}
