/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <cstring>
#include <qslider.h>
#include <qlabel.h>
#include <unistd.h>
#include <iostream>

using namespace std;

void QSoundOptions::init()
{
     ocor_id=fms_id=sound_id=-1;
     QSFrequency->setValue(400);
     before_volume=50;     
     QSVolume->setValue(50);
     QSInterference->setValue(0);
}


void QSoundOptions::setPixmap( char *filename )
{
    QLGraph->setPixmap(QPixmap(filename));
}

void QSoundOptions::setCaption(const char *dcaption)
{
     QLCaption->setText(dcaption);  
}

void QSoundOptions::sendFrequency( int value )
{
    if(ocor_id<1 || fms_id<1) return;
    int freq = value;
    // frequency for interference sound
    int freq2 = value + QSInterference->value();
    // ocor has half the number of objects, sound_id must be even!
    int ocor_nr=int(sound_id/2);
    
    char line[256];
    // send to fms
    strcpy(line, "s:o:\0");
    write(fms_id,line,strlen(line));
    // send sound id
    strcpy(line, QString::number(sound_id));
    write(fms_id,line,strlen(line));
    // send frequency operator
    strcpy(line, ":f=\0");
    write(fms_id,line,strlen(line));
    // send frequency argument
    strcpy(line, QString::number(freq));
    write(fms_id,line,strlen(line));
    // send endl
    strcpy(line,"\n\0");
    write(fms_id,line,strlen(line));
    
    // send to fms 2nd sound
    strcpy(line, "s:o:\0");
    write(fms_id,line,strlen(line));
    // send sound id
    strcpy(line, QString::number(sound_id+1));
    write(fms_id,line,strlen(line));
    // send frequency operator
    strcpy(line, ":f=\0");
    write(fms_id,line,strlen(line));
    // send frequency argument
    strcpy(line, QString::number(freq2));
    write(fms_id,line,strlen(line));
    // send endl
    strcpy(line,"\n\0");
    write(fms_id,line,strlen(line));
    
    // send to ocor
    strcpy(line, "o:\0");
    write(ocor_id,line,strlen(line));
    // send ocor object id
    strcpy(line, QString::number(ocor_nr));
    write(ocor_id,line,strlen(line));
    // send color operator
    strcpy(line, ":c=\0");
    write(ocor_id,line,strlen(line));
    // send color argument, converted by colorconv.h
    strcpy(line, QString::number(color16(freq)));
    write(ocor_id,line,strlen(line));
    // send endl
    strcpy(line,"\n\0");
    write(ocor_id,line,strlen(line));
   
}


void QSoundOptions::sendVolume( int value )
{
    if(ocor_id<1 || fms_id<1) return;
    
    double relative_volume = float(value)/float(before_volume); // otherwise it's integer
    before_volume = value;
    // ocor has half the number of objects, sound_id must be even!
    int ocor_nr=int(sound_id/2);
    
    char line[256];
    // send to fms
    strcpy(line, "s:o:\0");
    write(fms_id,line,strlen(line));
    // send sound id
    strcpy(line, QString::number(sound_id));
    write(fms_id,line,strlen(line));
    // send volume operator
    strcpy(line, ":v=\0");
    write(fms_id,line,strlen(line));
    // send volume argument
    strcpy(line, QString::number(value)); // this is the absolute value!
    write(fms_id,line,strlen(line));
    // send endl
    strcpy(line,"\n\0");
    write(fms_id,line,strlen(line));
    
    // send to fms 2nd sound
    strcpy(line, "s:o:\0");
    write(fms_id,line,strlen(line));
    // send sound id
    strcpy(line, QString::number(sound_id+1));
    write(fms_id,line,strlen(line));
    // send volume operator
    strcpy(line, ":v=\0");
    write(fms_id,line,strlen(line));
    // send volume argument
    strcpy(line, QString::number(value)); // this is the absolute value!
    write(fms_id,line,strlen(line));
    // send endl
    strcpy(line,"\n\0");
    write(fms_id,line,strlen(line));
    
    // send to ocor
    strcpy(line, "o:\0");
    write(ocor_id,line,strlen(line));
    // send ocor object id
    strcpy(line, QString::number(ocor_nr));
    write(ocor_id,line,strlen(line));
    // send zoom operator
    strcpy(line, ":z=\0");
    write(ocor_id,line,strlen(line));
    // send zoom change
    strcpy(line, QString::number(relative_volume,'f')); // floating point format
    write(ocor_id,line,strlen(line));
    // send endl
    strcpy(line,"\n\0");
    write(ocor_id,line,strlen(line));
    
}


void QSoundOptions::sendInterference( int value )
{
    if(ocor_id<1 || fms_id<1) return;
 
    int interference=value;
    // second frequency
    int freq2=QSFrequency->value()+interference;
    // ocor has half the number of objects, sound_id must be even!
    int ocor_nr=int(sound_id/2);
    
    char line[256];
    
    // send to fms 2nd sound
    strcpy(line, "s:o:\0");
    write(fms_id,line,strlen(line));
    // send sound id, which is normal id+1, because this is the second sound
    strcpy(line, QString::number(sound_id+1)); 
    write(fms_id,line,strlen(line));
    // send frequency operator
    strcpy(line, ":f=\0");
    write(fms_id,line,strlen(line));
    // send frequency argument
    strcpy(line, QString::number(freq2));
    write(fms_id,line,strlen(line));
    // send endl
    strcpy(line,"\n\0");
    write(fms_id,line,strlen(line));
    
    // send to ocor
    strcpy(line, "o:\0");
    write(ocor_id,line,strlen(line));
    // send ocor object id
    strcpy(line, QString::number(ocor_nr));
    write(ocor_id,line,strlen(line));
    // send rotation
    strcpy(line, ":a=\0");
    write(ocor_id,line,strlen(line));
    // send angular velocity argument
    strcpy(line, QString::number(float(interference)/3.0,'f'));
    write(ocor_id,line,strlen(line));
    // send endl
    strcpy(line,"\n\0");
    write(ocor_id,line,strlen(line));
    
}


void QSoundOptions::setSocket( int docor_id, int dfms_id, int dsound_id )
{
    ocor_id=docor_id; 
    fms_id=dfms_id;
    sound_id=dsound_id;
    if(sound_id%2)
    {
	cout << "sound_id not even" << endl;
	sound_id++;
    }
    sendFrequency(QSFrequency->value());
    sendVolume(50);
    sendInterference(QSInterference->value());
}
