#include "../fms/include/fmplayer.h"
#include "kbhit.h" // thank god s.b. has coded 'keypressed' for me

// headers for uds
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#include <cstring>
#include <iostream>

using namespace std;

int main()
{
	FMPlayer p;
	double ffactor=1.5;
	double vfactor=1.5;
	keyboard k;
	char line[80];
	char *uds_file="/tmp/quint-uds";
	
	// init player
	p.syncPlayInit();
	p.aMixer->setVolume(0.5);

	cout << "fms initiated" << endl;
	
	// init socket
	unlink(uds_file);
	int clsd;
	int sd = socket(AF_UNIX, SOCK_STREAM, 0);
	socklen_t cllen;
	struct sockaddr_un addr,claddr; // address, client address
	addr.sun_family=AF_UNIX;
	strcpy(addr.sun_path, uds_file);

	if(bind(sd,(struct sockaddr *)&addr,strlen(addr.sun_path)+sizeof(addr.sun_family))<0)
	{
		cout << "binding uds failed. exiting..." << endl;
		goto stop;
	}
	// geh horch
	if(listen(sd,1))
	{
		cout << "listening failed. exiting..." << endl;
		goto stop;
	}
	cllen=sizeof(claddr); // sb was smart enough to do bind and accept differently
	clsd=accept(sd,(struct sockaddr *)&claddr, &cllen);
	if(clsd<0)
	{
		cout << "accept failed. exiting..." << endl;
		goto stop;
	}
	
	cout << "uds successfully established" << endl;

	cout << "press:\n\t'+' for higher frequency\n\t'-' for lower frequency\n\t'*' for higher volume\n\t'/' for lower volume\n\t'q' to quit" << endl;
	
	cout << "\t# output in FROCOR-Protocol" << endl;
	
	strcpy(line,"protocol frocor-pre1\n\0");
	write(clsd,line,strlen(line));
	cout << "\t# " << line << endl;
	
	strcpy(line, "n:1:t=c:x1=0:y1=0:r=5:c=30000\n\0");
	write(clsd,line,strlen(line));
	cout << "\t# " << line << endl;
	
	while(1/*!(p.first->syncFin())*/)
	// ignore FMS-owned time limits
	{	
		if(k.kbhit()){ // if keypressed
			char c = k.getch();
			double prevvol,zoom;
			switch(c)
			{
			 case '+': 
			  p.aSound->setFreq(p.aSound->getFreq()*ffactor,0); 
			  // 0 => without complock
			  strcpy(line,"o:1:c+5000\n\0");
			  write(clsd,line,strlen(line));
			  cout << "\t# " << line << endl;
			  // TODO: FROCOR-Protocol should have *-Operator
			  break;
			 case '-': 
			  p.aSound->setFreq(p.aSound->getFreq()/ffactor,0);
			  strcpy(line,"o:1:c-5000\n\0");
			  write(clsd,line,strlen(line));
			  cout << "\t# " << line << endl;
			  break;
			 case '*':
			  p.aMixer->setVolume(p.aMixer->getVolume()*vfactor); 
			  // might not set correctly, if vol>1
			  strcpy(line,"o:1:z=1.5\n\0");
			  write(clsd,line,strlen(line));
			  cout << "\t# " << line << endl;
			  break;
			 case '/':
			  p.aMixer->setVolume(p.aMixer->getVolume()/vfactor); 
			  strcpy(line,"o:1:z=0.7\n\0");
			  write(clsd,line,strlen(line));
			  cout << "\t# " << line << endl;
			  break;
			 case 'q':
			  goto stop; 
			}
		}
		p.syncPlayValue(); // compute & play value
	}
	
	stop:
	
	strcpy(line, "quit\n\0");
	write(clsd,line,strlen(line));
	cout << "\t# " << line << endl;

	unlink(uds_file);
	
	return 0;
}
