#include <iostream>
#include <cstring>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <sstream>

#include "include/kbhit.h"

// #define debug_mode 1

using namespace std;

int frocor_clsd;

class Snowflake {
  public:
	Snowflake(int dobj_id);
	~Snowflake();
	void fall();
	void addFlake();
  private:
	bool falling;
	int obj_id;
	float y;
	Snowflake *next;
};

Snowflake::Snowflake(int dobj_id)
{
	next=0;
	y=4.0;
	float x=float((rand()%400)-200)/100.0;
	falling=1;
	obj_id=dobj_id;
	
	char line[32];
	
	strcpy(line, "n:\0");
	write(frocor_clsd,line,strlen(line));
	sprintf(line,"%d",obj_id);
	write(frocor_clsd,line,strlen(line));
	strcpy(line, ":t=p:n=3:x0=\0");
	write(frocor_clsd,line,strlen(line));
	sprintf(line,"%f",x);
	write(frocor_clsd,line,strlen(line));
	strcpy(line, ":y0=4:x1=\0");
	write(frocor_clsd,line,strlen(line));
	sprintf(line,"%f",x-0.05);
	write(frocor_clsd,line,strlen(line));
	strcpy(line, ":y1=3.913:x2=\0");
	write(frocor_clsd,line,strlen(line));
	sprintf(line,"%f",x+0.05);
	write(frocor_clsd,line,strlen(line));
	strcpy(line, ":y2=3.913:c=-1\n\0");
	write(frocor_clsd,line,strlen(line));
	
	strcpy(line, "n:\0");
	write(frocor_clsd,line,strlen(line));
	sprintf(line,"%d",obj_id+1);
	write(frocor_clsd,line,strlen(line));
	strcpy(line, ":t=p:n=3:x0=\0");
	write(frocor_clsd,line,strlen(line));
	sprintf(line,"%f",x);
	write(frocor_clsd,line,strlen(line));
	strcpy(line, ":y0=3.9:x1=\0"); // 3.9 is a try
	write(frocor_clsd,line,strlen(line));
	sprintf(line,"%f",x+0.05);
	write(frocor_clsd,line,strlen(line));
	strcpy(line, ":y1=3.987:x2=\0");
	write(frocor_clsd,line,strlen(line));
	sprintf(line,"%f",x-0.05);
	write(frocor_clsd,line,strlen(line));
	strcpy(line, ":y2=3.987:c=-1\n\0");
	write(frocor_clsd,line,strlen(line));	
}

Snowflake::~Snowflake()
{
	if(next)
		delete next;
}

void Snowflake::addFlake()
{
	if(next)
		next->addFlake();
	else
		next = new Snowflake(obj_id+2);
}

void Snowflake::fall()
{
	if(falling)
	{
	  char line[32];
	  y-=0.3;
	  int xdir = rand()%2;
	  if(y<=-2) {
	  	y= -2;
		falling=0;
	  }
	  else {
	    strcpy(line, "o:\0");
	    write(frocor_clsd,line,strlen(line));
		
	    sprintf(line,"%d",obj_id);
	    write(frocor_clsd,line,strlen(line));
			
	    strcpy(line, ":y0-0.3:y1-0.3:y2-0.3\0");
	    write(frocor_clsd,line,strlen(line));
	
	    if(xdir)  
	  	  strcpy(line, ":x0-0.1:x1-0.1:x2-0.1\n\0");
	    else
	  	  strcpy(line, ":x0+0.1:x1+0.1:x2+0.1\n\0");
	    write(frocor_clsd,line,strlen(line));
	    
	    ////////////////
	    
	    strcpy(line, "o:\0");
	    write(frocor_clsd,line,strlen(line));
		
	    sprintf(line,"%d",obj_id+1);
	    write(frocor_clsd,line,strlen(line));
			
	    strcpy(line, ":y0-0.3:y1-0.3:y2-0.3\0");
	    write(frocor_clsd,line,strlen(line));
	
	    if(xdir)  
	  	  strcpy(line, ":x0-0.1:x1-0.1:x2-0.1\n\0");
	    else
	  	  strcpy(line, ":x0+0.1:x1+0.1:x2+0.1\n\0");
	    write(frocor_clsd,line,strlen(line));
	  }
	}
	if(next)
		next->fall();
}


int main(int argc, char *argv[])
{
	// all uds stuff taken from frocor.cpp

	// let me be so impertinent to do this... for <cough> convenience
	unlink("/tmp/ocorsdl-user.0");
	
	//taken from quint.cpp
	char *frocor_uds_file= "/tmp/frocor-uds";
  	unlink(frocor_uds_file);
	// int frocor_clsd; // now global for snowflakes
	int frocor_sd = socket(AF_UNIX, SOCK_STREAM, 0);
	socklen_t frocor_cllen;
	struct sockaddr_un frocor_addr,frocor_claddr; // address, client address
	frocor_addr.sun_family=AF_UNIX;
	strcpy(frocor_addr.sun_path, frocor_uds_file);

	if(bind(frocor_sd,(struct sockaddr *)&frocor_addr,strlen(frocor_addr.sun_path) 
				+sizeof(frocor_addr.sun_family))<0)
	{
		cout << "binding uds failed. exiting..." << endl;
		return 0;
	}
	// geh horch
	if(listen(frocor_sd,1))
	{
		cout << "listening failed. exiting..." << endl;
		return 0;
	}
	frocor_cllen=sizeof(frocor_claddr); // sb was smart enough to do bind and accept differently
	frocor_clsd=accept(frocor_sd,(struct sockaddr *)&frocor_claddr, &frocor_cllen);
	if(frocor_clsd<0)
	{
		cout << "accept failed. exiting..." << endl;
		return 0;
	}

#ifdef debug_mode
	cout << "frocor_uds successfully established" << endl;
#endif // debug_mode
	
	char *fms_uds_file= "/tmp/fms-uds";   //vorlaeufig
  	char line[256];
	unlink(fms_uds_file);
	int fms_clsd;
	int fms_sd = socket(AF_UNIX, SOCK_STREAM, 0);
	socklen_t fms_cllen;
	struct sockaddr_un fms_addr,fms_claddr; // address, client address
	fms_addr.sun_family=AF_UNIX;
	strcpy(fms_addr.sun_path, fms_uds_file);

	if(bind(fms_sd,(struct sockaddr *)&fms_addr,strlen(fms_addr.sun_path) 
				+sizeof(fms_addr.sun_family))<0)
	{
		cout << "binding uds failed. exiting..." << endl;
		return 0;
	}
	// geh horch
	if(listen(fms_sd,1))
	{
		cout << "listening failed. exiting..." << endl;
		return 0;
	}
	fms_cllen=sizeof(fms_claddr); // sb was smart enough to do bind and accept differently
	fms_clsd=accept(fms_sd,(struct sockaddr *)&fms_claddr, &fms_cllen);
	if(fms_clsd<0)
	{
		cout << "accept failed. exiting..." << endl;
		return 0;
	}

#ifdef debug_mode
	cout << "fms_uds successfully established" << endl;
#endif // debug_mode

	// ocor init
	
	strcpy(line,"protocol frocor-pre1\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	int tc=8140;
	strcpy(line, "n:0:t=p:n=3:x0=-2:y0=0:x1=2:y1=0:x2=0:y2=4:c=8140\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	strcpy(line, "n:1:t=p:n=4:x0=-0.5:y0=0:x1=0.5:y1=0:x2=0.5:y2=-2:x3=-0.5:y3=-2:c=-4889\n\0");
	/*hopefully this will be somewhat brown now --fabian*/
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	// Kugeln (ab y=0 aufwrts)
	strcpy(line, "lock\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode

	strcpy(line, "n:2:t=c:x0=-2:y0=0:r=0.3:c=9340\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	strcpy(line, "n:3:t=c:x0=0:y0=0:r=0.2:c=34940\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	strcpy(line, "n:4:t=c:x0=2:y0=0:r=0.3:c=47140\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	strcpy(line, "n:5:t=c:x0=-1:y0=1:r=0.2:c=59340\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	strcpy(line, "n:6:t=c:x0=1:y0=1:r=0.2:c=9340\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	strcpy(line, "n:7:t=c:x0=0:y0=2:r=0.2:c=34940\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;	
#endif // debug_mode
	
	strcpy(line, "n:8:t=c:x0=-0.4:y0=3:r=0.15:c=47140\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;	
#endif // debug_mode
	
	strcpy(line, "n:9:t=c:x0=0.4:y0=3:r=0.15:c=59340\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;	
#endif // debug_mode


	/*star*/
	
	strcpy(line, "n:10:n=10:x0=5.75:x1=6.15:x2=7.49:x3=6.36:x4=6.83:x5=5.75:x6=4.68:x7=5.15:x8=4:x9=5.38\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;	
#endif // debug_mode

	strcpy(line, "o:10:y0=13.53:y1=12.13:y2=12.17:y3=11.36:y4=10:y5=10.88:y6=10:y7=11.34:y8=12.19:y9=12.11\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;	
#endif // debug_mode

	strcpy(line, "o:10:z=0.3:c=59330\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;	
#endif // debug_mode

	strcpy(line, "unlock\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode

	// fms init
	
	strcpy(line,"protocol fms-0.9\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode
	
	strcpy(line,"s:n:0:p=midi/jinglebells1.fms:mi=tri:mh=midi/attack\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode
	
	strcpy(line,"s:n:1:p=midi/jinglebells2.fms:mh=midi/attack\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode
	
	strcpy(line,"m:t=32\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode
	
	strcpy(line,"play\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode

	// from quint.cpp
	keyboard k;
	
	// hey Fabian, you fixed it (if 10 had stayed it would've been a bug)
	Snowflake *Flake = new Snowflake(11);
	
	while(1/*!(p.first->syncFin())*/)
	// ignore FMS-owned time limits
	{	
		strcpy(line, "lock\n\0");
		write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
		cout << "\tfrocor # " << line << endl;
#endif // debug_mode
		
		if(k.kbhit()){ // if keypressed
			char c = k.getch();
			if(c == 'q') goto stop; 
			if(c == '+') {
				tc+=100;
				strcpy(line, "o:0:c=\0");
				write(frocor_clsd,line,strlen(line));
				
				sprintf(line,"%d",tc);
				write(frocor_clsd,line,strlen(line));
				
				strcpy(line, "\n\0");
				write(frocor_clsd,line,strlen(line));
				
#ifdef debug_mode
				cout << "color: " << tc << endl;
#endif // debug_mode
				
			}
			if (c == 's') /*start to spin star*/ {
				strcpy(line, "o:10:a=0.3\n\0");
				write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
				cout << "\tfrocor # " << line << endl;	
#endif // debug_mode
			}
			if (c == 'd') /*stop spinning star*/ {
				strcpy(line, "o:10:a=0\n\0");
				write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
				cout << "\tfrocor # " << line << endl;	
#endif // debug_mode
			}
		}
		for(int i=2; i<=9; i++)
		// Kugeln frben
		{
			strcpy(line, "o:\0");
			write(frocor_clsd,line,strlen(line));
			
			sprintf(line,"%d",i);
			write(frocor_clsd,line,strlen(line));
			
			strcpy(line, ":c=\0");
			write(frocor_clsd,line,strlen(line));
				
			switch(rand()%4)
			{
			case 0:
			    	sprintf(line,"%d",9340); // hellblau
				break;
			case 1:
			    	sprintf(line,"%d",34940); // violett
				break;
			case 2:
			    	sprintf(line,"%d",47140); // dunkelrot
				break;
			case 3:
			    	sprintf(line,"%d",59340); // gelb
				break;
			}
			write(frocor_clsd,line,strlen(line));
			
			strcpy(line, "\n\0");
			write(frocor_clsd,line,strlen(line));			
		}
		Flake->fall();
		if(rand()%3==0)
			Flake->addFlake();

		strcpy(line, "unlock\n\0");
		write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
		cout << "\tfrocor # " << line << endl;
#endif // debug_mode

		sleep(1); //doesn't sleep work for 0.n seconds???-f
	}
	
	stop:
	
	
	strcpy(line,"quit\n\0");
	write(fms_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfms # " << line << endl;
#endif // debug_mode
	
	strcpy(line,"quit\n\0");
	write(frocor_clsd,line,strlen(line));
#ifdef debug_mode
	cout << "\tfrocor # " << line << endl;
#endif // debug_mode
	
	delete Flake;
	
	sleep(1);
	
	unlink(frocor_uds_file);
	unlink(fms_uds_file);
	
}
