#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h> /*I guess needed for unix domain sockets*/
//#include <netinet/in.h> /*for internet domain addresses*/


void rwsocket (int newsocksd, char csmode);
void error (char *msg);

#define BUFFERL 256
char buffer[BUFFERL];

void error (char *msg)
{
	perror(msg);
	exit(1);
}

int main (int argc, char *argv[])
{
	//get socket to write to
	int sd=socket (AF_UNIX, SOCK_STREAM, 0), newsocksd;
	char *udsfilename;
	struct sockaddr_un addr, clientaddress;
	int clilen;
	char csmode='z'; // client or server?
	int i;

	//initialization
	udsfilename=NULL;

	//puts (argv[1]);
	for (i=1; i<argc; i++)
	{
		if ((strcmp(argv[i],"--server"))==0)
		{
			csmode='s';
			puts ("Will act as server");
		}
		if ((strcmp(argv[i],"--client"))==0) 
		{
			csmode='c';
			puts ("Will act as client");
		}
		if ((strcmp(argv[i],"-f"))==0)
		{
			i++;
			udsfilename=malloc(strlen(argv[i]));
			if (udsfilename==NULL)
			{
				puts ("Error! Ran out of memory!");
				exit(1);
			}
			udsfilename=strcpy (udsfilename,argv[i]);
		}

	}
	if (csmode!='s'&&csmode!='c') // if neither server nor client given as parameter
	{
		do
		{
			puts ("act as server (s) or as client (c)?");
			csmode=getchar();
		}
		while (csmode!='s' && csmode!='c');
	}

	if (udsfilename==NULL)
	{
		puts ("what unix domain socket shall I use?");
		fgets (buffer, BUFFERL, stdin);
		udsfilename=malloc (strlen(buffer));
		if (udsfilename==NULL)
		{
			puts ("Error! Ran out of memory!");
			exit(1);
		}
		udsfilename=strcpy (udsfilename, buffer);
		//puts (udsfilename);
	}

	// initialize server
	addr.sun_family=AF_UNIX;
	strcpy (addr.sun_path, udsfilename);
	if (csmode=='s')
	{
		unlink(udsfilename); // that's for convenience of my tcp testing, hope it's ok Fab
		if ((bind (sd, (struct sockaddr*)&addr, strlen(addr.sun_path)+sizeof(addr.sun_family))) < 0)
		if ((bind (sd, (struct sockaddr*)&addr, strlen(addr.sun_path)-sizeof(char)+sizeof(addr.sun_family))) < 0)
			/*really ugly. the -sizeof(char) is needed because bind will otherwise also use the \0 character at the end of the string*/
			error ("ERROR in binding");
		listen (sd, 1);
		clilen=sizeof(clientaddress);
		newsocksd=accept(sd, (struct sockaddr*)&clientaddress, &clilen);
		printf ("client connected on socket %d", newsocksd);
	}
	if (csmode=='c')
	{
		if (connect (sd, (struct sockaddr*)&addr, strlen(addr.sun_path)+sizeof(addr.sun_family))<0)
			error ("ERROR: can't connect to server");
		newsocksd=sd;
	}
	// read + write data
	rwsocket(newsocksd, csmode);

	// free all allocated memory
	free (udsfilename);
	return 0;
}

void rwsocket (int newsocksd, char csmode)
{
	pid_t pid;
	/*if (read(newsocksd, buffer, BUFFERL)<0)
		error("ERROR reading from socket");
	puts (buffer);*/
	pid=fork();
	if (pid==0) //child
	{
		do
		{
			fgets (buffer,BUFFERL,stdin);
			if ((write (newsocksd, buffer, strlen(buffer)))<0)
				error ("ERROR writing to socket");
		}
		while (1);
		exit (0);
	}
	else
	{
		do
		{
			if(read(newsocksd, buffer, 1)<1)
			{
				error ("ERROR reading from socket");
				continue;
			}
			printf ("%s",buffer);

		} 
		while (1);
	}
	shutdown (newsocksd, 2);
	unlink (newsocksd);
		
}

