//HEADERS///

{debugging options} ///
{define DEBUG} {debugging output}
{define DEBUGERROR} {output errors}
{define READLN} {debugging: enable readln; ?}
{define WRITEFROCORINPUT} {debugging: write input received ?}
{define PRINTA} {debugging: print spin speed for each animation?}
{define DEBUGTHREADS}
//\

{vim information}///
{using markers for folding}
{
:set foldmethod=marker
:set foldmarker=///,//\
:set commentstring=
:set foldcolumn=5
:highlight Folded ctermfg=yellow
:set foldlevel=0
}
{close whenever leaving a fold?}
{
:set foldclose=all
}//\

PROGRAM ocorbackend;
{$THREADING ON}
USES MATH, sockets, unix, transformations, objects{$ifdef unix}, cthreads{$endif};//\

CONST///
	width=500;
	height=500;

	//width=640;
	//height=480;
	sdlsockettype=AF_UNIX; {use uds}//\

TYPE	///

	{--------------------------general-----------------------}///
	pointprec = real;
	rpointprec = integer;
	points = ARRAY [0..100] OF pointprec;
	rpoints =ARRAY [0..100] OF rpointprec;

	objtype = (line, polygon, circle, dots); 	

	animateby = real; {argument for the animation}
	animationtype = (amove, azoom, aturn, astretch, aflip); 
	adirection = real; {animation move direction}//\


{--------------------------Objects------------------------}///

	{---------------shape--------------}///
	
	{---animations---}///
	Tanim = object///
		at: animationtype;
		ab: animateby;
		adir: adirection;
		ap: ARRAY [0..100] of boolean; 
		as: word; {animation steps ... perform action all as steps}
		ao: word; {how often shall that animation be performed?}
		{stop after performed ao times}
		{aod: word; {aodone: how often has this animation already been performed?}}
		{case at: animationtype of
			amove: (adir: adirection);}
		myshape: ^Tshape;
		procedure go;
		constructor init;
	end;//\
	Panim = ^Tanim;
	Tanims = array [0..100] of Panim;//\

	
	{-------shape-------}/// ///

	Tshape = object///
		sticky: boolean;
		edit: boolean;
		show: boolean;
		x: points;
		y: points;
		rx: rpoints;
		ry: rpoints;
		total: integer; {not really needed for anything except polygons and dots, but too anoying to get based on type every time} {starts with 0: 0 --> point 0-0 --> 1 point}
		an: Tanims;
		nan: integer; {number of animations} {don't forget to set this to -1 for all ways in which new objects can be created! Because this is gonna be an open array, they can't all be set to -1! Create a newobject procedure in case any more initializations are necessary!}
		ot: objtype;
		radius: pointprec;
		rradius:rpointprec;
		color: integer;
		constructor init;
		destructor destruct;
		procedure ograph (var sdlbackendout: text);
		function xmin: real;
		function xmax: real;
		function ymin: real;
		function ymax: real;
		procedure getrxry;
		procedure del(todel:integer);
		procedure zoom (zoomby: real);
		procedure stretch (xstretch,ystretch: real);
		procedure flip (flipangle:real);
		procedure turn (xturn, yturn: integer);
		procedure spin (turnby: real);
		procedure movexy (xmove, ymove: real);
		procedure moveangle (shiftangle, shift: real);
		procedure animate;
	end;//\

	Pshape = ^Tshape;
	Tshapes = array [0..1000] of Pshape;//\

	{----children----}///
	{fp refuses to compile if properties of shape which are not part
	of objrec, but of Tcircle etc. are used.}
	{Tcircle = object (objrec)
		radius: pointprec;
		rradius:rpointprec;
	end;
	Pcircle = ^Tcircle;
	
	Tpolygon = object(objrec)
		totalp:integer;
	end;
	Ppolygon = ^Tpolygon;}

	{dotst: (totald: integer); {how may dots}}
//\

//\
	//\
	
	{---------------Graph object----------------}///

	Tgraphresolution = object///
		x: word;
		y: word;
	end;
//\
	Tsresmult = object///
		x: real;
		y: real;
		function getx: real;
		function gety: real;
	end;
//\
	Tgraphsticky = object///
		resmult: Tsresmult; 
	end;
//\
	Tmoveby = object///
		x: integer;
		y: integer;
	end;
//\
	Tgraph = object///
		resolution: Tgraphresolution;
		resmult: real;
		sticky: Tgraphsticky;
		saveview: boolean;
		astep: word; {animation step}
		moveby: Tmoveby;
		lastshape: integer;
		oldxmin: real; {this is needed because we don't change the view when modifying the graph}
		oldymin: real;
		update: boolean;
		procedure newshape (sn:integer);
		function xmin: real;
		function ymin: real;
		function xmax: real;
		function ymax: real;
		function getresmult: real;
		procedure getrxry;
		procedure ograph;
		procedure newgraph;
		procedure zoom (zoomby: real);
		procedure stretch (xstretch,ystretch: real);
		procedure flip (flipangle:real);
		procedure turn (xturn, yturn: integer);
		procedure spin (turnby: real);
		procedure movexy (xmove, ymove: real);
		procedure moveangle (shiftangle, shift: real);
		constructor init;
		destructor destruct;
		procedure animate;
	end;//\


//\
	
	{--------------sockets object-------------}///

	Tanysock = object///
		descriptor: longint;
		path: string[25];
		//procedure connect; virtual; abstract;
		//procedure disconnect; virtual; abstract;
		procedure perror (const S: string);
	end;
//\
	Tsdlsock = object(Tanysock) ///
		clientaddress: string[25];
		accepted: longint;
		backendin: text;
		backendout: text;
		procedure start; 
		procedure disconnect;
	end; 
	//\
	Tfrocorsock = object(Tanysock)///
		ocorin: text; {frocor-player sends to ocor}
		ocorout: text;{ocor sends to frocor-player}
		procedure start; {can't call this connect because we need socket unit connect procedure}
		procedure disconnect;
	end;
//\
	Tsock = object///
		sdl: Tsdlsock;
		frocor: Tfrocorsock;
	end;///\/\\
	//\
	//\
	//\

	{----------frocor (protocol) object----------}///

	Tfrocor = object
		udsline: string [255];
		//threadid: dword; {animation thread handle}
		turnoff: boolean; {since killthread for some reason isn't working}
		constructor init;
		procedure syntaxerror (description: string);
		procedure readcommands;
		procedure processcommands;
		procedure newshape (var sn: integer);
		function  nextcolon: string;
		procedure nextoperation (var sproperty: string; var operation: char; var props: string);
		procedure property (sn:integer; props: string);
		procedure propertynumber (sproperty: string; operation: char; value: real; sn: integer);
		procedure propertynonumber (props: string; sproperty: string; sn: integer);
		procedure getproperties (sn:integer);
		function  modifyproperty (originalvalue: real; operation: char; value: real): real;
		procedure ograph;
	end;
	//\//\//\//\

VAR///
{-----------------------------VAR-------------------------------}

	{-------------objects------------}
	graph : Tgraph;
	shape:	Tshapes;
	sock:   Tsock;
	frocor:   Tfrocor;

	{---------other variables--------}

//\//\

//PROCEDURES///
{---------------------------PROCEDURES------------------------------}

{-----------------constructors destructors-------------------}

{------------------Tgraph----------------}

constructor Tgraph.init;///
begin
	lastshape:=-1;
	{temporary solution:}
	resolution.x:=width;
	resolution.y:=height;

	{animation step: 0}
	graph.astep:=0;
	update:=true;
end;//\

destructor Tgraph.destruct;///
var sn: integer;
begin
	if lastshape>-1 then begin {if no shapes, don't free their memory...}
		for sn:=0 to lastshape do begin
			dispose (shape[sn],destruct); {dispose each shape}
		end;
	end;
end;//\

constructor Tfrocor.init;///
begin
	turnoff:=false
end;//\

{--------------------------max min-------------------------}
{max and min values of each object}

{---------------max min each shape-------------}

function Tshape.xmin: real;///
var i: integer;
begin
	xmin:=10000000; {ten million}
	if sticky=false then begin
		if ot=circle then begin
			if (x[0]-radius)<xmin then xmin:=(x[0]-radius);
		end;
		if (ot=polygon) or (ot=line) then begin
			for i:=0 to total do begin
				if x[i]<xmin then xmin:=x[i];
			end;
		end;
	end;
end;//\

function Tshape.ymin: real;///
var i: integer;
begin
	ymin:=10000000; {ten million}
	if sticky=false then begin
		if ot=circle then begin
			if (y[0]-radius)<ymin then ymin:=(y[0]-radius);
		end;
		if (ot=polygon) or (ot=line) then begin
			for i:=0 to total do begin
				if y[i]<ymin then ymin:=y[i];
			end;
		end;
	end;
end;//\

function Tshape.xmax: real;///
var i: integer;
begin
	xmax:=-10000000; {ten million}
	if sticky=false then begin
		if ot=circle then begin
			if (x[0]+radius)>xmax then xmax:=(x[0]+radius);
		end;
		if (ot=polygon) or (ot=line) then begin
			for i:=0 to total do begin
				if x[i]>xmax then xmax:=x[i];
			end;
		end;
	end;
end;//\

function Tshape.ymax: real;///
var i: integer;
begin
	ymax:=-10000000; {ten million}
	if sticky=false then begin
		if ot=circle then begin
			if (y[0]+radius)>ymax then ymax:=(y[0]+radius);
		end;
		if (ot=polygon) or (ot=line) then begin
			for i:=0 to total do begin
				if y[i]>ymax then ymax:=y[i];
			end;
		end;
	end;
end;//\



{---------------max min whole graph----------------}

{max and min values of whole graph}

function Tgraph.xmin: real;///
var sn: integer;
begin
	xmin:=10000000;
	for sn:=0 to lastshape do begin
		{$ifdef DEBUG} writeln ('getting xmax for shape: ',sn); 
		if shape[sn]^.xmin<xmin then writeln('new xmin');{$endif}
		if shape[sn]^.xmin<xmin then xmin:=shape[sn]^.xmin;
	end;
end;//\

function Tgraph.ymin: real;///
var sn: integer;
begin
	ymin:=10000000;
	for sn:=0 to lastshape do begin
		if shape[sn]^.ymin<ymin then ymin:=shape[sn]^.ymin;
	end;
end;//\

function Tgraph.xmax: real;///
var sn: integer;
begin
	xmax:=-10000000;
	for sn:=0 to lastshape do begin
		{$ifdef DEBUG} 
			writeln ('getting xmax for shape: ',sn);
			if shape[sn]^.xmin<xmin then writeln('new xmin');
		{$endif}
		if shape[sn]^.xmax>xmax then xmax:=shape[sn]^.xmax;
	end;
end;//\

function Tgraph.ymax: real;///
var sn: integer;
begin
	ymax:=-10000000;
	for sn:=0 to lastshape do begin
		if shape[sn]^.ymax>ymax then ymax:=shape[sn]^.ymax;
	end;
end;
//\

{----------------------------animations-----------------------------}

{--------------------constructors destructors-----------------------}

constructor Tanim.init;///
var i: integer;
begin
	as:=1;
	ao:=0;
	at:=azoom;
	ab:=1;
	for i:=0 to 100 do begin {TODO: dynamic}
		ap[i]:=true;
	end;
end;//\

{-----------------perform _this_ animation------------------}

procedure Tanim.go ;///
var i: integer;
begin
	{is this step animated}
	{$ifdef DEBUG} writeln ('procedure Tanim.go'); {$endif}
	if (((graph.astep) mod (as))=0) then begin
		{still within the total number of animations that will be performed?}
		if (graph.astep div as < ao) or (ao=0) then begin
			{perform animations...}
			{$ifdef DEBUG} writeln ('performing animations'); {$endif}
			if at=azoom then begin///
				if myshape^.ot=circle then transform.zoom (myshape^.radius,ab);
				for i:=0 to myshape^.total do begin
					if ap[i]=true then begin {is this dot animated?}
						transform.zoom (myshape^.x[i],myshape^.y[i],ab);
					end;
				end;
			end;
//\
			if at=amove then begin///
				for i:=0 to myshape^.total do begin
					if ap[i]=true then begin
						transform.moveangle (myshape^.x[i],myshape^.y[i],adir,ab);
					end;
				end;
			end;
			//\
			if at=aturn then begin///
				{$ifdef DEBUG} writeln ('myshape pointer coming up next'); {$endif}
				for i:=0 to myshape^.total do begin
				{$ifdef DEBUG} writeln ('myshape pointer done'); {$endif}
					if ap[i]=true then begin
						{$ifdef DEBUG} writeln ('transforming'); {$endif}
						myshape^.spin (ab);
					end;
				end;
			end;//\
			{do stretching etc.}
		end;
	end;
	{$ifdef DEBUG} writeln ('Tanim.go done'); {$endif}
end;
//\

{------------------perform a shape's animation----------------}

procedure Tshape.animate;///
var i: integer;
begin
	{$ifdef DEBUG} writeln ('procedure Tshape.animate'); {$endif}
	if nan>-1 then
		{$ifdef PRINTA}
			writeln ('a= ',an[0]^.ab);
		{$endif PRINTA}
		for i:=0 to nan do 
			an[i]^.go;
end;//\

{----------------perform all animations-----------------}

procedure Tgraph.animate;///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		shape[sn]^.animate;
		{$ifdef PRINTA}
			writeln ('shape: ',sn);
		{$endif PRINTA}
	end;
end;
//\

{-------------------constructors and destructors--------------------}


constructor Tshape.init;///
begin
	{trying to set generic defaults, used especially by
	frocor since some of these features are not needed by fms}
	
	sticky:=false;
	edit:= true;
	show:= true;
	nan:=-1;
	{total:=2;} {f*cking typo}
	color:=30000;

	{just some initializations to prevent the program from crashing, that's} 
	{not to say it doesn't crash anymore if it is sent invalid uds input.}
	ot:=polygon;
	total:=2; {this is the last shape, not the # of shapes}
	x[0]:=0; y[0]:=0;
	x[1]:=0.1; y[1]:=0.1;
	x[2]:=-0.3; y[2]:=-0.5;
	radius:=0.1;
end;//\

destructor Tshape.destruct;///
var i:integer;
begin
	if nan>=0 then begin; {if there is any animation... check to prevend infinite loop}
		for i:=0 to nan do begin
			dispose(an[i]); {dispose all animation records of this object}
		end;
	end;
end;//\

procedure Tgraph.newshape (sn:integer);///
begin
	shape[sn]:=new(Pshape,init);
end;//\


{------------------------methods of shapes--------------------}
{----------------------------draw-----------------------------}
{--------------single object---------------}

procedure Tshape.ograph (var sdlbackendout: text);///
{WTF did ograph stand for}
var i:integer;
begin

if ot=circle then begin///
	writeln (sdlbackendout,'c:',rx[0],',',ry[0],',',rradius,':',color);
end;//\
if (ot=polygon) or (ot=line) then begin///
	for i:=0 to total-1 do begin
		writeln (sdlbackendout, 'l:',rx[i],',',ry[i],',',rx[i+1],',',ry[i+1],':',color);
	end;
	if ot=polygon then begin
		writeln (sdlbackendout, 'l:',rx[total],',',ry[total],',',rx[0],',',ry[0],':',color);
	end;
end;//\
end;//\

{---------all objects----------}
Procedure Tgraph.ograph;///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		if shape[sn]^.show=true then begin
			shape[sn]^.ograph (sock.sdl.backendout);
		end;
	end;
	writeln (sock.sdl.backendout, 'update');
end;

//\


{------------------transformations--------------------}

{Methods for transformations, stretch, spin etc.      }
{These use the transformations.ppu unit.              }

{--------------for each shape--------------}

{These methods transform the shapes through} 
{the transformations.ppu unit if they are  }
{not sticky. Basically these are wrappers  }
{around this unit                          }

procedure Tshape.zoom (zoomby: real);///
var i: integer;
begin
	if sticky=false then begin
		for i:=0 to total do begin
			transform.zoom (x[i],y[i],zoomby);
		end;
		if ot=circle then begin
			transform.zoom (radius, zoomby);
		end;
	end;
end;
//\
procedure Tshape.stretch (xstretch,ystretch: real);///
var i: integer;
begin
	if sticky=false then begin
		for i:=0 to total do begin
			transform.stretch (x[i],y[i],xstretch,ystretch);
		end;
		if ot=circle then begin
			transform.stretch (radius, xstretch, ystretch);
		end;
	end;
end;
//\
procedure Tshape.flip (flipangle:real);///
var i: integer;
begin
	if sticky=false then begin
		for i:=0 to total do begin
			transform.flip (x[i],y[i],flipangle);
		end;
	end;
end;
//\
procedure Tshape.turn (xturn, yturn: integer);///
var i: integer;
begin
	if sticky=false then begin
		for i:=0 to total do begin
			transform.turn (x[i],y[i],xturn,yturn);
		end;
		if ot=circle then begin
			transform.turn (radius,xturn,yturn);
			{would be needed for ellipses}
		end;
	end;
end;
//\
procedure Tshape.spin (turnby: real);///
var i: integer;
begin
	{$ifdef DEBUG} writeln ('Tshape.spin'); {$endif}
	if sticky=false then begin
		for i:=0 to total do begin {UGLY}
			{$ifdef DEBUG} writeln ('point ',i); {$endif}
			transform.spin (x[i],y[i],turnby);
		end;
		if ot=circle then begin
			{$ifdef DEBUG} writeln ('radius'); {$endif}
			transform.spin (radius, turnby);
			{would be needed for ellipses}
		end;
	end;
end;
//\
procedure Tshape.movexy (xmove, ymove: real);///
var i: integer;
begin
	if sticky=false then begin
		for i:=0 to total do begin
			transform.movexy (x[i],y[i],xmove,ymove);
		end;
	end;
end;
//\
procedure Tshape.moveangle (shiftangle, shift: real);///
var i: integer;
begin
	if sticky=false then begin
		for i:=0 to total do begin
			transform.moveangle (x[i],y[i],shiftangle, shift);
		end;
	end;
end;//\


{----------for the whole graph------------}

{These methods just call the requested    }
{transformation for all objects           }

procedure Tgraph.zoom (zoomby: real);///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		shape[sn]^.zoom (zoomby);
	end;
end;
//\
procedure Tgraph.stretch (xstretch, ystretch: real);///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		shape[sn]^.stretch (xstretch, ystretch);
	end;
end;
//\
procedure Tgraph.flip (flipangle:real);///
var sn: integer;
begin	
	for sn:=0 to lastshape do begin
		shape[sn]^.flip (flipangle);
	end;
end;
//\
procedure Tgraph.turn (xturn, yturn: integer);///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		shape[sn]^.turn (xturn, yturn);
	end;
end;
//\
procedure Tgraph.spin (turnby: real);///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		shape[sn]^.spin (turnby);
	end;
end;
//\
procedure Tgraph.movexy (xmove, ymove: real);///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		shape[sn]^.movexy (xmove, ymove);
	end;
end;
//\
procedure Tgraph.moveangle (shiftangle, shift: real);///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		shape[sn]^.moveangle (shiftangle, shift);
	end;
end;
	
//\
procedure Tanysock.perror (const S: string);///
{socket server error procedure}
begin
	writeln (S, SocketError);
	IF SocketError=98 then begin
		writeln ('there is another instance of ocor running');
		writeln ('if not, delete /tmp/ocor-output-uds');
	end;
	halt (100); 
end;//\

{---------------------------------------------------------------}
procedure Tgraph.newgraph;///
BEGIN
	graph.lastshape:=0;
	{free tf memory!!!}
	{MAINMENU:='n';} {set the first main menu choice to N so that nothing is drawn (because shapenr was reset)}
	{is this still necessary?}
	{this shouldn't be needed!!!}
	{WRITELN ('Your old graph has been deleted');}
END;//\

{-----------------------------------------------------------------------}
procedure Tshape.del (todel:integer);///
{delete an object}
var sn: integer;
begin
	graph.lastshape:=graph.lastshape-1;
	for sn:=todel to graph.lastshape do
	shape[sn]:=shape[sn-1];
	{dispose (origin);}
	{delete this very object...}
	{This does not free the memory!!!}
end;//\
	
{------------------------------------------------------------}

Function Tgraph.getresmult: real;///
{Finds the multiplier for x and y that has to be multiplied with any point of the graph}
VAR xresmult, yresmult: Real;
BEGIN
	{get xmin ymin and save them!}
	oldxmin:=xmin; oldymin:=ymin;
	{change the resolution -50 so that there's some space at the sides}
	{$ifdef DEBUG} writeln ('xresmult:=(graph.resolution.x-50) / (xmax-oldxmin);'); {$endif}
	xresmult:=(graph.resolution.x-50) / (xmax-oldxmin);  
	{$ifdef DEBUG} writeln ('yresmult:=(graph.resolution.y-50) / (ymax-oldymin);'); {$endif}
	yresmult:=(graph.resolution.y-50) / (ymax-oldymin); 

	{to prevent stretching the graph, make the smaller multiplier count}
	IF xresmult>yresmult THEN getresmult:=yresmult;
	IF xresmult<=yresmult THEN getresmult:=xresmult;	
END;//\

{---------------------------------}

function Tsresmult.getx: real;///
begin
	getx:=(graph.resolution.x-50)/100;
end;
//\
function Tsresmult.gety: real;///
begin
	gety:=(graph.resolution.y-50)/100;
end;//\

{-----------------------GETRXRY-----------------------------}

procedure Tshape.getrxry; {gets the pixel coordinates for a single shape}///
var i: integer; pxp,pyp: pointprec;
begin
	if sticky=false then begin///
		for i:=0 to total do begin
			pxp:=x[i]-graph.oldxmin; 
			pyp:=y[i]-graph.oldymin; {this line was responsible for bug #1}
			
			rx[i]:=round(pxp*graph.resmult+25+graph.moveby.x);{add 25 to leave space at the sides}
			ry[i]:=round(graph.resolution.y-(pyp*graph.resmult+25+graph.moveby.y)); {flip vertically}
			if ot=circle then begin
				rradius:=round(radius*graph.resmult);
			end;
		end;
	end;//\
	if sticky=true then begin///
		for i:=0 to total do begin
			rx[i]:=round(x[i]*graph.sticky.resmult.x+25);
			ry[i]:=round(y[i]*graph.sticky.resmult.y+25);
			if ot=circle then begin
				rradius:=round(radius*graph.sticky.resmult.y);
				{can't stretch circle yet :-( }
			end;
		end;
	end;//\
end;//\

procedure Tgraph.getrxry; {gets the pixel coordinates for all shapes}///
var sn: integer;
begin
	for sn:=0 to lastshape do begin
		shape[sn]^.getrxry;
	end;
end;
//\

{PROCEDURE ANIMGO (goby: integer);///
{THIS IS A MESS!!!}
{still using transform.pp unit directly}
VAR sn, ant, i: word; {counter vars...}
	b:boolean; {because if then is so dumb}
BEGIN
graph.astep:=graph.astep+goby; {add go by to current step}

FOR sn:=0 to graph.lastshape DO {for all shapes} BEGIN
	//WRITELN ('nan:',shape[sn]^.nan);
	if shape[sn]^.nan>-1 then begin
	{if an animtation has been added so far, otherwise nan=-1.}
	{this check will hopefully fix a nasty bug}
	FOR ant:=0 to shape[sn]^.nan DO BEGIN {for all animations}
		//WRITELN ('astep:',graph.astep);
		//WRITELN ('as:',shape[sn]^.an[ant]^.as);
		IF (((graph.astep) mod (shape[sn]^.an[ant]^.as))=0) THEN {if animating this step...} BEGIN
			{if then sucks}
			if graph.astep DIV shape[sn]^.an[ant]^.as < shape[sn]^.an[ant]^.ao then b:=true;
			if (b=true) or (shape[sn]^.an[ant]^.ao=0) then begin

				{transformations for all animation types... arrgh!}
				IF shape[sn]^.an[ant]^.at=azoom THEN BEGIN 
					if shape[sn]^.ot=circle then transform.zoom (shape[sn]^.radius,shape[sn]^.an[ant]^.ab);
					for i:=0 to shape[sn]^.total do begin
						if shape[sn]^.an[ant]^.ap[i]=true then begin {if this dot is animated}
							transform.zoom (shape[sn]^.x[i],shape[sn]^.y[i],shape[sn]^.an[ant]^.ab);
						end;
					end;
				end;
				{this is ugly. split up stretch procedure} {WORKING!!!}
				IF shape[sn]^.an[ant]^.at=amove THEN BEGIN
					for i:=0 to shape[sn]^.total do begin
						if shape[sn]^.an[ant]^.ap[i]=true then begin
							transform.moveangle (shape[sn]^.x[i],shape[sn]^.y[i],shape[sn]^.an[ant]^.adir,shape[sn]^.an[ant]^.ab);
						end;
					end;
				end;
				IF shape[sn]^.an[ant]^.at=aturn then begin
					for i:=0 to shape[sn]^.total do begin
						if shape[sn]^.an[ant]^.ap[i]=true then begin
							transform.spin (shape[sn]^.x[i],shape[sn]^.y[i],shape[sn]^.an[ant]^.ab);
						end;
					end;
				end;
			end;
						{TODO implement further animations}
		end;
	end;
	end;
end;
END;}
//\

{-----------------Connect to servers+clients--------------------}

{---------------- sdlclient----------------}

{-----------connect-----------}
procedure Tsdlsock.start;///
var addresslength: longint;
begin
	{start sdlclient automatically}
	descriptor:=socket (sdlsockettype, SOCK_STREAM, sdlsockettype);
	if SocketError<>0 then
		perror ('Server : Socket : ');
	path:='/tmp/ocor-output-uds';
	{assign path to socket}
	if not bind (descriptor, path) then
		perror ('Server : Bind : ');
	{start listening}
	If not listen (descriptor, 1)  then
		perror ('Server : Listen : ');
	addresslength:=25; {can't enter directly because pointer is needed}
	{wait for 1 connection}
	accepted:=accept(descriptor, clientaddress, addresslength);
	{create text objects from socket}
	sock2text (accepted,backendin,backendout);
	reset (backendin);
	rewrite (backendout);
end;//\

{---------disconnect---------}
procedure Tsdlsock.disconnect;///
begin
	{delete and close temporary files}
	writeln (sock.sdl.backendout, 'quit');
	shutdown (sock.sdl.descriptor, 2);
	flush (sock.sdl.backendout);
	close (sock.sdl.backendout);
	close (sock.sdl.backendin);
	assign (sock.sdl.backendout,sock.sdl.path); {assign socket file to a test object in order to be able to delete it ... ugly}
	erase (sock.sdl.backendout);
end;//\

{----------------frocor-server-----------------}

{-----------connect-----------}
procedure Tfrocorsock.start;///
begin
	descriptor:=socket(AF_UNIX,SOCK_STREAM,AF_UNIX);
	path:='/tmp/frocor-uds'; {command line option...}
	if not (connect (descriptor,path,ocorin,ocorout)) then
		PError ('Connect to frocor server: ');
	reset (ocorin);
	rewrite (ocorout);
end;//\

{---------disconnect---------}
procedure Tfrocorsock.disconnect;///
begin
	flush (ocorout);
	shutdown (descriptor, 2);
	close (ocorout);
	close (ocorin);
end;
//\


{------------------------frocor commands (frocor protocol)-----------------------}

{---------------animation (in time steps)--------------}

function frocoranimationthread (trashcan: pointer):longint;///
{steps an animation step foreward every x seconds.}
{only used as a thread}
begin
	{$ifdef DEBUG} writeln ('thread'); {$endif}
	{$ifdef DEBUGTHREADS} writeln (getcurrentthreadid); {$endif}
	//frocor.threadid:=getcurrentthreadid; {to make sure main program will be able to terminate me}
	repeat
		{$ifdef DEBUG} writeln ('animating'); {$endif}
		graph.animate;
		{$ifdef DEBUG} writeln ('updating graph'); {$endif}
		frocor.ograph;
		{$ifdef DEBUG} writeln ('good morning'); {$endif}
		shell('usleep 100000');
		{$ifdef DEBUG} writeln ('good night'); {$endif}
	until frocor.turnoff=true;
	//until false=true;
end;//\

{------------------graph-------------------}

procedure Tfrocor.ograph;///
{graphs the objects using only features needed by frocor/fms}
begin
	{$ifdef DEBUG} writeln  ('getting resmult'); {$endif}
	graph.resmult:=graph.getresmult;
	{no sticky stuff needed}
	{$ifdef DEBUG} writeln  ('getting rxry'); {$endif}
	graph.getrxry;
	{$ifdef DEBUG} writeln ('graphing'); {$endif}
	graph.ograph;
end;
//\

{----output errors in protocol if debugging----}

procedure Tfrocor.syntaxerror (description: string);///
begin
	{$ifdef DEBUGERROR}
		writeln (udsline);
		writeln (description);
	{$endif}
end;
//\

{--------------------process frocor protocol imput---------------------}

{-----------split up frocor protocol input-----------}

{----------get section of line----------}

function Tfrocor.nextcolon: string;///
{reads commands up to the next colon and deletes read characters from udsline}
var i: integer;
begin
	i:=1;
	nextcolon:='';
	repeat
		if udsline[i]=':' then break;
		nextcolon:=nextcolon+udsline[i];
		inc(i);
	until (i>length(udsline)); {until eol}
	delete (udsline, 1, i);
end;
//\

{-----split up individual property section-----}

procedure Tfrocor.nextoperation (var sproperty: string; var operation: char; var props: string);///
{gets the property to be changed and the operator applied to it. leaves only 
 value property shall be changed to in props}
var i: integer;
begin
	i:=1;
	sproperty:='';

	{get sproperty and operation: sproperty=all characters before operation}
	repeat
		if props[i] in ['=','+','-','*','/'] then break;
		sproperty:=sproperty+props[i];
		inc(i);

		{$ifdef DEBUG} writeln ('sproperty (constructing):',sproperty); {$endif}

	until (i>length(props)); {until eol}

		operation:=props[i]; 

	delete (props, 1, i);

	{$ifdef DEBUG}///
		writeln ('Tfrocor.nextoperation');
		writeln ('operation:',operation);
		writeln ('sproperty:',sproperty);
	{$endif}//\
end;
//\

{---------------apply opperators to property------------}

function Tfrocor.modifyproperty (originalvalue: real; operation: char; value: real): real;///
{changes a given property, depending on whether operator is =, +, -, * or /}
{can be called both as function and procedure}
begin
	if operation='=' then
		modifyproperty:=value;
	if operation='+' then
		modifyproperty:=originalvalue+value;
	if operation='-' then
		modifyproperty:=originalvalue-value;
	if operation='*' then
		modifyproperty:=originalvalue*value;
	if operation='/' then
		modifyproperty:=originalvalue/value; 
end;
//\

{------set property if it is to be set to a number------}

procedure Tfrocor.propertynumber (sproperty: string; operation: char; value: real; sn: integer);///
var i, valerror: integer;
begin
	if sproperty='n' then begin///
		shape[sn]^.total:=round(modifyproperty (shape[sn]^.total, operation, value));
		dec (shape[sn]^.total); {ocor: total = last shape, frocor-protocol: total=number of points}
		{this dec is in the wrong place!!! apply whenever reading n property!}
		{forgot begin and end, caused bug...}
	end;//\
	if sproperty='r' then///
		shape[sn]^.radius:=modifyproperty (shape[sn]^.radius, operation, value);
//\
	if sproperty='c' then///
		shape[sn]^.color:=round (modifyproperty (shape[sn]^.color, operation, value));
//\
	if sproperty[1]='x' then begin///
		delete (sproperty, 1, 1); {number of coordinate}
		val (sproperty, i, valerror);
		shape[sn]^.x[i]:=modifyproperty (shape[sn]^.x[i], operation, value);
		{$ifdef DEBUG}///
			writeln ('x property given:');
			writeln (sproperty);
			writeln ('i:',i);
			writeln ('shape ',sn,' x',i,': ',shape[sn]^.x[i]);
		{$endif DEBUG}//\
	end;
//\
	if sproperty[1]='y' then begin///
		delete (sproperty, 1, 1); {number of coordinate}
		val (sproperty, i, valerror);
		shape[sn]^.y[i]:=modifyproperty (shape[sn]^.y[i], operation, value);
	end;
//\
	if sproperty='z' then///
		shape[sn]^.zoom(value);
//\
	if sproperty='a' then begin///
		{$ifdef READLN}
		writeln ('sproperty=a');
		readln;
		{$endif READLN}
		with shape[sn]^ do begin
			if nan<0 then begin///
				{seperate procedure!!!}
				shape[sn]^.an[0]:=new (Panim, init); {init!}
				//shape[sn]^.an[0]:=new (Panim);
				shape[sn]^.an[0]^.myshape:=shape[sn]; 
				nan:=0;
				an[0]^.at:=aturn;
				{animate all points}
			end;//\
			an[0]^.ab:=modifyproperty (an[0]^.ab, operation, value);
		{$ifdef READLN}
		writeln ('sproperty=a DONE');
		readln;
		{$endif READLN}
		{delete animation if a set to 0!}
		if shape[sn]^.an[0]^.ab=0 then begin
			dispose (shape[sn]^.an[0]);
			shape[sn]^.nan:=-1;
		end;
		end;
	end;//\
end;
//\

{---set property if it is to be set to a char/string---}

procedure Tfrocor.propertynonumber (props: string; sproperty: string; sn: integer);	///
{sets properties that are no numbers}
var mesgstring: string;
begin
	if sproperty='t' then begin///
		if props[1]='p' then
			shape[sn]^.ot:=polygon;
		if props[1]='l' then
			shape[sn]^.ot:=line;
		if props[1]='c' then
			shape[sn]^.ot:=circle;
		if not (props[1] in ['p','l','c']) then begin
			mesgstring:='FROCOR SYNTAX: PROPERTIES: dont know a shape type called: '+props;
			syntaxerror (mesgstring);
		end;
	end//\
	else begin///
		mesgstring:='FROCOR SYNTAX: PROPERTIES: no number: '+props;
		syntaxerror (mesgstring);
	end;//\
end;//\

{-------------------------set a property-----------------------}
{  ------------process single :property: section-------------  }

procedure Tfrocor.property (sn:integer; props: string);///
var 	///
	operation: char; {operator applied to the property: =+-/*}
	{this should be called operator, but can't!}
	sproperty: string; {property without operator and value}
	value: real; {value the property is set to, multiplied with etc.}
	valerror: integer; {used to check whether string is number}
	{ifdef DEBUG} {can't do that: mesgstring assigned independendly of DEBUG}
	mesgstring: string; 
	{endif DEBUG}//\
begin
	{props = property string}
	{$ifdef DEBUG} writeln (props); {$endif}
	{$ifdef READLN} readln; {$endif}

	{initializations}///
	operation:=' ';
	sproperty:='';
	value:=0;//\

	{get property and operation, may need to be rewritten: base on characters, not position}
	nextoperation (sproperty, operation,props);

	{only value or shape.ot left}

	{$ifdef DEBUG}///
		writeln ('operation:',operation);
		writeln (sproperty);
	{$endif}
//\

	{check for errors}
	if not (operation in ['=','+','-','*','/']) then begin///
		{no valid operator given}
		mesgstring:='FROCOR SYNTAX: PROPERTIES: unknown operator: '+operation;
		syntaxerror (mesgstring);
	end
//\
	else begin {operator valid}///
		if not (sproperty[1] in ['t','n','x','y','r','c','z','a']) then begin///
			{no valid property given}
			mesgstring:='FROCOR SYNTAX: PROPERTIES: unknown property: '+sproperty[1];
			syntaxerror (mesgstring);
		end//\
		else begin {protocol input ok so far}///
			{is the value property is to be set to a number?}
			val (props,value,valerror);
			if valerror<>0 then begin
				{value can only be type of object or invalid}
				propertynonumber (props, sproperty, sn);
			end
			else begin
				{set property to value, add, etc.}
				propertynumber (sproperty, operation, value, sn);
			end;
		end;//\
	end;//\
end;
//\

{-------process all property sections of a line-------}

procedure Tfrocor.getproperties (sn:integer);///
var propertystring: string;
begin
	{$ifdef READLN} readln; {$endif}

	{----------------}
	repeat
		propertystring:=nextcolon; {should also recognize eol now}
		if propertystring='lock' then
			graph.update:=false
		else begin
			if propertystring='unlock' then
				graph.update:=true
			else
				property (sn, propertystring); {normal property}
		end;
	until udsline=''; {until whole line has been processed}
	{----------------}

	{$ifdef DEBUG} ///
	writeln ('shape ',sn,': radius: ',shape[sn]^.radius); 
	if shape[sn]^.ot=circle then
		writeln ('shape ',sn,': type: circle'); 
	if shape[sn]^.ot=polygon then
		writeln ('shape ',sn,': type: polygon'); 
	if shape[sn]^.ot=line then
		writeln ('shape ',sn,': type: line'); 
	writeln ('shape ',sn,': color: ',shape[sn]^.color); 
	{$endif}//\
end;
//\

{---------------create a new shape-------------------}

procedure Tfrocor.newshape (var sn: integer);///
{create a new shape if told by frocor-player}
begin
	if sn<=graph.lastshape then begin {if reseting existing object}///
		writeln ('reseting of existing objects not implemented yet');
		dispose (shape[sn],destruct); {free memory}
		graph.newshape (sn);
	end;
//\
	if sn>graph.lastshape then begin {if creating new object}///
		{if sn is too high, just make it lastshape+1}
		graph.lastshape:=graph.lastshape+1;
		sn:=graph.lastshape;
		graph.newshape (sn);
		{$ifdef DEBUG}
		writeln ('graph.lastshape=',graph.lastshape);
		{$endif}
	end;//\
end;
	//\

procedure Tfrocor.processcommands;///
{-----------process a line of frocor protocol input------------}
var	///
	command: string;
	sn: integer;
	tmpstring: string;
	valerror: integer;//\
begin
	{initializations}///
	sn:=-1;
	tmpstring:='';//\

	{ n or o?}
	command:=udsline[1];
	delete (udsline, 1, 2); {delete n or o and ':'}

	if (command[1]<>'o') and (command[1]<>'n') then syntaxerror ('FROCOR SYNTAX ERROR: first character needs to be o or n. Not processing line.')

	else///
	begin
		{$ifdef READLN} readln; {$endif READLN}

		{get object number as string:}
		tmpstring:=nextcolon;

		{$ifdef DEBUG} writeln (tmpstring); {$endif}
		{$ifdef READLN} readln; {$endif READLN}
		
		{now only properties are left in udsline}

		{get object number as integer:}
		sn:=0;
		val (tmpstring, sn, valerror);	
		if valerror<>0 then syntaxerror ('FROCOR SYNTAX ERROR: no correct object number given. Trying to ignore.');

		{$ifdef READLN} readln; {$endif}

		if sn<0 then begin
			syntaxerror ('FROCOR SYNTAX ERROR: cannot process line: no shape number given');
		end
		else begin///

			if command='n' then begin
				newshape(sn);
			end;

			{no action needed for command 'o'}
	
	
			{$ifdef READLN} readln; {$endif}
			{$ifdef DEBUG} writeln (udsline); {$endif}

			{READ PROPERTIES}
			{- but only if there are any...}
			if length(udsline)>0 then
				getproperties (sn);
		end;

				//\
	end;//\
end;
		
//\
	
{--------------------read frocor input-----------------------}

procedure Tfrocor.readcommands;///
var nothing: pointer; {arguments passed to frocoranimationthread}
begin
	
	{GetMem(clonestack,stacksize);}
	readln (sock.frocor.ocorin, udsline);

	{TODO: check for protocol, somehow}
	{$ifdef WRITEFROCORINPUT} 
		writeln ('frocor: # ',udsline);
	{$endif WRITEFROCORINPUT}
	{$ifdef DEBUG} writeln ('procol: ',udsline); {$endif}

	{clone (@animate, Pointer(longint(clonestack)+stacksize), cloneflags, clonestack);}
	nothing:=nil;
	beginthread(@frocoranimationthread);
	{beginthread needs a pointer to arguments to be passed to frocoranimationthread, so we just create a 0 pointer}

	{TODO: check for eof if that's possible}
	while (true) do begin
		readln (sock.frocor.ocorin, udsline);

		{$ifdef WRITEFROCORINPUT} 
			writeln ('frocor: # ',udsline);
		{$endif WRITEFROCORINPUT}

		if udsline='quit' then break;

		{catch lock and unlock}
		if udsline='lock' then graph.update:=false
		else begin
			if udsline='unlock' then graph.update:=true
			else processcommands; {process this line}
		end;

		if graph.update=true then {if not locked}
			ograph; {update graph}
	end;
end;
		//\

//MAIN///
{      //|//|//|//|//|//|//|//|//|\\|\\|\\|\\|\\|\\|\\|\\|      }
{    //|//|//|//|//|//|//|//|//|//|\\|\\|\\|\\|\\|\\|\\|\\|\    }
{  //|//|//|//|//|//|//|//|//|/######\\|\\|\\|\\|\\|\\|\\|\\|\  }
{//|//|//|//|//|//|//|//|//|############\\|\\|\\|\\|\\|\\|\\|\\|}
{===============================MAIN============================}


BEGIN

graph.init;
frocor.init;

sock.sdl.start; {connect with sdl client}
sock.frocor.start; {connect with frocor server}

	{$ifdef DEBUG}
	WRITELN ('connected');
	{$endif}

{----------------------------}
      frocor.readcommands;
{----------------------------}


{$ifdef DEBUGTHREADS}
//writeln (frocor.threadid);
{$endif DEBUGTHREADS}
//killthread (frocor.threadid);
{WTF isn't this working?}

frocor.turnoff:=true;

sock.sdl.disconnect; {disconnect}
sock.frocor.disconnect; {disconnect}


{free allocated memory}
graph.destruct; {memory allocated by graph and shape}

END.//\//\
