UNIT transformations;

interface
USES MATH; {does the database still need to use math?}

type

Ttransform = object
	procedure stretch (var x, y:real; xstretch, ystretch: Real);
	procedure stretch (var radius: real; xstretch, ystretch: Real);
	procedure flip (var x, y: real; direction: real);
	procedure flip (var radius: real; direction: real);
	procedure zoom (var x, y: real; stretchby: real);
	procedure zoom (var radius: real; stretchby: real);
	procedure turn (var x,y: real; xturn, yturn: integer);
	procedure turn (radius: real; xturn, yturn: integer);
	procedure spin (var x,y: real; turnby: Real);
	procedure spin (var radius: real; turnby: Real);
	procedure movexy (var x,y: real; xshift, yshift: Real);
	procedure movexy (var radius: real; xshift, yshift: Real);
	procedure moveangle (var x,y: real; shiftangle, shift: Real);
	procedure moveangle (var radius: real; shiftangle, shift: real);
end;

var transform: Ttransform;

implementation

{----------------------------------------------------------}
{stretch, flip, zoom}
{flip using lines having any angle+position, not just axis? points?}
PROCEDURE Ttransform.stretch (var x, y:real; xstretch, ystretch: Real);
BEGIN
	y:=ystretch*y;
	x:=xstretch*x;
END;

PROCEDURE Ttransform.stretch (var radius: real; xstretch, ystretch: Real);
begin
	radius:=radius*xstretch;
	{for now, a circle remains a circle; it zooms with x-stretch}	
end;

procedure Ttransform.flip (var x, y: real; direction: real);
begin
	if direction=90 then stretch (x, y, 1,-1); {vertical}
	if direction=0 then stretch (x, y, -1,1); {horizontal}
end;

procedure Ttransform.flip (var radius: real; direction: real);
begin
end;

procedure Ttransform.zoom (var x, y: real; stretchby: real);
begin
	stretch (x,y,stretchby, stretchby)
end;

procedure Ttransform.zoom (var radius: real; stretchby: real);
begin
	stretch (radius, stretchby, stretchby);
end;

{-----------------------------------------------------------------------}
{turning}
procedure Ttransform.turn (var x,y: real; xturn, yturn: integer);
{turns by 90 degrees. changed interface: (1, -1) against clock, (-1,1) with clock}
var tmpx: real;
begin
	tmpx:=x;
	x:=y*yturn;
	y:=tmpx*xturn;
end;


procedure Ttransform.turn (radius: real; xturn, yturn: integer);
begin
	{don't turn circles}
	{however, later turn elipses}
end;

{-----------------------------------------------------------------------}
{also turns the graph, for right now only around (0,0). turns around any angle.}
{however, does not turn for more than 90 degrees. also, probably because of degree/radian conversion,
the number of degrees in a full angle is 4*360 degrees!!!}
{seems to no longer be true}

PROCEDURE Ttransform.SPIN (var x,y: real; turnby: Real);
VAR	pox, poy: real;
	turnhypot, turnarctan: real;
	{sqrpox, sqrpoy: real;}
	bothturnangles: real;
	oquadrant, quadrant: integer;
BEGIN
	
	POX:=x;
	POY:=y;
	{the actual formula}
	turnhypot:=sqrt(sqr(POX)+sqr(POY));
	{sqrpox:=sqr(pox);
	sqrpoy:=sqr(poy);
	turnhypot:=sqrt(sqrpox+sqrpoy);}
	{check for quadrant}
	if (pox>0) and (poy>0) then oquadrant:=0;
	if (pox<0) and (poy>0) then oquadrant:=1;
	if (pox<0) and (poy<0) then oquadrant:=2;
	if (pox>0) and (poy<0) then oquadrant:=3;

	{now get the points.}
	{depending on the location on the graph, sin or cosine is used}
	{if location is not checked, the point will move back and forth when changing +/-.}


	{$ifdef DEBUG} writeln ('transformation unit: spinning: dividing now...'); {$endif}
	case oquadrant of

	0, 2:	begin 
		{intercept if pox or poy are 0 to prevent division by 0}
		if (pox=0) or (poy=0) then 
			turnarctan:=0
		else
			turnarctan:=arctan(abs(POY)/abs(POX)); {take absolute value, add +- later}
		x:=turnhypot*(cos(turnarctan+degtorad(turnby)));
		y:=turnhypot*(sin(turnarctan+degtorad(turnby))); end;

	1, 3:	begin 
		if (pox=0) or (poy=0) then 
			turnarctan:=0
		else
			turnarctan:=arctan(abs(POX)/abs(POY));
		x:=turnhypot*(sin(turnarctan+degtorad(turnby)));
		y:=turnhypot*(cos(turnarctan+degtorad(turnby))); end;
	end;
	{$ifdef DEBUG} writeln ('transformation unit: spinning: division done!'); {$endif}

	{now get the points.}
	{depending on the location on the graph, sin or cosine is used}
	{if location is not checked, the point will move back and forth when changing +/-.}

	{make result +tive}
	x:=abs(x);
	y:=abs(y);


	{now add original +tive/-tive back in} 		
	IF (POX<0) THEN x:=-1*x;
	IF (POY<0) THEN y:=-1*y;

	{bothturnangles is the summ of the angles before turning and the one it is turned by}
	if turnby>0 then bothturnangles:=(radtodeg(TURNARCTAN)+TURNBY);
	if turnby<0 then bothturnangles:=(radtodeg(turnarctan)+turnby-90);

	{find out if result positive or negative}
	{so far, never occurs --> bug --> why???}


	IF (bothturnangles > 90) OR (bothturnangles < -90) THEN {+- may have changed}
	BEGIN
		{get new sector}
		if (x>0) and (y>0) then quadrant:=0;
		if (x<0) and (y>0) then quadrant:=1;
		if (x<0) and (y<0) then quadrant:=2;
		if (x>0) and (y<0) then quadrant:=3;
		if bothturnangles>0 then begin
			case quadrant of
				0,2: x:=-1*x;
				1,3: y:=-1*y;
			end;
		end;
		if bothturnangles<0 then begin {if turned with clock}
			case quadrant of
				0,2: y:=-1*y;
				1,3: x:=-1*x;
			end;
		end;
	END;
	

END;
				

PROCEDURE Ttransform.SPIN (var radius: real; turnby: Real);
begin
end;

{-------------------------------------------------------------------------}
{move}
{moves the selected objects rather than the view}
{move by given x and y values:}
PROCEDURE Ttransform.movexy (var x,y: real; xshift, yshift: Real);
BEGIN
	x:=x+xshift;
	y:=y+yshift;
END;


PROCEDURE Ttransform.movexy (var radius: real; xshift, yshift: Real);
BEGIN
	{don't move radius}
END;


{move by given value in direction of given angle}
{angle is 0 pointing right (on x axis)}
procedure Ttransform.moveangle (var x,y: real; shiftangle, shift: Real);
{this needs much testing still...}
{order of shiftangle and shift parameters changed 11-02-04}
var xshift, yshift:real;
	quadrant: integer;
BEGIN
	{convert angle to radian}
	shiftangle:=degtorad(shiftangle);
	{get the angle whose co(sine) is xshift/yshift}
	quadrant:=trunc (shiftangle/(0.5*pi)); 
	if odd(quadrant) then shiftangle:={180}pi-(shiftangle - quadrant*pi); {like mod for real...}
	if not odd(quadrant) then shiftangle:=shiftangle - quadrant*pi;
	{get positive xshift and yshift}
	xshift:=shift*cos(shiftangle); 
	yshift:=shift*sin(shiftangle);
	{add +/- depending on quadrant}
	case quadrant of
		{0:nothing}
		1: xshift:=xshift*(-1);
		2: begin xshift:=xshift*(-1); yshift:=yshift*(-1); end;
		3: yshift:=yshift*(-1);
	end;
	movexy (x,y,xshift,yshift);
END;

PROCEDURE Ttransform.moveangle (var radius: real; shiftangle, shift: real);
begin
	{don't move radius}
end;

end.
