{define DEBUG}
{$LINKLIB c}
UNIT GRAPHSDL;

interface
uses SDL, SDL_video; 
procedure initsdl;
procedure sdlline (xa, ya, xb, yb, sdlcolor: integer);
procedure sdlline (xa, ya, xb, yb: integer);
procedure sdlcircle (x, y, radius, sdlcolor: integer);
procedure sdlcircle (x, y, radius: integer);
procedure sdlpixel (x,y,sdlcolor: integer);
procedure sdlpixel (x,y: integer);
procedure updatesdlscreen;
procedure clearsdl;


implementation

const
	width=500;
	height=500;

	//width=640; 
	//height=480;
	colordepth = 16;
	defaultcolor = 30000;
type
	pixel = integer; 
	TpixelBuf=Array [0..height-1, 0..width-1] of Pixel;
var
	screen: PSDL_Surface;



procedure clearsdl;
var x,y: integer;
begin
	for x:=0 to width-1 do begin
		for y:=0 to height-1 do begin
			Tpixelbuf(screen^.pixels^)[y,x]:=0;
		end;
	end;
end;

procedure initsdl;
begin
	SDL_Init (SDL_INIT_VIDEO);
	screen:= SDL_SetVideoMode (width, height, colordepth, SDL_SWSURFACE);
   	if screen = nil then
   	Begin
   	    Writeln ('Couldn''t initialize video mode at ', width, 'x',
                height, 'x', colordepth, 'bpp') ;
       		Halt(1)
   	end ;
	SDL_locksurface (screen);
end;

procedure sdlline (xa, ya, xb, yb, sdlcolor: integer);
var
slope: real;
i: integer;
newy, newx: integer;
begin
	{larger value -->xb. It doesn't matter in which direction the line is drawn...}
	if (abs(yb-ya)>abs(xb-xa)) {steep slope/horizontal}then {x depends on y}
	begin

		{for the line to look nicer, x will depend on y}
		{$ifdef DEBUG}
		writeln ('x depends on y');
		{$endif}
		if ya>yb then begin {make ya<yb}
			i:=xb;
			xb:=xa;
			xa:=i;
			i:=ya;
			ya:=yb;
			yb:=i;
		end;
		slope:=(xb-xa)/(yb-ya);
		for i:=ya to yb do begin
			if (i<height-1) and (i>0) then begin
				newx:=round(xa+(i-ya)*slope);
				if (newx<width-1) and (newx>0) then begin
					Tpixelbuf(screen^.pixels^)[i,newx]:=sdlcolor;
				end;
			end;
		end;
	end
	{if just drawing a dot - otherwise it'll crash}
	else begin
		if (xa=xb) and (ya=yb) then begin
			if (xa<height-1) and (xa>0) then begin
				if (ya<height-1) and (ya>0) then begin
					Tpixelbuf(screen^.pixels^)[ya,xa]:=sdlcolor;
				end;
			end;
		end
	
		else begin
			{$ifdef DEBUG}
			writeln ('y depends on x');
			{$endif}
			if xa>xb then begin
				i:=xb;
				xb:=xa;
				xa:=i;
				i:=ya;
				ya:=yb;
				yb:=i;
			end;
			slope:=((yb-ya)/(xb-xa));
			for i:=xa to xb do begin
				if (i<width-1) and (i>0) then begin
					newy:=round(ya+(i-xa)*slope);
					if (newy<height-1) and (newy>0) then
						Tpixelbuf(screen^.pixels^)[newy,i]:=sdlcolor; {get rid of that 30000}
				end;
			end;
		end;	
	end;
end;

{legacy wrapper: if no color provided}
procedure sdlline (xa, ya, xb, yb: integer);
begin
	sdlline (xa, ya, xb, yb, defaultcolor);
end;



procedure sdlcircle (x, y, radius, sdlcolor: integer);
var i: integer;
var newy: integer;
begin
	for i:=-1*radius to radius do begin
		{if the sqr of a -tive number is not taken correctly, your fpc is too old!}
		if (x+i<width-1) and (x+i>0) then begin
			newy:=round(y+sqrt(sqr(radius)-sqr(i)));
			if (newy<height-1) and (newy>0) then
				Tpixelbuf(screen^.pixels^)[newy,x+i]:=sdlcolor;
			newy:=round(y-sqrt(sqr(radius)-sqr(i)));
			if (newy<height-1) and (newy>0) then
				Tpixelbuf(screen^.pixels^)[newy,x+i]:=sdlcolor;
		end;
		{the circle won't win a beauty contest, because there are a max of 2 y for 1 x}
	end;
end;


procedure sdlcircle (x, y, radius: integer);
begin
	sdlcircle (x, y, radius, defaultcolor);
end;

procedure sdlpixel (x: integer; y:integer; sdlcolor:integer);
begin
	Tpixelbuf(screen^.pixels^)[x,y]:=sdlcolor;
end;

procedure sdlpixel (x: integer; y:integer);
begin
	sdlpixel (x,y,defaultcolor);
end;


procedure updatesdlscreen;
begin
	SDL_unlocksurface (screen);
	SDL_updaterect (screen,0,0,0,0);
	SDL_locksurface (screen);
end;

end.
