// with help from http://www.linuxgazette.com/issue47/bueno.html
/* client */
/* receives from tcp and writes to uds */

#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <errno.h>
#include <string.h>
#include <pthread.h>
#include "tcp.h"

using namespace std;



//global variables
	struct sockaddr_in tcp_address;
	char hostip[64];
    int tcp_client_socket;
    int uds_client_socket;
	int uds_server_socket;
    const int bufsize = 1024;


void resolveaddress(char *argv[])
{
	// resolve to ip address

	struct hostent *hpaddr;
	cout << "host: "<<argv[optind+1] <<endl;
	hpaddr = gethostbyname(argv[optind+1]);

	if(!hpaddr){
	cout << "error resolving address. exiting..." << endl;
	exit (-1);
	}

	// from resolveip.cpp
	struct in_addr in;
	memcpy((char*) &in.s_addr, (char*) *hpaddr->h_addr_list, sizeof (in.s_addr));

	strcpy(hostip,inet_ntoa(in));
	#ifdef debug_mode
		cout << "ip: " << hostip << endl;
	#endif // debug_mode
}


void *readuds (void *ptr)
	//CONTINUE HERE!!!!
	//change all tcp_client_socket etc.!!!
{
	char readudsline[bufsize];
	do{
		int i=-1,j;
		do{
			  i++;
			  j=read(uds_client_socket, readudsline+i, 1);
		} while(i<bufsize-1 && readudsline[i]!='\n' && j==1);
		readudsline[i+1]='\0'; 

		cout << readudsline << endl;
		write(tcp_client_socket,readudsline,strlen(readudsline));
	}while (strcmp(readudsline,"quit\n"));
}




void readtcp ()
{
		char readtcpline[bufsize];
		do{
		int i=-1,j;
		do{
		  i++;
		  j=read(tcp_client_socket, readtcpline+i, 1);
		} while(i<bufsize-1 && readtcpline[i]!='\n' && j==1);
		readtcpline[i+1]='\0'; 

		cout << readtcpline << flush;
		write(uds_client_socket,readtcpline,strlen(readtcpline));
		}while (strcmp(readtcpline,"quit\n"));
}




int main(int argc,char *argv[])
{


   //get command line args!

   if(argc<3){ //got enough args?
   	cout << "usage: " << argv[0] << " uds-file server [-P port]" << endl;
	return -1;
   }


   tcp_address.sin_port=htons (FROCOR_PORT); //default, can be overridden by command line args

   int cmdloption; //actually, we use this as char
   while ((cmdloption=getopt(argc,argv,"P:p:h")) != EOF)
   {
	   switch (cmdloption)
	   {
		   case 'p':
		   case 'P':
			   {int tmpportnr;
			   tmpportnr=atoi (optarg);
			   tcp_address.sin_port = htons (tmpportnr);
			   cout << "Port: " << tmpportnr << endl;}
			   break;
		   case 'h':
				cout << "usage: " << argv[0] << " [-P Port] uds-file " << endl;
				return 0;
				break;
	   }
   }

	//cout << "Port: " << tcp_address.sin_port << endl; 

	resolveaddress (argv);


   char line[bufsize];
   
   //create socket
   
   if ((tcp_client_socket = socket(AF_INET,SOCK_STREAM,0)) < 1)
   {
     cout << "creating tcp socket failed. exiting..." << endl;
     cout << "error: " << strerror(errno) << endl;
     return -1;
   }


   

   tcp_address.sin_family = AF_INET;


   inet_pton(AF_INET,hostip,&tcp_address.sin_addr);
   
   if (connect(tcp_client_socket,(struct sockaddr *)&tcp_address,sizeof(tcp_address))==0)
   {
     cout << "connected to server " << inet_ntoa(tcp_address.sin_addr) << endl;
   }
   else
   {  
     cout << "connection to server failed. exiting..." << endl;
     cout << "error: " << strerror(errno) << endl;
     return -1;
   }
   
   // tcp_socket connected to server
   // let's get the uds server ready (from frocor.cpp)
   
   unlink(argv[optind]); // which is the udsfile
   uds_server_socket = socket(AF_UNIX, SOCK_STREAM, 0);
   socklen_t uds_addrlen;

   struct sockaddr_un uds_server_address,uds_client_address; // address, client address
   uds_server_address.sun_family=AF_UNIX;
   strcpy(uds_server_address.sun_path, argv[optind]);

   if(bind(uds_server_socket,(struct sockaddr *)&uds_server_address,
   		strlen(uds_server_address.sun_path)+sizeof(uds_server_address.sun_family))<0)
   {
	cout << "binding uds failed. exiting..." << endl;
	cout << "error: " << strerror(errno) << endl;
        return -1;
   }

   // geh horch
   if(listen(uds_server_socket,1))
   {
	cout << "uds listening failed. exiting..." << endl;
	cout << "error: " << strerror(errno) << endl;
        return -1;
   }
   uds_addrlen=sizeof(uds_client_address);
   uds_client_socket=accept(uds_server_socket,
   			(struct sockaddr *)&uds_client_address, &uds_addrlen);
   if(uds_client_socket<0)
   {
	cout << "uds accept failed. exiting..." << endl;
	cout << "error: " << strerror(errno) << endl;
        return -1;
   }
   
   // uds socket connected to client
   
   // protocol negotiation
   int pmesglen=strlen("protocol uds2tcp\n");
   // step 1: server sends "protocol uds2tcp"
   read(tcp_client_socket,line,pmesglen);
   line[pmesglen]='\0';
   if(strcmp(line,"protocol uds2tcp\n"))
   	cout << "warning: server sent " << line << " -- protocols may not comply" << endl;
   // step 2: client sends "protocol tcp2uds"
   write(tcp_client_socket,"protocol tcp2uds\n",pmesglen);
   // negotiation finished     


   //the actual work... {
   
   //read from uds
   pthread_t readudsthread;
   {int crap;
   pthread_create ( &readudsthread, NULL, readuds, (void*) crap);}

   //read from tcp
   readtcp();

   // }
  
   
   close(uds_client_socket);
   close(uds_server_socket);
   
   // protocol negotiation
   
   int qmesglen=strlen("tcp2uds quit\n");
   // step 1: client sends "tcp2uds quit - now twice to make sure server gets it" 
   write(tcp_client_socket,"tcp2uds quit\n",qmesglen);
   write(tcp_client_socket,"tcp2uds quit\n",qmesglen);
   // step 2: server sends "uds2tcp quit" 
   read(tcp_client_socket,line,qmesglen);
   line[qmesglen]='\0';
   if(strcmp(line,"uds2tcp quit\n"))
   	cout << "warning: server sent " << line << " -- protocols may not comply" << endl;
   
   
   // negotiation finished
   
   close(tcp_client_socket);

}
