// with help from http://www.linuxgazette.com/issue47/bueno.html
/* server */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <sys/un.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <errno.h>
#include <string.h>
#include <pthread.h>
#include "tcp.h"


using namespace std;



   const int bufsize = 1024;
   int tcp_server_socket,tcp_client_socket;
   int uds_client_socket, uds_addrlen;
   int serverquit=0; //boolean: are we quitting?



void *readtcp(void *ptr)
{
	char readtcpline[bufsize];
	do{
			int i=-1,j;
			do{
					i++;
					j=read(tcp_client_socket,readtcpline+i,1);
			} while (i<bufsize-1 && readtcpline[i]!='\n' && j==1);
			readtcpline[i+1]='\0';
			cout << readtcpline << endl;
			write (uds_client_socket,readtcpline,strlen(readtcpline));
	} while (serverquit==false);
	/* problem: currently, the line is still read by this function once  when serverquit
	 * ==true, therefore we need to enter tcp2uds quit twice in order for the server
	 * to understand it is to quit... we'll survive it ;-). */
	cout << "readtcp thread quits" << endl;
}

void readuds()
{
   char readudsline[bufsize];
   do{
      int i=-1,j;
      do{
		i++;
		j=read(uds_client_socket,readudsline+i,1);
      } while(i<bufsize-1 && readudsline[i]!='\n' && j==1);
      readudsline[i+1]='\0'; 
      cout << readudsline << endl;
      write(tcp_client_socket,readudsline,strlen(readudsline));
   } while(strcmp(readudsline,"quit\n")); 
}

int main(int argc, char *argv[])
{

   if(argc<2)
   {
   	cout << "usage: " << argv[0] << " [-P Port] uds-file " << endl;
	return 0;
   }  

   socklen_t tcp_addrlen;
   char line[bufsize];
   struct sockaddr_in tcp_address;
   
   if ((tcp_server_socket = socket(AF_INET,SOCK_STREAM,0)) < 1){
     cout << "creating tcp socket failed. exiting..." << endl;
     cout << "error: " << strerror(errno) << endl;
     return -1;
   }
   tcp_address.sin_family = AF_INET;
   tcp_address.sin_addr.s_addr = INADDR_ANY;
   tcp_address.sin_port=htons (FROCOR_PORT); //can be overridden by command line args


   int cmdloption; //actually, we use this as char
   while ((cmdloption=getopt(argc,argv,"P:p:h")) != EOF)
   {
	   switch (cmdloption)
	   {
		   case 'p':
		   case 'P':
			   {int tmpportnr;
			   tmpportnr=atoi (optarg);
			   tcp_address.sin_port = htons (tmpportnr);}
			   break;
		   case 'h':
				cout << "usage: " << argv[0] << " [-P Port] uds-file " << endl;
				return 0;
				break;
	   }
   }

   if (bind(tcp_server_socket,(struct sockaddr *)&tcp_address,sizeof(tcp_address)) != 0)
   {
   	cout << "binding tcp socket failed. exiting..." << endl;
	cout << "error: " << strerror(errno) << endl;
	return -1;
   }       
   // now we can listen
   
   if (listen(tcp_server_socket,3)) // 3 is the queue length
   {
   	cout << "listen failed. exiting..." << endl;
	cout << "error: " << strerror(errno) << endl;
	return -1;   
   }
         
   tcp_addrlen = sizeof(struct sockaddr_in);
   
   tcp_client_socket = accept(tcp_server_socket,(struct sockaddr *)&tcp_address,&tcp_addrlen);
   // we have a client now!
   if (tcp_client_socket > 0){
      cout << "client " << inet_ntoa(tcp_address.sin_addr) << " connected!" << endl;
   }
   
   // tcp is ready, let's open our uds client socket
   // from testudsc.cpp
   
   sockaddr_un uds_address;
   
   uds_client_socket=socket(AF_UNIX,SOCK_STREAM,0);
   uds_address.sun_family=AF_UNIX;
   //strcpy(uds_address.sun_path, argv[1]); 
   cout << optind << endl;
   strcpy(uds_address.sun_path, argv[optind]); //optind is the number of command line argument without leeding dash -
   uds_addrlen=strlen(uds_address.sun_path)+sizeof(uds_address.sun_family); 
   if(connect(uds_client_socket,(struct sockaddr *)&uds_address,uds_addrlen))
   {
   	cout << "connecting to uds failed. exiting..." << endl;
   	cout << "error: " << strerror(errno) << endl;
   	return -1;
   }
   
   // protocol negotiation
   int pmesglen=strlen("protocol uds2tcp\n");
   // step 1: server sends "protocol uds2tcp"
   write(tcp_client_socket,"protocol uds2tcp\n",pmesglen);
   // step 2: client sends "protocol tcp2uds"
   read(tcp_client_socket,line,pmesglen);
   line[pmesglen]='\0';
   if(strcmp(line,"protocol tcp2uds\n"))
   	cout << "warning: client sent " << line << " -- protocols may not comply" << endl;   
   // negotiation finished


   //the actual work... {
   
   //read from tcp, write to uds:
   pthread_t readtcpthread;
   {int crap;

   pthread_create ( &readtcpthread, NULL, readtcp, (void*) crap);}

   //read from uds, write to tcp:
   readuds();

   // }
   
   //quitting...
   serverquit = true;
   close(uds_client_socket);
   
   // protocol negotiation
   int qmesglen=strlen("tcp2uds quit\n");
   // step 1: client sends "tcp2uds quit" 
   read(tcp_client_socket,line,qmesglen);
   line[qmesglen]='\0';
   if(strcmp(line,"tcp2uds quit\n"))
   	cout << "warning: client sent " << line << " -- protocols may not comply" << endl;
   // step 2: server sends "uds2tcp quit" 
   write(tcp_client_socket,"uds2tcp quit\n",qmesglen);
   // negotiation finished
  
   close(tcp_client_socket);
   close(tcp_server_socket);
}

