// copied from testudsc
#include <iostream>
#include <cstring>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

using namespace std;

int main(int argc, char *argv[])
{
	if(argc<2){
		cout << "usage: " << argv[0] << " [server address] ([port])" << endl;
	}

	char *server_url=argv[1];
	
	// a socket descriptor; ipv4; streaming; protocol 0
	int sd=socket(PF_INET,SOCK_STREAM,0);
	int client; // client socket

	
	cout << sd << endl;
	
	// with the help of http://www.amparo.net/ce155/socket-ex.html
	sockaddr_un server_addr; // server format, address & port
	hostent * host;
	host = gethostbyname(server_url);

	if (host == NULL)
	{
	    cout << "unknown host" << endl;
	    return 0;
	}

	/* now fill in sockaddr_in for remote address */
	serv_addr.sin_family = host->h_addrtype;
	
	/* get first address in host, copy to serv_addr */
	memcpy((char *) &serv_addr.sin_addr.s_addr, host->h_addr_list[0], host->h_length);
	serv_addr.sin_port = htons(SERVER_PORT);
	memset(serv_addr.sin_zero, 0, 8);
	
	/* create local stream socket */
	client = socket(PF_INET, SOCK_STREAM, 0);
	
	if (client < 0) {
	   cout << "cannot open socket" << endl;
	   return 0;					
	}

        /* bind local socket to any port number */
        local_addr.sin_family = AF_INET;
        local_addr.sin_addr.s_addr = htonl(INADDR_ANY);
        local_addr.sin_port = htons(0);
        memset(local_addr.sin_zero, 0, 8);
        rc = bind(client, (struct sockaddr *) &local_addr, sizeof(local_addr));
        if (rc < 0)
        {
           cout << "cannot bind port TCP" << endl;
	   return 0;
	}
				   
	/* connect to server */
	rc = connect(client, (struct sockaddr *) &serv_addr, sizeof(serv_addr));
	if (rc < 0)
						    {
							            perror("cannot connect ");
								            exit(1);
									        }
	addr.sun_family=AF_INET;
	if(argc==1)
		strcpy(addr.sun_path, "/tmp/quint-uds");
	else
		strcpy(addr.sun_path, argv[1]);
	int len=strlen(addr.sun_path)+sizeof(addr.sun_family); 
	
	//cout << bind(sd,(struct sockaddr *)&addr,len) << endl;

	cout << connect(sd,(struct sockaddr *)&addr,len) << endl;

	char buf[1];
	int n;
	
	readuds:
	n = read(sd,buf,1);
	if(n) cout << buf << flush;
	if(buf[0]!='q') goto readuds;
	
	// disallow sends and receives
	cout << shutdown(sd, 2);
	return 0;
}
