// paints a lissajou figure with rotating projection plain
#include "pasport.h"
#include <iostream>

using namespace std;

int main(int argc, char *argv[]){

double x, y; // x and y coordinates
double omx, omy, omr; // x-, y- and rotation velocity
double sinx, siny, rotang; // sin(omx*t), sin(omy*t), angle of rotation
const double sqrt2 = sqrt(2.0);
int t; // time index
int maxt; // iterations
int xdim, ydim; // window width / height

maxt = 250000;
xdim = 750;
ydim = 750;

switch(argc)
{
	case 7:
		xdim=atoi(argv[6]);
	case 6:
		ydim=atoi(argv[5]);
	case 5:
		maxt=atoi(argv[4]);
	case 4:
		omx=atof(argv[1])/1000.0;
		omy=atof(argv[2])/1000.0;
		omr=atof(argv[3])/1000.0;
		break;
	default:
		cout << "syntax: " << argv[0]
			 << " [x vel] [y vel] [rot vel] ([iterations] [x pixels] [y pixels])\nusing default values" << endl;
		omx = 0.001;
		omy = 0.002;
		omr = 0.004;	

}

INITGRAPH(xdim,ydim);

for(t=0; t<maxt; t++)
{
	sinx   = sin(omx*t);
	siny   = sin(omy*t);
	rotang = omr*t;

	// rotate complex number z=sinx + i*siny by multiplying with e^i*rotang => z'=x+i*y
	// be careful with atan (doesn't go into 3rd and 4th quadrant)

	x=sqrt(sinx*sinx+siny*siny)*cos((((sinx>0)?0.0:PI)+atan(siny/sinx))+rotang);
	y=sqrt(sinx*sinx+siny*siny)*sin((((sinx>0)?0.0:PI)+atan(siny/sinx))+rotang);

	// x and y are element of [-sqrt(2);sqrt(2)]
	PUTPIXEL(int((x+sqrt2)/(2.0*sqrt2)*xdim),int((y+sqrt2)/(2.0*sqrt2)*ydim),LIGHTGREEN,0);
}

update();

READLN();

CLOSEGRAPH();

}
