// paints a lissajou figure with rotating projection plain
#include "pasport.h"
#include <iostream>

using namespace std;

Uint32 axtoi(char *hexStg) {
// from Borland
// who were actually smar enough to limit this to
// 4-digit-hex-numbers and simple int
  int n = 0;         // position in string
  int m = 0;         // position in digit[] to shift
  int count;         // loop index
  Uint32 intValue = 0;  // integer value of hex string
  int digit[9];      // hold values to convert
  while (n < 8) {
     if (hexStg[n]=='\0')
        break;
     if (hexStg[n] > 0x29 && hexStg[n] < 0x40 ) //if 0 to 9
        digit[n] = hexStg[n] & 0x0f;            //convert to int
     else if (hexStg[n] >='a' && hexStg[n] <= 'f') //if a to f
        digit[n] = (hexStg[n] & 0x0f) + 9;      //convert to int
     else if (hexStg[n] >='A' && hexStg[n] <= 'F') //if A to F
        digit[n] = (hexStg[n] & 0x0f) + 9;      //convert to int
     else break;
    n++;
  }
  count = n;
  m = n - 1;
  n = 0;
  while(n < count) {
     // digit[n] is value of hex digit at position n
     // (m << 2) is the number of positions to shift
     // OR the bits into return value
     intValue = intValue | (digit[n] << (m << 2));
     m--;   // adjust the position to set
     n++;   // next digit to process
  }
  return (intValue);
}

int main(int argc, char *argv[]){

double x, y; // x and y coordinates
double omx, omy, omr; // x-, y- and rotation velocity
double sinx, siny, rotang, rotangfmod; // sin(omx*t), sin(omy*t), angle of rotation
const double sqrt2 = sqrt(2.0);
int t; // time index
int maxt; // iterations
int xdim, ydim; // window width / height
Uint32 color, end_color; // initial color; end color
int redstep, greenstep, bluestep, satstep; // how many steps until color changed; sign decides whether +1 or -1

color = 0x000050FF;
end_color = 0xf039ffFF;
maxt = 250000;
redstep = greenstep = bluestep = satstep = 0;

xdim = 750;
ydim = 750;
rotangfmod = 0.0;

switch(argc)
{
	case 9:
		xdim=atoi(argv[8]);
	case 8:
		ydim=atoi(argv[7]);
	case 7:
		end_color=axtoi(argv[6]);
	case 6:
		color=axtoi(argv[5]);
	case 5:
		maxt=atoi(argv[4]);
	case 4:
		omx=atof(argv[1])/1000.0;
		omy=atof(argv[2])/1000.0;
		omr=atof(argv[3])/1000.0;
		break;
	default:
		cout << "syntax: " << argv[0]
			 << " [x vel] [y vel] [rot vel] ([iterations] [initial color] [end color]"
 			 << " [x pixels] [y pixels])\ncolor values should be in 0xRRGGBBAA\nusing default values" << endl;
		omx = 0.001;
		omy = 0.002;
		omr = 0.004;
}

{ // find iterations between color shift
int init_red = color >> 24;
int end_red = end_color >> 24;

int init_green = (color >> 16) % 256;
int end_green = (end_color >> 16) % 256;

int init_blue = (color >> 8) % 256;
int end_blue = (end_color >> 8) % 256;

int init_sat = color % 256;
int end_sat = end_color % 256;

if((end_red-init_red)) redstep = maxt/(end_red-init_red)+1; // +1 for rounding errors
if((end_green-init_green)) greenstep = maxt/(end_green-init_green)+1;
if((end_blue-init_blue)) bluestep = maxt/(end_blue-init_blue)+1;
if((end_sat-init_sat)) satstep = maxt/(end_sat-init_sat)+1;
}

INITGRAPH(xdim,ydim);

for(t=0; t<maxt; t++)
{
	sinx   = sin(omx*t);
	siny   = sin(omy*t);
	rotang = omr*t;

	// rotate complex number 
	// z=sinx + i*siny by multiplying with e^i*rotang => z'=x+i*y

	x=sqrt(sinx*sinx+siny*siny)*cos((((sinx>0)?0.0:PI)+atan(siny/sinx))+rotang);
	y=sqrt(sinx*sinx+siny*siny)*sin((((sinx>0)?0.0:PI)+atan(siny/sinx))+rotang);

	PUTPIXEL_C(int((x+sqrt2)/(2.0*sqrt2)*xdim),int((y+sqrt2)/(2.0*sqrt2)*ydim),color,0);

	if(redstep && t % redstep == 0)
		color = color + ((redstep>0)?1:-1)*0x01000000;
	if(greenstep && t % greenstep == 0)
		color = color + ((greenstep>0)?1:-1)*0x00010000;
	if(bluestep && t % bluestep == 0)
		color = color + ((bluestep>0)?1:-1)*0x00000100;
	if(satstep && t % satstep == 0)
		color = color + ((satstep>0)?1:-1)*0x00000001;
}

update();

READLN();

CLOSEGRAPH();

}
