/**************************************************************************
         pasport.h - zum Portieren von PASCAL-Programmen mit Grafik
                             -------------------
    begin                : April 10th 2002
    copyright            : (C) 2002 by Daniel Gruen
    email                : daniel_gruen@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _PASPORT_
#define _PASPORT_

#define C0	0x000000FF
#define C1	0x000080FF
#define C2	0x008000FF
#define C3	0x008080FF
#define C4	0x800000FF
#define C5	0x800080FF
#define C6	0x808000FF
#define C7	0xC0C0C0FF
#define C8	0x808080FF
#define C9	0x0000FFFF
#define C10	0x00FF00FF
#define C11	0x00FFFFFF
#define C12	0xFF0000FF
#define C13	0xFF00FFFF
#define C14	0xFFFF00FF
#define C15	0xFFFFFFFF

#define BLACK         0
#define BLUE          1
#define GREEN         2
#define CYAN          3
#define RED           4
#define MAGENTA       5
#define BROWN         6
#define LIGHTGRAY     7
#define DARKGRAY      8
#define LIGHTBLUE     9
#define LIGHTGREEN   10
#define LIGHTCYAN    11
#define LIGHTRED     12
#define LIGHTMAGENTA 13
#define YELLOW       14
#define WHITE        15

#ifndef PI
#define PI 3.1415926536
#endif

#ifndef E
#define E  2.7182818285
#endif

#ifndef PI180
#define PI180 0.0174532925
#endif

#include <SDL.h>
#include <SDL_gfxPrimitives.h>
#include <ctime>
#include <cstdlib>
#include <cmath>

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <sys/stat.h>
#include <linux/kd.h>
#include <sys/types.h>
#include <sys/ioctl.h>

// filledpie / filledPie confusion
#ifdef filledPieColor
#define filledpieColor filledPieColor
#endif

float  ARCTAN(float);
void   BAR(int, int, int, int, bool=1);
char   CHR(int);
void   CIRCLE(int, int, int, bool=1);
void   CLOSEGRAPH();
void   CLRSCR();
float  COS(float);
void   DELAY(int);
void   ELLIPSE(int, int, int, int, bool=1);
double EXP(double);
void   FILLELLIPSE(int, int, int, int, bool=1);
void   GOTOXY(int, int, bool=1);
void   INITGRAPH(int=640,int=480);
bool   KEYPRESSED();
void   LINE(int, int, int, int, bool=1);
void   MOVETO(int, int);
void   NOSOUND();
void   OUTTEXT(char *, bool=1);
void   OUTTEXTXY(int, int, char, bool=1);
void   OUTTEXTXY(int, int, char *, bool=1);
void   PIESLICE(int, int, int, int, int, bool=1);
void   PUTPIXEL(int, int, int, bool=1);
void   PUTPIXEL_C(int, int, Uint32, bool=1);
int    RANDOM(int);
void   RANDOMIZE();
char   READKEY();
void   READ(char *);
void   READLN();
void   READLN(char *);
void   READLN(int *);
void   READLN(float *);
int    ROUND(float);
void   SETCOLOR(int);
void   SETFILLSTYLE(int, int);
float  SIN(float);
void   SOUND(int);
float  SQR(float);
float  SQRT(float);
int    TRUNC(float);
char   UPCASE(char);
void   WRITE(char *);
void   WRITE(float);
void   WRITELN(char *);
void   WRITELN(char);
void   WRITELN(int);
void   WRITELN(float);

/*--------------------------------------*/

Uint32 translateColor(int);
void  UPDATE();

/*--------------------------------------*/

inline void  clrscr() {CLRSCR();}
inline void  initgraph() {INITGRAPH();}
inline void  putpixel(int a, int b, int c, bool d=0) {PUTPIXEL(a,b,c,d);}
inline char  readkey() {return READKEY();}
inline void  readln(float *r) {READLN(r);}
inline void  readln(char *r) {READLN(r);}
inline void  readln(int *r) {READLN(r);}
inline void  readln() {READLN();}
inline int   round(float a) {return ROUND(a);}
inline void  setcolor(int c) {SETCOLOR(c);}
inline float sqr(float x) {return SQR(x);}
inline void  update() {UPDATE();}
inline void  WRITE(float a, char *r) {WRITE(a); WRITE(r);}
inline void  WRITE(char *a, int b)  {WRITE(a); WRITE(b);}
inline void  WRITE(char *a, float b)  {WRITE(a); WRITE(b);}
inline void  WRITELN() {WRITELN("");}
inline void  writeln() {WRITELN("");}
inline void  writeln(char *r) {WRITELN(r);}
inline void  writeln(int r) {WRITELN(r);}
inline void  WRITELN(char *a, char b) {WRITE(a); WRITELN(b);}
inline void  WRITELN(char *a, int b)  {WRITE(a); WRITELN(b);}
inline void  WRITELN(float a, char *r) {WRITE(a); WRITELN(r);}
inline void  WRITELN(char *r, float a) {WRITE(r); WRITELN(a);}
inline void  WRITELN(char *r, int b, char *s) {WRITE(r); WRITE(b); WRITELN(s);}

/*--------------------------------------*/

struct dddcoord {
	float x;
	float y;
	float z;
};

struct ddcoord {
	float x;
	float y;
};

ddcoord xycoord(dddcoord);
void dddpunkt(dddcoord, int=9 ,bool=0, bool=0, bool=0);

#endif

